/*
 * Decompiled with CFR 0.152.
 */
package javachart.contrib;

import java.awt.Graphics;
import java.awt.Point;
import javachart.chart.AxisInterface;
import javachart.chart.Background;
import javachart.chart.Chart;
import javachart.chart.LineLegend;
import javachart.chart.Plotarea;
import javachart.chart.Polar;
import javachart.chart.PolarAxis;
import javachart.contrib.DailyPolar;

public class DailyPolarChart
extends Chart {
    DailyPolar polar;
    PolarAxis axis;
    boolean lineVisible = true;

    public DailyPolarChart() {
    }

    public DailyPolarChart(String string) {
        super(string);
    }

    public DailyPolarChart(String string, Graphics graphics) {
        super(string, graphics);
    }

    public synchronized void drawGraph() {
        if (this.canvas == null) {
            return;
        }
        this.drawGraph(this.canvas);
    }

    public synchronized void drawGraph(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.drawGraph(graphics);
        this.background.draw(graphics);
        this.plotarea.draw(graphics);
        this.axis.draw(graphics);
        this.polar.draw(graphics);
        if (this.legendVisible) {
            this.legend.draw(graphics);
        }
    }

    public AxisInterface getAxis() {
        return this.axis;
    }

    public boolean getLineVisible() {
        return this.lineVisible;
    }

    public Polar getPolar() {
        return this.polar;
    }

    protected void initAxes() {
        this.axis = new PolarAxis(this.datasets, false, this.plotarea);
        this.axis.setManualSpoking(true);
        this.axis.setNumSpokes(4);
    }

    protected void initChart() {
        this.initGlobals();
        this.plotarea = new Plotarea(this.globals);
        this.background = new Background(this.globals);
        this.initDataSets();
        this.initAxes();
        this.polar = new DailyPolar(this.datasets, this.axis, this.plotarea);
        this.legend = new LineLegend(this.datasets, this.globals);
        this.resize(640, 480);
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        this.axis.center = new Point(n / 2, n2 / 2);
    }

    public void setAxis(PolarAxis polarAxis) {
    }

    public void setLineVisible(boolean bl) {
        this.lineVisible = bl;
        this.polar.setScatterPlot(!bl);
    }

    public void setPolar(DailyPolar dailyPolar) {
        this.polar = dailyPolar;
    }
}

