/*
 * Decompiled with CFR 0.152.
 */
package javachart.contrib;

import java.awt.Point;
import java.util.Date;
import javachart.chart.Dataset;
import javachart.chart.Plotarea;
import javachart.chart.Polar;
import javachart.chart.PolarAxis;

public class DailyPolar
extends Polar {
    final long ONE_DAY = 86400000L;
    Date tmpDate = new Date(0L);

    public DailyPolar(Dataset[] datasetArray, PolarAxis polarAxis, Plotarea plotarea) {
        super(datasetArray, polarAxis, plotarea);
    }

    private double getAngleFromTimeOfDay(long l) {
        this.tmpDate.setTime(l);
        this.tmpDate.setHours(0);
        this.tmpDate.setMinutes(0);
        this.tmpDate.setSeconds(0);
        long l2 = l - this.tmpDate.getTime();
        double d = (double)l2 / 8.64E7;
        return d * 360.0;
    }

    protected Point[] rotateData(Point[] pointArray, Dataset dataset) {
        int n = pointArray.length;
        Point[] pointArray2 = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            double d = pointArray[n2].x - this.axis.center.x;
            double d2 = pointArray[n2].y - this.axis.center.y;
            double d3 = this.getAngleFromTimeOfDay((long)dataset.getDataElementAt(n2).getX());
            double d4 = Math.cos(Math.PI * d3 / 180.0);
            double d5 = Math.sin(Math.PI * d3 / 180.0);
            double d6 = d * d4 - d2 * d5 + (double)this.axis.center.x;
            double d7 = d * d5 + d2 * d4 + (double)this.axis.center.y;
            pointArray2[n2] = new Point((int)d6, (int)d7);
            ++n2;
        }
        return pointArray2;
    }
}

