/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Background;
import javachart.chart.Chart;
import javachart.chart.DateAxis;
import javachart.chart.LabelAxis;
import javachart.chart.Legend;
import javachart.chart.Plotarea;
import javachart.chart.Stick;

public class StickChart
extends Chart {
    Stick stick;
    AxisInterface xAxis;
    AxisInterface yAxis;

    public StickChart() {
    }

    public StickChart(String string) {
        super(string);
    }

    public StickChart(String string, Graphics graphics) {
        super(string, graphics);
    }

    public void drawGraph() {
        if (this.canvas == null) {
            return;
        }
        this.drawGraph(this.canvas);
    }

    public void drawGraph(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.drawGraph();
        this.background.draw(graphics);
        this.plotarea.draw(graphics);
        if (this.xAxisVisible) {
            this.xAxis.draw(graphics);
        } else {
            this.xAxis.scale();
        }
        if (this.yAxisVisible) {
            this.yAxis.draw(graphics);
        } else {
            this.yAxis.scale();
        }
        this.stick.draw(graphics);
        if (this.legendVisible) {
            this.legend.draw(graphics);
        }
    }

    public Stick getStick() {
        return this.stick;
    }

    public AxisInterface getXAxis() {
        return this.xAxis;
    }

    public AxisInterface getYAxis() {
        return this.yAxis;
    }

    protected void initAxes() {
        this.xAxis = new DateAxis(this.datasets, true, this.plotarea);
        this.xAxis.setBarScaling(true);
        this.yAxis = new Axis(this.datasets, false, this.plotarea);
        this.yAxis.setBarScaling(true);
    }

    protected void initChart() {
        this.initGlobals();
        this.plotarea = new Plotarea(this.globals);
        this.background = new Background(this.globals);
        this.initDataSets();
        this.initAxes();
        this.stick = new Stick(this.datasets, this.xAxis, this.yAxis, this.plotarea);
        this.legend = new Legend(this.datasets, this.globals);
        this.resize(640, 480);
    }

    public void setStick(Stick stick) {
        this.stick = stick;
    }

    public void setXAxis(LabelAxis labelAxis) {
        this.xAxis = labelAxis;
    }

    public void setYAxis(Axis axis) {
        this.yAxis = axis;
    }
}

