/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import javachart.chart.AxisInterface;
import javachart.chart.Bar;
import javachart.chart.Dataset;
import javachart.chart.Gc;
import javachart.chart.Plotarea;

public class StackColumn
extends Bar {
    StackColumn(Dataset[] datasetArray, AxisInterface axisInterface, AxisInterface axisInterface2, Plotarea plotarea) {
        super(datasetArray, axisInterface, axisInterface2, plotarea);
    }

    protected double getBaseY(int n, int n2) {
        double d = this.baseline;
        if (this.datasets[n].getDataElementAt((int)n2).y > this.baseline) {
            int n3 = 0;
            while (n3 < n) {
                if (this.datasets[n3].getDataElementAt((int)n2).y > this.baseline) {
                    d += this.datasets[n3].getDataElementAt((int)n2).y;
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                if (this.datasets[n4].getDataElementAt((int)n2).y < this.baseline) {
                    d += this.datasets[n4].getDataElementAt((int)n2).y;
                }
                ++n4;
            }
        }
        return d;
    }

    protected boolean topBar(int n, int n2) {
        int n3 = this.datasetsInUse() - 1;
        if (n == n3 && this.datasets[n].getDataElementAt((int)n2).y > this.baseline) {
            return true;
        }
        if (this.datasets[n].getDataElementAt((int)n2).y == this.baseline) {
            return false;
        }
        int n4 = n + 1;
        while (this.datasets[n4] != null) {
            if (this.datasets[n4].getDataElementAt((int)n2).y > this.baseline) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    protected void doBar(Graphics graphics, double d, int n, int n2, boolean bl) {
        double d2;
        double d3 = 0.5 * this.clusterWidth;
        double d4 = (double)n2 - d3;
        double d5 = d4 + this.clusterWidth;
        double d6 = this.getBaseY(n, n2);
        try {
            d2 = d6 + this.datasets[n].getDataElementAt((int)n2).y;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        Gc gc = !bl ? this.datasets[n].gc : this.datasets[n].getDataElementAt((int)n2).gc;
        gc.fillRect(graphics, this.dataXfm.point(d4, d6), this.dataXfm.point(d5, d2));
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.globals.displayList.addRectangle(this.datasets[n], this.dataXfm.point(d4, d6), this.dataXfm.point(d5, d2));
            this.globals.displayList.addRectangle(this.datasets[n].getDataElementAt(n2), this.dataXfm.point(d4, d6), this.dataXfm.point(d5, d2));
        }
    }

    protected void doDBar(Graphics graphics, double d, int n, int n2, boolean bl) {
        double d2;
        double d3 = 0.5 * this.clusterWidth;
        Point[] pointArray = new Point[4];
        double d4 = (double)n2 - d3;
        double d5 = d4 + this.clusterWidth;
        double d6 = this.getBaseY(n, n2);
        try {
            d2 = d6 + this.datasets[n].getDataElementAt((int)n2).y;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        Gc gc = !bl ? this.datasets[n].gc : this.datasets[n].getDataElementAt((int)n2).gc;
        if (d6 < d2) {
            pointArray[0] = this.dataXfm.point(d4, d6);
            pointArray[1] = this.dataXfm.point(d5, d2);
        } else {
            pointArray[0] = this.dataXfm.point(d4, d2);
            pointArray[1] = this.dataXfm.point(d5, d6);
        }
        gc.fillRect(graphics, pointArray[0], pointArray[1]);
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.globals.displayList.addRectangle(this.datasets[n], pointArray[0], pointArray[1]);
            this.globals.displayList.addRectangle(this.datasets[n].getDataElementAt(n2), pointArray[0], pointArray[1]);
        }
        Color color = gc.fillColor;
        gc.fillColor = color.darker();
        int n3 = pointArray[0].x;
        pointArray[0].x = pointArray[1].x;
        pointArray[2] = new Point(pointArray[1].x + this.globals.xOffset, pointArray[1].y + this.globals.yOffset);
        pointArray[3] = new Point(pointArray[0].x + this.globals.xOffset, pointArray[0].y + this.globals.yOffset);
        gc.drawPolygon(graphics, pointArray);
        if (this.topBar(n, n2)) {
            pointArray[0].x = n3;
            pointArray[0].y = pointArray[1].y;
            pointArray[3].x = pointArray[0].x + this.globals.xOffset;
            pointArray[3].y = pointArray[0].y + this.globals.yOffset;
            gc.drawPolygon(graphics, pointArray);
        }
        gc.fillColor = color;
    }

    protected void doBarLabel(Graphics graphics, double d, int n, int n2) {
        String string;
        double d2 = 0.5 * this.clusterWidth;
        double d3 = (double)n2 - d2;
        double d4 = d3 + this.clusterWidth;
        double d5 = this.getBaseY(n, n2);
        double d6 = d5 + this.datasets[n].getDataElementAt((int)n2).y;
        if (this.datasets[n].getDataElementAt((int)n2).label != null) {
            graphics.setFont(this.datasets[n].labelFont);
            graphics.setColor(this.datasets[n].labelColor);
            string = this.datasets[n].getDataElementAt((int)n2).label;
        } else {
            if (this.datasets[n].getDataElementAt((int)n2).y == 0.0) {
                return;
            }
            if (this.datasets[n].labelFont == null) {
                graphics.setFont(new Font("TimesRoman", 0, 12));
            } else {
                graphics.setFont(this.datasets[n].labelFont);
            }
            if (this.datasets[n].labelColor == null) {
                graphics.setColor(Color.black);
            } else {
                graphics.setColor(this.datasets[n].labelColor);
            }
            string = Double.toString(this.datasets[n].getDataElementAt((int)n2).y);
            int n3 = string.indexOf("e");
            if (n3 == -1) {
                n3 = string.indexOf("E");
            }
            if (n3 == -1) {
                string = Gc.formattedLabel(string, this.labelFormat, this.labelPrecision);
            } else {
                string = Gc.nonSciNumberStr(string, n3);
                string = Gc.formattedLabel(string, this.labelFormat, this.labelPrecision);
            }
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Point point = this.dataXfm.point(d3 + (d4 - d3) / 2.0, d5 + (d6 - d5) / 2.0);
        this.datasets[n].gc.drawSmartString(graphics, point.x, point.y, 2, this.labelAngle, fontMetrics, string);
    }
}

