/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Gc;
import javachart.chart.Plotarea;
import javachart.chart.StackColumn;
import javachart.chart.Transform;

public class StackBar
extends StackColumn {
    public StackBar(Dataset[] datasetArray, AxisInterface axisInterface, AxisInterface axisInterface2, Plotarea plotarea) {
        super(datasetArray, axisInterface, axisInterface2, plotarea);
    }

    protected void buildDataXfm() {
        this.xAxisStart = this.xAxis.getAxisStart();
        this.xAxisEnd = this.xAxis.getAxisEnd();
        this.yAxisStart = this.yAxis.getAxisStart();
        this.yAxisEnd = this.yAxis.getAxisEnd();
        this.dataXfm = new Transform(this.yAxisStart, this.xAxisStart, this.yAxisEnd, this.xAxisEnd, this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY));
        this.dataXfm.logXScaling = this.yAxis.getLogScaling();
        this.dataXfm.logYScaling = this.xAxis.getLogScaling();
    }

    protected void doBar(Graphics graphics, double d, int n, int n2, boolean bl) {
        double d2;
        double d3 = 0.5 * this.clusterWidth;
        double d4 = (double)n2 - d3;
        double d5 = d4 + this.clusterWidth;
        double d6 = this.getBaseY(n, n2);
        try {
            d2 = d6 + this.datasets[n].getDataElementAt((int)n2).y;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        if (!bl) {
            this.datasets[n].gc.fillRect(graphics, this.dataXfm.point(d6, d4), this.dataXfm.point(d2, d5));
        } else {
            this.datasets[n].getDataElementAt((int)n2).gc.fillRect(graphics, this.dataXfm.point(d6, d4), this.dataXfm.point(d2, d5));
        }
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.globals.displayList.addRectangle(this.datasets[n], this.dataXfm.point(d6, d4), this.dataXfm.point(d2, d5));
            this.globals.displayList.addRectangle(this.datasets[n].getDataElementAt(n2), this.dataXfm.point(d6, d4), this.dataXfm.point(d2, d5));
        }
    }

    protected void doDBar(Graphics graphics, double d, int n, int n2, boolean bl) {
        double d2;
        double d3 = 0.5 * this.clusterWidth;
        double d4 = (double)n2 - d3;
        double d5 = d4 + this.clusterWidth;
        double d6 = this.getBaseY(n, n2);
        try {
            d2 = d6 + this.datasets[n].getDataElementAt((int)n2).y;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        Gc gc = !bl ? this.datasets[n].gc : this.datasets[n].getDataElementAt((int)n2).gc;
        Point[] pointArray = new Point[4];
        if (d2 > d6) {
            pointArray[0] = this.dataXfm.point(d6, d4);
            pointArray[1] = this.dataXfm.point(d2, d5);
        } else {
            pointArray[0] = this.dataXfm.point(d2, d4);
            pointArray[1] = this.dataXfm.point(d6, d5);
        }
        gc.fillRect(graphics, pointArray[0], pointArray[1]);
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.globals.displayList.addRectangle(this.datasets[n], pointArray[0], pointArray[1]);
            this.globals.displayList.addRectangle(this.datasets[n].getDataElementAt(n2), pointArray[0], pointArray[1]);
        }
        Color color = gc.fillColor;
        gc.fillColor = color.darker();
        int n3 = pointArray[0].y;
        pointArray[0].y = pointArray[1].y;
        pointArray[2] = new Point(pointArray[1].x + this.globals.xOffset, pointArray[1].y + this.globals.yOffset);
        pointArray[3] = new Point(pointArray[0].x + this.globals.xOffset, pointArray[0].y + this.globals.yOffset);
        gc.drawPolygon(graphics, pointArray);
        if (this.topBar(n, n2)) {
            pointArray[0].x = pointArray[1].x;
            pointArray[0].y = n3;
            pointArray[2].x = pointArray[1].x + this.globals.xOffset;
            pointArray[2].y = pointArray[1].y + this.globals.yOffset;
            pointArray[3].x = pointArray[0].x + this.globals.xOffset;
            pointArray[3].y = pointArray[0].y + this.globals.yOffset;
            gc.drawPolygon(graphics, pointArray);
        }
        gc.fillColor = color;
    }

    protected void doBarLabel(Graphics graphics, double d, int n, int n2) {
        String string;
        double d2;
        double d3 = 0.5 * this.clusterWidth;
        double d4 = (double)n2 - d3;
        double d5 = d4 + this.clusterWidth;
        double d6 = this.getBaseY(n, n2);
        try {
            d2 = d6 + this.datasets[n].getDataElementAt((int)n2).y;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            d2 = d6;
        }
        if (this.datasets[n].getDataElementAt((int)n2).label != null) {
            string = this.datasets[n].getDataElementAt((int)n2).label;
        } else {
            if (this.datasets[n].getDataElementAt((int)n2).y == 0.0) {
                return;
            }
            string = Double.toString(this.datasets[n].getDataElementAt((int)n2).y);
            int n3 = string.indexOf("e");
            if (n3 == -1) {
                n3 = string.indexOf("E");
            }
            if (n3 == -1) {
                string = Gc.formattedLabel(string, this.labelFormat, this.labelPrecision);
            } else {
                string = Gc.nonSciNumberStr(string, n3);
                string = Gc.formattedLabel(string, this.labelFormat, this.labelPrecision);
            }
        }
        graphics.setFont(this.datasets[n].labelFont);
        graphics.setColor(this.datasets[n].labelColor);
        Point point = this.dataXfm.point(d6 + (d2 - d6) / 2.0, d4 + (d5 - d4) / 2.0);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.datasets[n].gc.drawSmartString(graphics, point.x, point.y, 2, this.labelAngle, fontMetrics, string);
    }
}

