/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import javachart.chart.AxisInterface;
import javachart.chart.Background;
import javachart.chart.Chart;
import javachart.chart.Plotarea;
import javachart.chart.Speedo;
import javachart.chart.SpeedoAxis;

public class SpeedoChart
extends Chart {
    Speedo speedo;
    SpeedoAxis yAxis;

    public SpeedoChart() {
    }

    public SpeedoChart(String string) {
        super(string);
    }

    public SpeedoChart(String string, Graphics graphics) {
        super(string, graphics);
    }

    public void drawGraph() {
        if (this.canvas == null) {
            return;
        }
        this.drawGraph(this.canvas);
    }

    public void drawGraph(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.drawGraph();
        this.background.draw(graphics);
        this.plotarea.draw(graphics);
        if (this.speedo.needleStyle == 3) {
            if (this.yAxisVisible) {
                this.yAxis.draw(graphics);
            }
            this.speedo.draw(graphics);
            if (this.yAxisVisible) {
                this.yAxis.draw(graphics);
            }
        } else {
            if (this.yAxisVisible) {
                this.yAxis.draw(graphics);
            } else {
                this.yAxis.scale();
            }
            this.speedo.draw(graphics);
        }
    }

    public Speedo getSpeedo() {
        return this.speedo;
    }

    public AxisInterface getYAxis() {
        return this.yAxis;
    }

    protected void initAxes() {
        this.yAxis = new SpeedoAxis(this.datasets, false, this.plotarea);
        this.yAxis.setBarScaling(true);
    }

    protected void initChart() {
        this.initGlobals();
        this.plotarea = new Plotarea(this.globals);
        this.background = new Background(this.globals);
        this.initDataSets();
        this.initAxes();
        this.speedo = new Speedo(this.datasets, this.yAxis, this.plotarea);
        this.resize(640, 480);
    }

    public void resize(int n, int n2) {
        this.globals.maxY = n2;
        this.plotarea.resize(n, n2);
        this.background.resize(n, n2);
    }

    public void setSpeedo(Speedo speedo) {
        this.speedo = speedo;
    }

    public void setYAxis(SpeedoAxis speedoAxis) {
        this.yAxis = speedoAxis;
    }
}

