/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Plotarea;

public class SpeedoAxis
extends Axis
implements AxisInterface {
    int speedoPosition = 1;
    boolean labelsInside = true;
    int startAngle;
    int arcLength = 360;
    double centerX = 0.5;
    double centerY = 0.5;
    double hCircleSize;
    double vCircleSize;

    SpeedoAxis(Dataset[] datasetArray, boolean bl, Plotarea plotarea) {
        super(datasetArray, false, plotarea);
        this.setSpeedoPosition(1);
    }

    public void setLogScaling(boolean bl) {
    }

    public void setLabelsInside(boolean bl) {
        this.labelsInside = bl;
    }

    public boolean getLabelsInside() {
        return this.labelsInside;
    }

    public void setSpeedoPosition(int n) {
        this.speedoPosition = n;
        switch (this.speedoPosition) {
            case 0: {
                this.startAngle = 315;
                this.arcLength = 270;
                return;
            }
            case 1: {
                this.startAngle = 0;
                this.arcLength = 180;
                return;
            }
            case 2: {
                this.startAngle = 0;
                this.arcLength = -180;
                return;
            }
            case 3: {
                this.startAngle = 90;
                this.arcLength = -180;
                return;
            }
            case 4: {
                this.startAngle = 90;
                this.arcLength = 180;
                return;
            }
            case 5: {
                this.startAngle = 90;
                this.arcLength = -90;
                return;
            }
            case 6: {
                this.startAngle = 90;
                this.arcLength = 90;
                return;
            }
            case 7: {
                this.startAngle = 180;
                this.arcLength = 90;
                return;
            }
            case 8: {
                this.startAngle = 0;
                this.arcLength = -90;
                return;
            }
        }
    }

    public int getSpeedoPosition() {
        return this.speedoPosition;
    }

    public synchronized void draw(Graphics graphics) {
        if (this.autoScale) {
            this.scale();
        }
        this.drawSALine(graphics);
        this.drawScale(graphics);
    }

    private void drawSALine(Graphics graphics) {
        switch (this.speedoPosition) {
            case 0: {
                this.hCircleSize = this.plotarea.urX - this.plotarea.llX;
                this.centerX = this.plotarea.llX + this.hCircleSize / 2.0;
                this.vCircleSize = this.plotarea.urY - this.plotarea.llY;
                this.centerY = this.plotarea.llY + this.vCircleSize / 2.0;
                break;
            }
            case 1: {
                this.hCircleSize = this.plotarea.urX - this.plotarea.llX;
                this.centerX = this.plotarea.llX + this.hCircleSize / 2.0;
                this.centerY = this.plotarea.llY;
                this.vCircleSize = (this.plotarea.urY - this.plotarea.llY) * 2.0;
                break;
            }
            case 2: {
                this.hCircleSize = this.plotarea.urX - this.plotarea.llX;
                this.centerX = this.plotarea.llX + this.hCircleSize / 2.0;
                this.centerY = this.plotarea.urY;
                this.vCircleSize = (this.plotarea.urY - this.plotarea.llY) * 2.0;
                break;
            }
            case 3: {
                this.hCircleSize = (this.plotarea.urX - this.plotarea.llX) * 2.0;
                this.centerX = this.plotarea.llX;
                this.vCircleSize = this.plotarea.urY - this.plotarea.llY;
                this.centerY = this.plotarea.llY + this.vCircleSize / 2.0;
                break;
            }
            case 4: {
                this.hCircleSize = (this.plotarea.urX - this.plotarea.llX) * 2.0;
                this.centerX = this.plotarea.urX;
                this.vCircleSize = this.plotarea.urY - this.plotarea.llY;
                this.centerY = this.plotarea.llY + this.vCircleSize / 2.0;
                break;
            }
            case 5: {
                this.hCircleSize = (this.plotarea.urX - this.plotarea.llX) * 2.0;
                this.centerX = this.plotarea.llX;
                this.vCircleSize = (this.plotarea.urY - this.plotarea.llY) * 2.0;
                this.centerY = this.plotarea.llY;
                break;
            }
            case 6: {
                this.hCircleSize = (this.plotarea.urX - this.plotarea.llX) * 2.0;
                this.centerX = this.plotarea.urX;
                this.vCircleSize = (this.plotarea.urY - this.plotarea.llY) * 2.0;
                this.centerY = this.plotarea.llY;
                break;
            }
            case 7: {
                this.hCircleSize = (this.plotarea.urX - this.plotarea.llX) * 2.0;
                this.centerX = this.plotarea.urX;
                this.vCircleSize = (this.plotarea.urY - this.plotarea.llY) * 2.0;
                this.centerY = this.plotarea.urY;
                break;
            }
            case 8: {
                this.hCircleSize = (this.plotarea.urX - this.plotarea.llX) * 2.0;
                this.centerX = this.plotarea.llX;
                this.vCircleSize = (this.plotarea.urY - this.plotarea.llY) * 2.0;
                this.centerY = this.plotarea.urY;
                break;
            }
        }
        if (this.lineVis) {
            this.lineGc.fillColor = this.lineGc.lineColor;
            this.lineGc.drawArc(graphics, this.plotarea.transform.point(this.centerX, this.centerY), this.plotarea.transform.point(this.hCircleSize, this.vCircleSize), this.startAngle, this.arcLength);
        }
    }

    private void drawScale(Graphics graphics) {
        if (this.majTickVis) {
            this.drawMajTicks(graphics);
        }
        if (this.labelVis) {
            this.drawSALabels(graphics);
        }
        if (this.minTickVis) {
            this.drawMinTicks(graphics);
        }
    }

    private void drawMajTicks(Graphics graphics) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = 0.5 - (double)this.majTickLength / (double)this.globals.maxY;
        float f = this.getIncrement(this.startAngle + this.arcLength, this.startAngle, this.numMajTicks);
        int n = 0;
        while (n < this.numMajTicks) {
            d5 = (double)((float)(this.startAngle + this.arcLength) - (float)n * f) / 180.0 * Math.PI;
            d4 = this.centerX + this.hCircleSize * 0.5 * Math.cos(d5);
            d3 = this.centerY + this.vCircleSize * 0.5 * Math.sin(d5);
            d2 = this.centerX + this.hCircleSize * d6 * Math.cos(d5);
            d = this.centerY + this.vCircleSize * d6 * Math.sin(d5);
            this.tickGc.drawLine(graphics, this.plotarea.transform.point(d2, d), this.plotarea.transform.point(d4, d3));
            ++n;
        }
        d5 = (double)this.startAngle / 180.0 * Math.PI;
        d4 = this.centerX + this.hCircleSize * 0.5 * Math.cos(d5);
        d3 = this.centerY + this.vCircleSize * 0.5 * Math.sin(d5);
        d2 = this.centerX + this.hCircleSize * d6 * Math.cos(d5);
        d = this.centerY + this.vCircleSize * d6 * Math.sin(d5);
        this.tickGc.drawLine(graphics, this.plotarea.transform.point(d2, d), this.plotarea.transform.point(d4, d3));
    }

    private void drawMinTicks(Graphics graphics) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = 0.5 - (double)this.minTickLength / (double)this.globals.maxY;
        float f = this.getIncrement(this.startAngle + this.arcLength, this.startAngle, this.numMinTicks);
        int n = 0;
        while (n < this.numMinTicks) {
            d5 = (double)((float)(this.startAngle + this.arcLength) - (float)n * f) / 180.0 * Math.PI;
            d4 = this.centerX + this.hCircleSize * 0.5 * Math.cos(d5);
            d3 = this.centerY + this.vCircleSize * 0.5 * Math.sin(d5);
            d2 = this.centerX + this.hCircleSize * d6 * Math.cos(d5);
            d = this.centerY + this.vCircleSize * d6 * Math.sin(d5);
            this.tickGc.drawLine(graphics, this.plotarea.transform.point(d2, d), this.plotarea.transform.point(d4, d3));
            ++n;
        }
        d5 = (double)this.startAngle / 180.0 * Math.PI;
        d4 = this.centerX + this.hCircleSize * 0.5 * Math.cos(d5);
        d3 = this.centerY + this.vCircleSize * 0.5 * Math.sin(d5);
        d2 = this.centerX + this.hCircleSize * d6 * Math.cos(d5);
        d = this.centerY + this.vCircleSize * d6 * Math.sin(d5);
        this.tickGc.drawLine(graphics, this.plotarea.transform.point(d2, d), this.plotarea.transform.point(d4, d3));
    }

    private void drawSALabels(Graphics graphics) {
        if (this.labelsInside) {
            this.drawInsideLabels(graphics);
            return;
        }
        this.drawOutsideLabels(graphics);
    }

    private void drawInsideLabels(Graphics graphics) {
        String string;
        Point point;
        double d;
        double d2;
        double d3;
        graphics.setFont(this.labelFont);
        graphics.setColor(this.labelColor);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        double d4 = 0.5 - (double)this.majTickLength / (double)this.globals.maxY;
        double d5 = (this.axisEnd - this.axisStart) / (double)this.numLabels;
        float f = this.getIncrement(this.startAngle + this.arcLength, this.startAngle, this.numLabels);
        int n = 0;
        while (n < this.numLabels) {
            d3 = (double)((float)(this.startAngle + this.arcLength) - (float)n * f) / 180.0 * Math.PI;
            d2 = this.centerX + this.hCircleSize * d4 * Math.cos(d3);
            d = this.centerY + this.vCircleSize * d4 * Math.sin(d3);
            point = this.plotarea.transform.point(d2, d);
            string = this.getLabel(this.axisStart + d5 * (double)n, 0);
            if (Math.sin(d3) > 0.0) {
                this.lineGc.drawString(graphics, point.x - (int)((1.0 + Math.cos(d3)) * (double)fontMetrics.stringWidth(string) / 2.0), point.y - fontMetrics.getAscent(), string);
            } else {
                this.lineGc.drawString(graphics, point.x - (int)((1.0 + Math.cos(d3)) * (double)fontMetrics.stringWidth(string) / 2.0), point.y + 3, string);
            }
            ++n;
        }
        d3 = (double)this.startAngle / 180.0 * Math.PI;
        d2 = this.centerX + this.hCircleSize * d4 * Math.cos(d3);
        d = this.centerY + this.vCircleSize * d4 * Math.sin(d3);
        point = this.plotarea.transform.point(d2, d);
        string = this.getLabel(this.axisStart + d5 * (double)n, 0);
        if (Math.sin(d3) > 0.0) {
            this.lineGc.drawString(graphics, point.x - (int)((1.0 + Math.cos(d3)) * (double)fontMetrics.stringWidth(string) / 2.0), point.y - fontMetrics.getAscent(), string);
            return;
        }
        this.lineGc.drawString(graphics, point.x - (int)((1.0 + Math.cos(d3)) * (double)fontMetrics.stringWidth(string) / 2.0), point.y + 3, string);
    }

    private void drawOutsideLabels(Graphics graphics) {
        String string;
        Point point;
        double d;
        double d2;
        double d3;
        graphics.setFont(this.labelFont);
        graphics.setColor(this.labelColor);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        double d4 = 0.52;
        double d5 = (this.axisEnd - this.axisStart) / (double)this.numLabels;
        float f = this.getIncrement(this.startAngle + this.arcLength, this.startAngle, this.numLabels);
        int n = 0;
        while (n < this.numLabels) {
            d3 = (double)((float)(this.startAngle + this.arcLength) - (float)n * f) / 180.0 * Math.PI;
            d2 = this.centerX + this.hCircleSize * d4 * Math.cos(d3);
            d = this.centerY + this.vCircleSize * d4 * Math.sin(d3);
            point = this.plotarea.transform.point(d2, d);
            string = this.getLabel(this.axisStart + d5 * (double)n, 0);
            if (Math.cos(d3) > 0.0) {
                if (Math.sin(d3) >= 0.0) {
                    this.lineGc.drawString(graphics, point.x, point.y, string);
                } else {
                    this.lineGc.drawString(graphics, point.x, point.y - fontMetrics.getAscent(), string);
                }
            } else if (Math.sin(d3) >= 0.0) {
                this.lineGc.drawString(graphics, point.x - fontMetrics.stringWidth(string), point.y, string);
            } else {
                this.lineGc.drawString(graphics, point.x - fontMetrics.stringWidth(string), point.y - fontMetrics.getAscent(), string);
            }
            ++n;
        }
        d3 = (double)this.startAngle / 180.0 * Math.PI;
        d2 = this.centerX + this.hCircleSize * d4 * Math.cos(d3);
        d = this.centerY + this.vCircleSize * d4 * Math.sin(d3);
        point = this.plotarea.transform.point(d2, d);
        string = this.getLabel(this.axisStart + d5 * (double)n, 0);
        if (Math.cos(d3) > 0.0) {
            if (Math.sin(d3) >= 0.0) {
                this.lineGc.drawString(graphics, point.x, point.y, string);
                return;
            }
            this.lineGc.drawString(graphics, point.x, point.y - fontMetrics.getAscent(), string);
            return;
        }
        if (Math.sin(d3) >= 0.0) {
            this.lineGc.drawString(graphics, point.x - fontMetrics.stringWidth(string), point.y, string);
            return;
        }
        this.lineGc.drawString(graphics, point.x - fontMetrics.stringWidth(string), point.y - fontMetrics.getAscent(), string);
    }
}

