/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import javachart.chart.Dataset;
import javachart.chart.Plotarea;
import javachart.chart.SpeedoAxis;

public class Speedo
implements Serializable {
    int needleStyle;
    double alarmThreshold;
    SpeedoAxis axis;
    Plotarea plotarea;
    Dataset[] datasets;

    public Speedo(Dataset[] datasetArray, SpeedoAxis speedoAxis, Plotarea plotarea) {
        this.datasets = datasetArray;
        this.axis = speedoAxis;
        this.plotarea = plotarea;
    }

    public synchronized void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.doNeedle(graphics);
    }

    public double getAlarmThreshold() {
        return this.alarmThreshold;
    }

    public void setAlarmThreshold(double d) {
        this.alarmThreshold = d;
    }

    public int getNeedleStyle() {
        return this.needleStyle;
    }

    public void setNeedleStyle(int n) {
        this.needleStyle = n;
    }

    protected void doNeedle(Graphics graphics) {
        double d = this.datasets[0].getDataElementAt((int)0).y;
        double d2 = this.axis.centerX;
        double d3 = this.axis.centerY;
        double d4 = (double)this.axis.arcLength / (this.axis.axisEnd - this.axis.axisStart);
        double d5 = (double)this.axis.startAngle + (double)this.axis.arcLength - (d - this.axis.axisStart) * d4;
        double d6 = d5 / 180.0 * Math.PI;
        double d7 = this.axis.centerX + this.axis.hCircleSize * 0.5 * Math.cos(d6);
        double d8 = this.axis.centerY + this.axis.vCircleSize * 0.5 * Math.sin(d6);
        switch (this.needleStyle) {
            case 0: {
                this.doArrowLine(graphics, d2, d3, d7, d8, d6);
                return;
            }
            case 1: {
                this.datasets[0].gc.drawLine(graphics, this.plotarea.transform.point(d2, d3), this.plotarea.transform.point(d7, d8));
                return;
            }
            case 2: {
                this.doFatPointer(graphics, d7, d8, d6);
                return;
            }
            case 3: {
                this.doSweepRegion(graphics, (int)d5);
                return;
            }
        }
    }

    private void doArrowLine(Graphics graphics, double d, double d2, double d3, double d4, double d5) {
        this.datasets[0].gc.drawLine(graphics, this.plotarea.transform.point(d, d2), this.plotarea.transform.point(d3, d4));
        double d6 = this.axis.centerX + this.axis.hCircleSize * 0.45 * Math.cos(d5 -= 0.10471975511965977);
        double d7 = this.axis.centerY + this.axis.vCircleSize * 0.45 * Math.sin(d5);
        this.datasets[0].gc.drawLine(graphics, this.plotarea.transform.point(d3, d4), this.plotarea.transform.point(d6, d7));
        d6 = this.axis.centerX + this.axis.hCircleSize * 0.45 * Math.cos(d5 += 0.20943951023931953);
        d7 = this.axis.centerY + this.axis.vCircleSize * 0.45 * Math.sin(d5);
        this.datasets[0].gc.drawLine(graphics, this.plotarea.transform.point(d3, d4), this.plotarea.transform.point(d6, d7));
    }

    private void doFatPointer(Graphics graphics, double d, double d2, double d3) {
        double d4 = 1.5707963267948966;
        Point[] pointArray = new Point[5];
        double d5 = this.axis.centerX + 0.01 * Math.cos(d3 + d4);
        double d6 = this.axis.centerY + 0.01 * Math.sin(d3 + d4);
        double d7 = this.axis.centerX + 0.01 * Math.cos(d3 - d4);
        double d8 = this.axis.centerY + 0.01 * Math.sin(d3 - d4);
        double d9 = d7 + this.axis.hCircleSize * 0.45 * Math.cos(d3);
        double d10 = d8 + this.axis.vCircleSize * 0.45 * Math.sin(d3);
        double d11 = d5 + this.axis.hCircleSize * 0.45 * Math.cos(d3);
        double d12 = d6 + this.axis.vCircleSize * 0.45 * Math.sin(d3);
        pointArray[0] = this.plotarea.transform.point(d5, d6);
        pointArray[1] = this.plotarea.transform.point(d7, d8);
        pointArray[2] = this.plotarea.transform.point(d9, d10);
        pointArray[3] = this.plotarea.transform.point(d, d2);
        pointArray[4] = this.plotarea.transform.point(d11, d12);
        this.datasets[0].gc.drawPolygon(graphics, pointArray);
    }

    protected void doSweepRegion(Graphics graphics, int n) {
        int n2;
        int n3;
        if (this.axis.arcLength < 0) {
            n3 = this.axis.startAngle + this.axis.arcLength;
            n2 = n3 - n;
        } else {
            n3 = n;
            n2 = this.axis.startAngle + this.axis.arcLength - n;
        }
        if (n3 < 0) {
            n2 = -n2;
        }
        this.datasets[0].gc.fillArc(graphics, this.plotarea.transform.point(this.axis.centerX, this.axis.centerY), this.plotarea.transform.point(this.axis.hCircleSize, this.axis.vCircleSize), n3, n2);
    }
}

