/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import java.awt.Point;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Line;
import javachart.chart.Plotarea;

public class Regress
extends Line {
    private double slope;
    private double intercept;
    private double variance;

    public Regress(Dataset[] datasetArray, AxisInterface axisInterface, AxisInterface axisInterface2, Plotarea plotarea) {
        super(datasetArray, axisInterface, axisInterface2, plotarea);
    }

    protected void doLine(Graphics graphics, int n) {
        double[] dArray;
        double[] dArray2 = this.datasets[n].getXValues();
        if (!this.regress(dArray2, dArray = this.datasets[n].getYValues())) {
            return;
        }
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        dArray3[0] = this.xAxisStart;
        dArray3[1] = this.xAxisEnd;
        dArray4[0] = this.intercept;
        dArray4[1] = this.intercept + (this.xAxisEnd - this.xAxisStart) * this.slope;
        if (!this.globals.threeD) {
            this.datasets[n].gc.drawPolyline(graphics, this.dataXfm.pointList(dArray3, dArray4));
            return;
        }
        int n2 = this.globals.xOffset / this.numDataSets;
        int n3 = this.globals.yOffset / this.numDataSets;
        int n4 = n2 * n;
        int n5 = n3 * n;
        Point[] pointArray = new Point[4];
        pointArray[0] = this.dataXfm.point(dArray3[0], dArray4[0]);
        pointArray[0].translate(n4, n5);
        pointArray[1] = new Point(pointArray[0].x + n2, pointArray[0].y + n3);
        pointArray[3] = this.dataXfm.point(dArray3[1], dArray4[1]);
        pointArray[3].translate(n4, n5);
        pointArray[2] = new Point(pointArray[3].x + n2, pointArray[3].y + n3);
        this.datasets[n].gc.drawPolygon(graphics, pointArray);
        this.datasets[n].gc.drawPolyline(graphics, pointArray);
    }

    private boolean regress(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < dArray2.length) {
            ++n;
            d += dArray[n2];
            d2 += dArray2[n2];
            d4 += dArray[n2] * dArray[n2];
            d3 += dArray[n2] * dArray2[n2];
            ++n2;
        }
        if (n < 2) {
            System.out.println("Not enough points to perform linear regression");
            return false;
        }
        this.slope = ((double)n * d3 - d * d2) / ((double)n * d4 - d * d);
        this.intercept = (d2 * d4 - d3 * d) / ((double)n * d4 - d * d);
        return true;
    }
}

