/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Plotarea;
import javachart.chart.Transform;

public class PolarAxis
extends Axis
implements AxisInterface {
    double interval;
    double centerX;
    double centerY;
    Plotarea fullPlotarea;
    Plotarea qtrPlotarea;
    private int numSpoke;
    public Point center;
    Transform dataXfm;
    Vector labelList;
    protected boolean manualSpoking = false;

    public PolarAxis(Dataset[] datasetArray, boolean bl, Plotarea plotarea) {
        super(datasetArray, false, plotarea);
    }

    public void addLabels(String[] stringArray) {
        this.replaceLabels(stringArray);
    }

    public synchronized void replaceLabels(String[] stringArray) {
        this.labelList = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            this.labelList.addElement(stringArray[n]);
            ++n;
        }
    }

    public boolean getManualSpoking() {
        return this.manualSpoking;
    }

    public void setManualSpoking(boolean bl) {
        this.manualSpoking = bl;
    }

    public void setNumSpokes(int n) {
        this.numSpoke = n;
        this.interval = 360 / this.numSpoke;
    }

    private void setNumSpokes(Dataset[] datasetArray) {
        int n = 0;
        int n2 = this.datasetsInUse();
        int n3 = 0;
        while (n3 < n2) {
            if (n < datasetArray[n3].data.size()) {
                n = datasetArray[n3].data.size();
            }
            ++n3;
        }
        this.numSpoke = n;
    }

    public int getNumSpokes() {
        return this.numSpoke;
    }

    private void setInterval() {
        this.setNumSpokes(this.datasets);
        this.interval = 360 / this.numSpoke;
    }

    public double getInterval() {
        return this.interval;
    }

    private Point[] rotateAxis(Point[] pointArray, double d) {
        Point[] pointArray2 = new Point[pointArray.length];
        double d2 = Math.cos(Math.PI * d / 180.0);
        double d3 = Math.sin(Math.PI * d / 180.0);
        int n = 0;
        while (n < pointArray.length) {
            double d4 = (double)pointArray[n].x - (double)this.center.x;
            double d5 = (double)pointArray[n].y - (double)this.center.y;
            double d6 = d4 * d2 - d5 * d3 + (double)this.center.x;
            double d7 = d4 * d3 + d5 * d2 + (double)this.center.y;
            pointArray2[n] = new Point((int)d6, (int)d7);
            ++n;
        }
        return pointArray2;
    }

    private Point[] getPoints() {
        int n;
        int n2;
        Vector<Point> vector = new Vector<Point>();
        Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
        Point point2 = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.urY);
        this.startPoint = point;
        vector.insertElementAt(point, 0);
        vector.insertElementAt(point2, 1);
        int n3 = point.x;
        if (this.majTickVis) {
            this.increment = this.getIncrement(point2.y, point.y, this.numMajTicks);
            n2 = 1;
            while (n2 < this.numMajTicks) {
                n = this.whereOnAxis(n2, 4);
                vector.addElement(new Point(n3, n));
                vector.addElement(new Point(n3 - this.majTickLength, n));
                ++n2;
            }
            vector.addElement(new Point(n3, point2.y));
            vector.addElement(new Point(n3 - this.majTickLength, point2.y));
        }
        if (this.minTickVis) {
            this.increment = this.getIncrement(point2.y, point.y, this.numMinTicks);
            n2 = 0;
            while (n2 < this.numMinTicks) {
                n = this.whereOnAxis(n2, 3);
                vector.addElement(new Point(n3, n));
                vector.addElement(new Point(n3 - this.minTickLength, n));
                ++n2;
            }
            vector.addElement(new Point(n3, point2.y));
            vector.addElement(new Point(n3 - this.minTickLength, point2.y));
        }
        Point[] pointArray = new Point[vector.size()];
        n2 = 0;
        while (n2 < vector.size()) {
            pointArray[n2] = (Point)vector.elementAt(n2);
            ++n2;
        }
        return pointArray;
    }

    protected void quarterPlotarea() {
        this.fullPlotarea = this.plotarea;
        this.plotarea = new Plotarea(this.fullPlotarea.globals);
        this.plotarea.setLlX(this.centerX);
        this.plotarea.setLlY(this.centerY);
        this.plotarea.setUrX(this.fullPlotarea.getUrX());
        this.plotarea.setUrY(this.fullPlotarea.getUrY());
        this.plotarea.setGc(this.fullPlotarea.getGc());
        this.plotarea.setUseDisplayList(this.fullPlotarea.getUseDisplayList());
        this.plotarea.resize(this.globals.maxX, this.globals.maxY);
        this.qtrPlotarea = this.plotarea;
    }

    public synchronized void draw(Graphics graphics) {
        double d = this.plotarea.urX - this.plotarea.llX;
        double d2 = this.plotarea.urY - this.plotarea.llY;
        this.centerX = this.plotarea.llX + d / 2.0;
        this.centerY = this.plotarea.llY + d2 / 2.0;
        this.center = this.plotarea.transform.point(this.centerX, this.centerY);
        this.quarterPlotarea();
        super.draw(graphics);
        Point[] pointArray = this.getPoints();
        int n = pointArray.length;
        this.plotarea = this.fullPlotarea;
        if (!this.manualSpoking) {
            this.setInterval();
        }
        int n2 = 1;
        while (n2 <= this.numSpoke) {
            Point[] pointArray2 = this.rotateAxis(pointArray, (double)n2 * this.interval);
            this.lineGc.drawLine(graphics, pointArray2[0].x, pointArray2[0].y, pointArray2[1].x, pointArray2[1].y);
            int n3 = 2;
            while (n3 < n) {
                this.tickGc.drawLine(graphics, pointArray2[n3].x, pointArray2[n3++].y, pointArray2[n3].x, pointArray2[n3].y);
                ++n3;
            }
            if (this.labelList != null) {
                this.doTitle(graphics, n2, pointArray2[0], pointArray2[1]);
            }
            ++n2;
        }
    }

    private void doTitle(Graphics graphics, int n, Point point, Point point2) {
        int n2;
        String string;
        try {
            string = (String)this.labelList.elementAt(n % this.labelList.size());
        }
        catch (Exception exception) {
            return;
        }
        int n3 = point2.x - point.x;
        int n4 = point2.y - point.y;
        if (n3 == 0) {
            n2 = n4 < 0 ? 0 : 2;
        } else if (n4 == 0) {
            n2 = n3 < 0 ? 1 : 3;
        }
        if (n4 > 0) {
            n2 = 2;
            point2.translate(0, 3);
        } else {
            n2 = 0;
            point2.translate(0, -3);
        }
        graphics.setFont(this.titleFont);
        graphics.setColor(this.titleColor);
        this.lineGc.drawSmartString(graphics, point2.x, point2.y, n2, 0, graphics.getFontMetrics(), string);
    }
}

