/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.Gc;
import javachart.chart.Globals;
import javachart.chart.Plotarea;
import javachart.chart.PolarAxis;
import javachart.chart.Transform;

public class Polar {
    protected PolarAxis axis;
    protected Plotarea plotarea;
    protected Transform dataXfm;
    protected Dataset[] datasets;
    protected Globals globals;
    boolean useDisplayList = true;
    boolean scatterPlot = false;
    boolean labelsOn = false;
    int labelAngle;
    int labelFormat = 1;
    int labelPrecision = 2;

    public Polar(Dataset[] datasetArray, PolarAxis polarAxis, Plotarea plotarea) {
        this.datasets = datasetArray;
        this.axis = polarAxis;
        this.plotarea = plotarea;
        this.globals = this.plotarea.globals;
    }

    public void setScatterPlot(boolean bl) {
        this.scatterPlot = bl;
    }

    public boolean isScatterPlot() {
        return this.scatterPlot;
    }

    public boolean getLabelsOn() {
        return this.labelsOn;
    }

    public void setLabelsOn(boolean bl) {
        this.labelsOn = bl;
    }

    public int getLabelAngle() {
        return this.labelAngle;
    }

    public void setLabelAngle(int n) {
        this.labelAngle = n;
    }

    public int getLabelPrecision() {
        return this.labelPrecision;
    }

    public void setLabelPrecision(int n) {
        this.labelPrecision = n;
    }

    public int getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(int n) {
        if (n < 0 || n > 2) {
            return;
        }
        this.labelFormat = n;
    }

    public synchronized void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.doPolar(graphics, this.scatterPlot);
    }

    protected void doPolar(Graphics graphics, boolean bl) {
        int n = this.axis.datasetsInUse();
        this.dataXfm = new Transform(0.0, this.axis.axisStart, 0.1, this.axis.axisEnd, this.axis.qtrPlotarea.transform.point(this.axis.qtrPlotarea.llX, this.axis.qtrPlotarea.llY), this.axis.qtrPlotarea.transform.point(this.axis.qtrPlotarea.urX, this.axis.qtrPlotarea.urY));
        this.dataXfm.logYScaling = this.axis.getLogScaling();
        int n2 = 0;
        while (n2 < n) {
            double[] dArray = this.datasets[n2].getYValues();
            Point[] pointArray = new Point[dArray.length];
            int n3 = 0;
            while (n3 < dArray.length) {
                pointArray[n3] = this.dataXfm.point(0.0, dArray[n3]);
                ++n3;
            }
            Point[] pointArray2 = this.rotateData(pointArray, this.datasets[n2]);
            if (bl) {
                this.doMarkers(graphics, n2, pointArray2);
            } else {
                this.datasets[n2].gc.drawPolyline(graphics, pointArray2);
                this.datasets[n2].gc.drawLine(graphics, pointArray2[dArray.length - 1], pointArray2[0]);
                this.doMarkers(graphics, n2, pointArray2);
            }
            if (this.labelsOn) {
                this.doLabels(graphics, n2, pointArray2);
            }
            ++n2;
        }
    }

    protected Point[] rotateData(Point[] pointArray, Dataset dataset) {
        int n = pointArray.length;
        double d = 360 / n;
        Point[] pointArray2 = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            double d2 = pointArray[n2].x - this.axis.center.x;
            double d3 = pointArray[n2].y - this.axis.center.y;
            double d4 = Math.cos(Math.PI * (double)n2 * d / 180.0);
            double d5 = Math.sin(Math.PI * (double)n2 * d / 180.0);
            double d6 = d2 * d4 - d3 * d5 + (double)this.axis.center.x;
            double d7 = d2 * d5 + d3 * d4 + (double)this.axis.center.y;
            pointArray2[n2] = new Point((int)d6, (int)d7);
            ++n2;
        }
        return pointArray2;
    }

    protected void doMarkers(Graphics graphics, int n, Point[] pointArray) {
        if (this.datasets[n].gc.image == null) {
            return;
        }
        int n2 = 0;
        while (n2 < pointArray.length) {
            this.datasets[n].gc.drawImage(graphics, pointArray[n2]);
            if (this.useDisplayList && this.globals.useDisplayList) {
                Point point = pointArray[n2];
                int n3 = this.datasets[n].gc.image.getWidth(null);
                int n4 = this.datasets[n].gc.image.getHeight(null);
                point.translate(n3 / 2, n4 / 2);
                Point point2 = new Point(point.x - n3, point.y - n4);
                this.globals.displayList.addRectangle(this.datasets[n].getDataElementAt(n2), point2, point);
                this.globals.displayList.addRectangle(this.datasets[n], point2, point);
                this.globals.displayList.addRectangle(this, point2, point);
            }
            ++n2;
        }
    }

    protected void doLabels(Graphics graphics, int n, Point[] pointArray) {
        int n2 = 0;
        while (n2 < pointArray.length) {
            this.doElementLabel(graphics, pointArray[n2], n, n2);
            ++n2;
        }
    }

    protected void doElementLabel(Graphics graphics, Point point, int n, int n2) {
        String string;
        Datum datum = this.datasets[n].getDataElementAt(n2);
        if (datum.label != null) {
            string = datum.label;
        } else {
            string = Double.toString(datum.y);
            int n3 = string.indexOf("e");
            if (n3 == -1) {
                n3 = string.indexOf("E");
            }
            if (n3 == -1) {
                string = Gc.formattedLabel(string, this.labelFormat, this.labelPrecision);
            } else {
                string = Gc.nonSciNumberStr(string, n3);
                string = Gc.formattedLabel(string, this.labelFormat, this.labelPrecision);
            }
        }
        graphics.setFont(this.datasets[n].labelFont);
        graphics.setColor(this.datasets[n].labelColor);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.datasets[n].gc.drawSmartString(graphics, point.x, point.y + 2, 2, this.labelAngle, fontMetrics, string);
    }
}

