/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import javachart.chart.Dataset;
import javachart.chart.Globals;
import javachart.chart.Legend;
import javachart.chart.LegendInterface;

public class PieLegend
extends Legend
implements LegendInterface {
    Dataset dataset;

    public PieLegend(Dataset[] datasetArray, Globals globals) {
        super(datasetArray, globals);
        this.datasets = datasetArray;
    }

    protected synchronized void doVerticalIcons(Graphics graphics) {
        graphics.setFont(this.labelFont);
        int n = this.dataset.data.size();
        double d = this.llX + 0.02;
        double d2 = this.llY + 0.02;
        double d3 = d + this.iconWidth;
        double d4 = d2 + this.iconHeight;
        int n2 = n - 1;
        while (n2 >= 0) {
            this.dataset.getDataElementAt((int)n2).gc.fillRect(graphics, this.transform.point(d, d2), this.transform.point(d3, d4));
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addRectangle(this.dataset.getDataElementAt(n2), this.transform.point(d, d2), this.transform.point(d3, d4));
            }
            Point point = this.transform.point(d3, d2);
            graphics.setColor(this.labelColor);
            this.backgroundGc.drawString(graphics, point.x + 2, point.y + 2, this.dataset.getDataElementAt((int)n2).label);
            d4 = (d2 += this.iconHeight + this.iconGap) + this.iconHeight;
            --n2;
        }
    }

    protected synchronized void doHorizontalIcons(Graphics graphics) {
        graphics.setFont(this.labelFont);
        int n = this.dataset.data.size();
        double d = this.llX + 0.02;
        double d2 = this.llY + 0.02;
        double d3 = d + this.iconWidth;
        double d4 = d2 + this.iconHeight;
        int n2 = 0;
        while (n2 < n) {
            this.dataset.getDataElementAt((int)n2).gc.fillRect(graphics, this.transform.point(d, d2), this.transform.point(d3, d4));
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addRectangle(this.dataset.getDataElementAt(n2), this.transform.point(d, d2), this.transform.point(d3, d4));
            }
            Point point = this.transform.point(d3, d2);
            graphics.setColor(this.labelColor);
            this.backgroundGc.drawString(graphics, point.x + 2, point.y, this.dataset.getDataElementAt((int)n2).label);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            d3 = (d += this.iconWidth + this.iconGap + this.iconGap + (double)fontMetrics.stringWidth(this.dataset.getDataElementAt((int)n2).label) / (double)this.gWidth) + this.iconWidth;
            ++n2;
        }
    }

    public synchronized void recalculateSize(Graphics graphics) {
        int n = 0;
        double d = 0.0;
        int n2 = 0;
        graphics.setFont(this.labelFont);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.dataset = this.datasets[0];
        int n3 = this.dataset.data.size();
        if (this.verticalLayout) {
            int n4 = 0;
            while (n4 < n3) {
                try {
                    n = fontMetrics.stringWidth(this.dataset.getDataElementAt((int)n4).label);
                }
                catch (NullPointerException nullPointerException) {
                    n = 0;
                }
                if (n > n2) {
                    n2 = n;
                }
                d += this.iconGap + this.iconHeight;
                ++n4;
            }
            this.urX = this.llX + this.iconWidth + 0.04 + (double)n / (double)this.gWidth;
            this.urY = this.llY + d + 0.04 + d / (double)this.gHeight;
            return;
        }
        int n5 = 0;
        while (n5 < n3) {
            try {
                n2 += fontMetrics.stringWidth(this.dataset.getDataElementAt((int)n5).label);
            }
            catch (NullPointerException nullPointerException) {}
            ++n5;
        }
        this.urX = this.llX + (double)n + 0.04 + (double)n3 * (this.iconWidth + this.iconGap) + this.iconWidth + this.iconGap + (double)n2 / (double)this.gWidth;
        this.urY = this.llY + d + 0.04 + this.iconHeight;
    }
}

