/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.Gc;
import javachart.chart.Globals;
import javachart.chart.Plotarea;

public class Pie
implements Serializable {
    boolean textLabelsOn = false;
    boolean valueLabelsOn = false;
    boolean percentLabelsOn = true;
    int labelPosition = 2;
    int labelFormat = 0;
    int labelPrecision;
    double xLoc = 0.5;
    double yLoc = 0.5;
    int startDegrees;
    double width = 0.6;
    double height = 0.6;
    Font labelFont;
    Color labelColor;
    boolean useDisplayList = true;
    Globals globals;
    Dataset dataset;
    Plotarea plotarea;
    double total;
    Gc lineGc;
    private Point widthHeight;
    public String currencyString;

    Pie(Dataset dataset, Plotarea plotarea, Globals globals) {
        this.dataset = dataset;
        this.plotarea = plotarea;
        this.globals = globals;
        this.labelFont = new Font("TimesRoman", 0, 12);
        this.labelColor = Color.black;
        this.lineGc = new Gc(Color.black, this.globals);
    }

    public synchronized void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.dataset == null) {
            return;
        }
        if (!this.globals.threeD) {
            this.doPie(graphics, this.xLoc, this.yLoc);
            return;
        }
        this.doDPie(graphics, this.xLoc, this.yLoc);
    }

    public synchronized void setExplosion(int n, double d) {
        try {
            this.dataset.getDataElementAt((int)n).y2 = d;
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public boolean getTextLabelsOn() {
        return this.textLabelsOn;
    }

    public void setTextLabelsOn(boolean bl) {
        this.textLabelsOn = bl;
    }

    public boolean getValueLabelsOn() {
        return this.valueLabelsOn;
    }

    public void setValueLabelsOn(boolean bl) {
        this.valueLabelsOn = bl;
    }

    public boolean getPercentLabelsOn() {
        return this.percentLabelsOn;
    }

    public void setPercentLabelsOn(boolean bl) {
        this.percentLabelsOn = bl;
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int n) {
        if (this.labelPosition < 0 || this.labelPosition > 2) {
            this.labelPosition = 1;
            return;
        }
        this.labelPosition = n;
    }

    public int getLabelPrecision() {
        return this.labelPrecision;
    }

    public void setLabelPrecision(int n) {
        this.labelPrecision = n;
    }

    public int getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(int n) {
        if (this.labelFormat < 0 || this.labelFormat > 2) {
            this.labelFormat = 0;
            return;
        }
        this.labelFormat = n;
    }

    public double getXLoc() {
        return this.xLoc;
    }

    public void setXLoc(double d) {
        if (d < 0.0 || d > 1.0) {
            this.xLoc = 0.5;
            return;
        }
        this.xLoc = d;
    }

    public double getYLoc() {
        return this.yLoc;
    }

    public void setYLoc(double d) {
        if (d < 0.0 || d > 1.0) {
            this.yLoc = 0.5;
            return;
        }
        this.yLoc = d;
    }

    public int getStartDegrees() {
        return this.startDegrees;
    }

    public void setStartDegrees(int n) {
        if (this.startDegrees >= 0 || this.startDegrees <= 360) {
            this.startDegrees = n;
        }
        while (this.startDegrees < 0) {
            this.startDegrees += 360;
        }
        while (this.startDegrees > 360) {
            this.startDegrees -= 360;
        }
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        if (d < 1.0) {
            this.width = d;
        }
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        if (d < 1.0) {
            this.height = d;
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public boolean getUseDisplayList() {
        return this.useDisplayList;
    }

    public void setUseDisplayList(boolean bl) {
        this.useDisplayList = bl;
    }

    protected void doPie(Graphics graphics, double d, double d2) {
        int n = this.startDegrees;
        int n2 = 0;
        while (n2 < this.dataset.data.size()) {
            this.total += this.dataset.getDataElementAt((int)n2).y;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.dataset.data.size()) {
            double d3;
            double d4;
            int n3 = n2 == this.dataset.data.size() - 1 ? 360 - n + this.startDegrees : (int)Math.round(360.0 * this.dataset.getDataElementAt((int)n2).y / this.total);
            double d5 = (double)(n3 / 2 + n) / 180.0 * Math.PI;
            if (this.dataset.getDataElementAt((int)n2).y2 != Double.NEGATIVE_INFINITY) {
                d4 = this.xLoc + this.dataset.getDataElementAt((int)n2).y2 * Math.cos(d5);
                d3 = this.yLoc + this.dataset.getDataElementAt((int)n2).y2 * Math.sin(d5);
            } else {
                d4 = this.xLoc;
                d3 = this.yLoc;
            }
            this.dataset.getDataElementAt((int)n2).gc.fillArc(graphics, this.plotarea.transform.point(d4, d3), this.plotarea.transform.point(this.width, this.height), n, n3);
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addArc(this.dataset.getDataElementAt(n2), this.plotarea.transform.point(d4, d3), this.plotarea.transform.point(this.width, this.height), n, n3);
            }
            if (this.textLabelsOn || this.valueLabelsOn || this.percentLabelsOn) {
                this.doPieLabel(graphics, d4, d3, d5, this.dataset.getDataElementAt(n2));
            }
            n += n3;
            ++n2;
        }
        this.total = 0.0;
    }

    protected void doDPie(Graphics graphics, double d, double d2) {
        Color color;
        Point point;
        double d3;
        double d4;
        int n;
        int n2 = this.startDegrees;
        this.widthHeight = this.plotarea.transform.point(this.width, this.height);
        Point[] pointArray = new Point[4];
        int n3 = 0;
        while (n3 < this.dataset.data.size()) {
            this.total += this.dataset.getDataElementAt((int)n3).y;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.dataset.data.size()) {
            n = n3 == this.dataset.data.size() - 1 ? 360 - n2 + this.startDegrees : (int)Math.round(360.0 * this.dataset.getDataElementAt((int)n3).y / this.total);
            d4 = this.xLoc;
            d3 = this.yLoc;
            point = this.plotarea.transform.point(d4, d3);
            point.y -= this.globals.yOffset;
            color = this.dataset.getDataElementAt((int)n3).gc.fillColor;
            this.dataset.getDataElementAt((int)n3).gc.fillColor = color.darker();
            this.dataset.getDataElementAt((int)n3).gc.fillArc(graphics, point, this.widthHeight, n2, n);
            this.dataset.getDataElementAt((int)n3).gc.fillColor = color;
            n2 += n;
            ++n3;
        }
        n2 = this.startDegrees;
        n3 = 0;
        while (n3 < this.dataset.data.size()) {
            n = n3 == this.dataset.data.size() - 1 ? 360 - n2 + this.startDegrees : (int)Math.round(360.0 * this.dataset.getDataElementAt((int)n3).y / this.total);
            d4 = this.xLoc;
            d3 = this.yLoc;
            point = this.plotarea.transform.point(d4, d3);
            point.y -= this.globals.yOffset;
            if (n2 < 180 && n2 + n > 180) {
                n -= 180 - n2;
                n2 = 180;
            }
            pointArray[1] = this.getArcPoint(point, n2);
            pointArray[0] = new Point(pointArray[1].x, pointArray[1].y + this.globals.yOffset);
            pointArray[2] = this.getArcPoint(point, n2 + n);
            pointArray[3] = new Point(pointArray[2].x, pointArray[2].y + this.globals.yOffset);
            color = this.dataset.getDataElementAt((int)n3).gc.fillColor;
            this.dataset.getDataElementAt((int)n3).gc.fillColor = color.darker();
            this.dataset.getDataElementAt((int)n3).gc.drawPolygon(graphics, pointArray);
            this.dataset.getDataElementAt((int)n3).gc.fillColor = color;
            n2 += n;
            ++n3;
        }
        n2 = this.startDegrees;
        n3 = 0;
        while (n3 < this.dataset.data.size()) {
            n = n3 == this.dataset.data.size() - 1 ? 360 - n2 + this.startDegrees : (int)Math.round(360.0 * this.dataset.getDataElementAt((int)n3).y / this.total);
            double d5 = (double)(n / 2 + n2) / 180.0 * Math.PI;
            d4 = this.xLoc;
            d3 = this.yLoc;
            this.dataset.getDataElementAt((int)n3).gc.fillArc(graphics, this.plotarea.transform.point(d4, d3), this.widthHeight, n2, n);
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addArc(this.dataset.getDataElementAt(n3), this.plotarea.transform.point(d4, d3), this.plotarea.transform.point(this.width, this.height), n2, n);
            }
            if (this.textLabelsOn || this.valueLabelsOn || this.percentLabelsOn) {
                this.doPieLabel(graphics, d4, d3, d5, this.dataset.getDataElementAt(n3));
            }
            n2 += n;
            ++n3;
        }
        this.total = 0.0;
    }

    private Point getArcPoint(Point point, int n) {
        double d = (double)n / 180.0 * Math.PI;
        int n2 = (int)((double)(this.widthHeight.x / 2) * Math.cos(d)) + point.x;
        int n3 = (int)((double)(this.widthHeight.y / 2) * Math.sin(d)) + point.y;
        return new Point(n2, n3);
    }

    protected String pctStr(double d) {
        if (d >= 1.0) {
            return "100%";
        }
        String string = Double.toString(d * 100.0);
        string = Gc.formattedLabel(string, this.labelFormat, this.labelPrecision);
        return String.valueOf(string) + "%";
    }

    private void doPieLabel(Graphics graphics, double d, double d2, double d3, Datum datum) {
        int n;
        int n2;
        Point point;
        double d4;
        double d5;
        int n3;
        String string = null;
        double d6 = Math.PI * 2;
        StringTokenizer stringTokenizer = null;
        int n4 = 0;
        while (d3 > d6) {
            d3 -= d6;
        }
        if (this.valueLabelsOn) {
            string = Double.toString(datum.y);
            if (this.labelFormat != 0) {
                n3 = string.indexOf(101);
                if (n3 == -1) {
                    n3 = string.indexOf(69);
                }
                if (n3 != -1) {
                    string = Gc.nonSciNumberStr(string, n3);
                }
                string = Gc.formattedLabel(string, this.labelFormat, this.labelPrecision);
                if (this.currencyString != null) {
                    string = String.valueOf(this.currencyString) + string;
                }
            }
        }
        graphics.setFont(this.labelFont);
        graphics.setColor(this.labelColor);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.textLabelsOn && datum.label != null) {
            stringTokenizer = new StringTokenizer(datum.label, "|");
            while (stringTokenizer.hasMoreTokens()) {
                n3 = fontMetrics.stringWidth(stringTokenizer.nextToken());
                if (n3 <= n4) continue;
                n4 = n3;
            }
            stringTokenizer = new StringTokenizer(datum.label, "|");
        }
        if (this.labelPosition == 1) {
            d5 = d + this.width / 2.0 * Math.cos(d3);
            d4 = d2 + this.height / 2.0 * Math.sin(d3);
            point = this.plotarea.transform.point(d5, d4);
            n2 = point.x;
            n = point.y;
        } else if (this.labelPosition == 0) {
            d5 = d + this.width / 4.0 * Math.cos(d3);
            d4 = d2 + this.height / 4.0 * Math.sin(d3);
            point = this.plotarea.transform.point(d5, d4);
            n2 = point.x;
            n = point.y;
        } else if (this.labelPosition == 2) {
            d5 = d + this.width / 2.0 * Math.cos(d3);
            d4 = d2 + this.height / 2.0 * Math.sin(d3);
            double d7 = d + this.width / 1.8 * Math.cos(d3);
            double d8 = d2 + this.height / 1.8 * Math.sin(d3);
            this.lineGc.drawLine(graphics, this.plotarea.transform.point(d5, d4), this.plotarea.transform.point(d7, d8));
            graphics.setColor(this.labelColor);
            d7 = d + this.width / 1.79 * Math.cos(d3);
            d8 = d2 + this.height / 1.79 * Math.sin(d3);
            point = this.plotarea.transform.point(d7, d8);
            n2 = point.x;
            n = point.y;
        } else {
            return;
        }
        if (d3 >= 4.71238898038469 && d3 <= d6) {
            n -= fontMetrics.getAscent();
            if (this.textLabelsOn) {
                while (stringTokenizer.hasMoreTokens()) {
                    this.lineGc.drawString(graphics, n2, n, stringTokenizer.nextToken());
                    n -= fontMetrics.getAscent();
                }
            }
            if (this.valueLabelsOn) {
                this.lineGc.drawString(graphics, n2, n, string);
                n -= fontMetrics.getAscent();
            }
            if (this.percentLabelsOn) {
                this.lineGc.drawString(graphics, n2, n, this.pctStr(datum.y / this.total));
            }
            return;
        }
        if (d3 >= 0.0 && d3 < 1.5707963267948966) {
            if (this.percentLabelsOn) {
                this.lineGc.drawString(graphics, n2, n, this.pctStr(datum.y / this.total));
                n += fontMetrics.getAscent();
            }
            if (this.valueLabelsOn) {
                this.lineGc.drawString(graphics, n2, n, string);
                n += fontMetrics.getAscent();
            }
            if (this.textLabelsOn) {
                Vector<String> vector = new Vector<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    vector.addElement(stringTokenizer.nextToken());
                }
                int n5 = vector.size();
                while (n5 > 0) {
                    this.lineGc.drawString(graphics, n2, n, (String)vector.elementAt(n5 - 1));
                    n += fontMetrics.getAscent();
                    --n5;
                }
            }
            return;
        }
        if (d3 >= 1.5707963267948966 && d3 < Math.PI) {
            n2 = this.textLabelsOn && datum.label != null ? (n2 -= n4) : (this.valueLabelsOn ? (n2 -= fontMetrics.stringWidth(string)) : (n2 -= fontMetrics.stringWidth(this.pctStr(datum.y / this.total))));
            if (this.percentLabelsOn) {
                this.lineGc.drawString(graphics, n2, n, this.pctStr(datum.y / this.total));
                n += fontMetrics.getAscent();
            }
            if (this.valueLabelsOn) {
                this.lineGc.drawString(graphics, n2, n, string);
                n += fontMetrics.getAscent();
            }
            if (this.textLabelsOn) {
                Vector<String> vector = new Vector<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    vector.addElement(stringTokenizer.nextToken());
                }
                int n6 = vector.size();
                while (n6 > 0) {
                    this.lineGc.drawString(graphics, n2, n, (String)vector.elementAt(n6 - 1));
                    n += fontMetrics.getAscent();
                    --n6;
                }
            }
            return;
        }
        if (d3 >= Math.PI && d3 < 4.71238898038469) {
            n2 = this.textLabelsOn && datum.label != null ? (n2 -= n4) : (this.valueLabelsOn ? (n2 -= fontMetrics.stringWidth(string)) : (n2 -= fontMetrics.stringWidth(this.pctStr(datum.y / this.total))));
            n -= fontMetrics.getAscent();
            if (this.textLabelsOn) {
                while (stringTokenizer.hasMoreTokens()) {
                    this.lineGc.drawString(graphics, n2, n, stringTokenizer.nextToken());
                    n -= fontMetrics.getAscent();
                }
            }
            if (this.valueLabelsOn) {
                this.lineGc.drawString(graphics, n2, n, string);
                n -= fontMetrics.getAscent();
            }
            if (this.percentLabelsOn) {
                this.lineGc.drawString(graphics, n2, n, this.pctStr(datum.y / this.total));
                n -= fontMetrics.getAscent();
            }
        }
    }
}

