/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import javachart.chart.Dataset;
import javachart.chart.Globals;
import javachart.chart.Legend;
import javachart.chart.LegendInterface;

public class LineLegend
extends Legend
implements LegendInterface {
    public LineLegend(Dataset[] datasetArray, Globals globals) {
        super(datasetArray, globals);
    }

    protected synchronized void doVerticalIcons(Graphics graphics) {
        graphics.setFont(this.labelFont);
        int n = this.datasetsInUse();
        double d = this.llX + 0.02;
        double d2 = this.llY + 0.02 + this.iconHeight / 2.0;
        double d3 = d + this.iconWidth;
        double d4 = d2;
        int n2 = n;
        while (n2 > 0) {
            this.datasets[n2 - 1].gc.drawLine(graphics, this.transform.point(d, d2), this.transform.point(d3, d4));
            this.datasets[n2 - 1].gc.drawImage(graphics, this.transform.point(d + this.iconWidth / 2.0, d2));
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addLine(this.datasets[n2], this.transform.point(d, d2), this.transform.point(d3, d4));
            }
            Point point = this.transform.point(d3, d2);
            graphics.setColor(this.labelColor);
            this.backgroundGc.drawString(graphics, point.x + 4, point.y - 4, this.datasets[n2 - 1].setName);
            d4 = d2 += this.iconHeight + this.iconGap;
            --n2;
        }
    }

    protected synchronized void doHorizontalIcons(Graphics graphics) {
        graphics.setFont(this.labelFont);
        int n = this.datasetsInUse();
        double d = this.llX + 0.02;
        double d2 = this.llY + 0.02 + this.iconHeight / 2.0;
        double d3 = d + this.iconWidth;
        double d4 = d2;
        int n2 = 0;
        while (n2 < n) {
            this.datasets[n2].gc.drawLine(graphics, this.transform.point(d, d2), this.transform.point(d3, d4));
            this.datasets[n2].gc.drawImage(graphics, this.transform.point(d + this.iconWidth / 2.0, d2));
            if (this.useDisplayList && this.globals.useDisplayList) {
                this.globals.displayList.addLine(this.datasets[n2], this.transform.point(d, d2), this.transform.point(d3, d4));
            }
            Point point = this.transform.point(d3, d2);
            graphics.setColor(this.labelColor);
            this.backgroundGc.drawString(graphics, point.x + 3, point.y - 3, this.datasets[n2].setName);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            d3 = (d += this.iconWidth + this.iconGap + this.iconGap + this.iconGap + (double)fontMetrics.stringWidth(this.datasets[n2].setName) / (double)this.gWidth) + this.iconWidth;
            ++n2;
        }
    }
}

