/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Background;
import javachart.chart.Chart;
import javachart.chart.Line;
import javachart.chart.LineLegend;
import javachart.chart.Plotarea;

public class LineChart
extends Chart {
    Line line;
    AxisInterface xAxis;
    AxisInterface yAxis;
    boolean lineVisible = true;

    public LineChart() {
    }

    public LineChart(String string) {
        super(string);
    }

    public LineChart(String string, Graphics graphics) {
        super(string, graphics);
    }

    public void drawGraph() {
        if (this.canvas == null) {
            return;
        }
        this.drawGraph(this.canvas);
    }

    public void drawGraph(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.drawGraph(graphics);
        this.background.draw(graphics);
        this.plotarea.draw(graphics);
        if (this.xAxisVisible) {
            this.xAxis.draw(graphics);
        }
        if (this.yAxisVisible) {
            this.yAxis.draw(graphics);
        }
        if (!this.line.doClip) {
            this.line.draw(graphics);
        }
        if (this.legendVisible) {
            this.legend.draw(graphics);
        }
        if (this.line.doClip) {
            this.line.draw(graphics);
        }
    }

    public Line getLine() {
        return this.line;
    }

    public boolean getLineVisible() {
        return this.lineVisible;
    }

    public AxisInterface getXAxis() {
        return this.xAxis;
    }

    public AxisInterface getYAxis() {
        return this.yAxis;
    }

    protected void initAxes() {
        this.xAxis = new Axis(this.datasets, true, this.plotarea);
        this.yAxis = new Axis(this.datasets, false, this.plotarea);
        Axis cfr_ignored_0 = (Axis)this.yAxis;
    }

    protected void initChart() {
        this.initGlobals();
        this.plotarea = new Plotarea(this.globals);
        this.background = new Background(this.globals);
        this.initDataSets();
        this.initAxes();
        this.line = new Line(this.datasets, this.xAxis, this.yAxis, this.plotarea);
        this.legend = new LineLegend(this.datasets, this.globals);
        this.resize(640, 480);
    }

    public void setLine(Line line) {
        this.line = line;
    }

    public void setLineVisible(boolean bl) {
        this.lineVisible = bl;
        this.line.scatterPlot = !bl;
    }

    public void setXAxis(AxisInterface axisInterface) {
        this.xAxis = axisInterface;
    }

    public void setYAxis(AxisInterface axisInterface) {
        this.yAxis = axisInterface;
    }
}

