/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import javachart.chart.Axis;
import javachart.chart.Background;
import javachart.chart.BarChart;
import javachart.chart.Dataset;
import javachart.chart.HorizBar;
import javachart.chart.LabelAxis;
import javachart.chart.PieLegend;
import javachart.chart.Plotarea;

public class IndBarChart
extends BarChart {
    public IndBarChart() {
    }

    public IndBarChart(String string) {
        super(string);
    }

    public IndBarChart(String string, Graphics graphics) {
        super(string, graphics);
    }

    public void addDataSet(String string, double[] dArray) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = new Dataset(string, dArray, true, this.globals);
            ++this.numberOfDatasets;
        }
    }

    public void addDataSet(String string, double[] dArray, String[] stringArray) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = new Dataset(string, dArray, stringArray, true, this.globals);
            ++this.numberOfDatasets;
        }
    }

    public void drawGraph() {
        if (this.canvas == null) {
            return;
        }
        this.drawGraph(this.canvas);
    }

    public void drawGraph(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.drawGraph(graphics);
        this.background.draw(graphics);
        this.plotarea.draw(graphics);
        if (this.xAxisVisible) {
            this.xAxis.draw(graphics);
        } else {
            this.xAxis.scale();
        }
        if (this.yAxisVisible) {
            this.yAxis.draw(graphics);
        } else {
            this.yAxis.scale();
        }
        this.bar.drawInd(graphics);
        if (this.legendVisible) {
            this.legend.draw(graphics);
        }
    }

    protected void initAxes() {
        this.xAxis = new LabelAxis(this.datasets, true, this.plotarea);
        this.xAxis.setSide(1);
        this.xAxis.setBarScaling(true);
        this.yAxis = new Axis(this.datasets, false, this.plotarea);
        this.yAxis.setBarScaling(true);
        this.yAxis.setSide(0);
    }

    protected void initChart() {
        this.initGlobals();
        this.plotarea = new Plotarea(this.globals);
        this.background = new Background(this.globals);
        this.background.globals = this.globals;
        this.initDataSets();
        this.initAxes();
        this.bar = new HorizBar(this.datasets, this.xAxis, this.yAxis, this.plotarea);
        this.legend = new PieLegend(this.datasets, this.globals);
        this.resize(640, 480);
    }
}

