/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Background;
import javachart.chart.Chart;
import javachart.chart.DateAxis;
import javachart.chart.HiLoAxis;
import javachart.chart.HiLoClose;
import javachart.chart.LabelAxis;
import javachart.chart.Legend;
import javachart.chart.Plotarea;

public class HiLoCloseChart
extends Chart {
    HiLoClose hiLoClose;
    AxisInterface xAxis;
    AxisInterface yAxis;

    public HiLoCloseChart() {
    }

    public HiLoCloseChart(String string) {
        super(string);
    }

    public HiLoCloseChart(String string, Graphics graphics) {
        super(string, graphics);
    }

    public void drawGraph() {
        if (this.canvas == null) {
            return;
        }
        this.drawGraph(this.canvas);
    }

    public void drawGraph(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.drawGraph();
        this.background.draw(graphics);
        this.plotarea.draw(graphics);
        if (this.xAxisVisible) {
            this.xAxis.draw(graphics);
        } else {
            this.xAxis.scale();
        }
        if (this.yAxisVisible) {
            this.yAxis.draw(graphics);
        } else {
            this.yAxis.scale();
        }
        this.hiLoClose.draw(graphics);
        if (this.legendVisible) {
            this.legend.draw(graphics);
        }
    }

    public HiLoClose getHiLoClose() {
        return this.hiLoClose;
    }

    public AxisInterface getXAxis() {
        return this.xAxis;
    }

    public AxisInterface getYAxis() {
        return this.yAxis;
    }

    protected void initAxes() {
        this.xAxis = new DateAxis(this.datasets, true, this.plotarea);
        this.yAxis = new HiLoAxis(this.datasets, false, this.plotarea);
        this.xAxis.setBarScaling(false);
        this.yAxis.setBarScaling(false);
    }

    protected void initChart() {
        this.initGlobals();
        this.plotarea = new Plotarea(this.globals);
        this.background = new Background(this.globals);
        this.initDataSets();
        this.initAxes();
        this.hiLoClose = new HiLoClose(this.datasets, this.xAxis, this.yAxis, this.plotarea);
        this.legend = new Legend(this.datasets, this.globals);
        this.resize(640, 480);
    }

    public void setHiLoClose(HiLoClose hiLoClose) {
        this.hiLoClose = hiLoClose;
    }

    public void setXAxis(LabelAxis labelAxis) {
        this.xAxis = labelAxis;
    }

    public void setYAxis(Axis axis) {
        this.yAxis = axis;
    }
}

