/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import javachart.chart.AxisInterface;
import javachart.chart.Bar;
import javachart.chart.Dataset;
import javachart.chart.Gc;
import javachart.chart.Plotarea;

public class HiLoBar
extends Bar {
    public HiLoBar(Dataset[] datasetArray, AxisInterface axisInterface, AxisInterface axisInterface2, Plotarea plotarea) {
        super(datasetArray, axisInterface, axisInterface2, plotarea);
    }

    protected void doBar(Graphics graphics, double d, int n, int n2, boolean bl) {
        double d2 = 0.5 * this.clusterWidth;
        double d3 = (double)n2 - d2 + d * (double)n;
        double d4 = d3 + d;
        double d5 = this.datasets[n].getDataElementAt((int)n2).y;
        double d6 = this.datasets[n].getDataElementAt((int)n2).y2;
        if (!bl) {
            this.datasets[n].gc.fillRect(graphics, this.dataXfm.point(d3, d6), this.dataXfm.point(d4, d5));
        } else {
            try {
                this.datasets[n].getDataElementAt((int)n2).gc.fillRect(graphics, this.dataXfm.point(d3, d6), this.dataXfm.point(d4, d5));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.globals.displayList.addRectangle(this.datasets[n], this.dataXfm.point(d3, d6), this.dataXfm.point(d4, d5));
            this.globals.displayList.addRectangle(this.datasets[n].getDataElementAt(n2), this.dataXfm.point(d3, d6), this.dataXfm.point(d4, d5));
        }
    }

    protected void doDBar(Graphics graphics, double d, int n, int n2, boolean bl) {
        Gc gc;
        double d2 = 0.5 * this.clusterWidth;
        Point[] pointArray = new Point[4];
        double d3 = (double)n2 - d2 + d * (double)n;
        double d4 = d3 + d;
        double d5 = this.datasets[n].getDataElementAt((int)n2).y;
        double d6 = this.datasets[n].getDataElementAt((int)n2).y2;
        pointArray[0] = this.dataXfm.point(d3, d6);
        pointArray[1] = this.dataXfm.point(d4, d5);
        try {
            gc = !bl ? this.datasets[n].gc : this.datasets[n].getDataElementAt((int)n2).gc;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            gc = this.datasets[n].gc;
        }
        gc.fillRect(graphics, pointArray[0], pointArray[1]);
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.globals.displayList.addRectangle(this.datasets[n], pointArray[0], pointArray[1]);
            this.globals.displayList.addRectangle(this.datasets[n].getDataElementAt(n2), pointArray[0], pointArray[1]);
        }
        Color color = gc.fillColor;
        gc.fillColor = color.darker();
        pointArray[0] = this.dataXfm.point(d4, d6);
        pointArray[2] = new Point(pointArray[1].x + this.globals.xOffset, pointArray[1].y + this.globals.yOffset);
        pointArray[3] = new Point(pointArray[0].x + this.globals.xOffset, pointArray[0].y + this.globals.yOffset);
        gc.drawPolygon(graphics, pointArray);
        if (d5 > d6) {
            pointArray[0] = this.dataXfm.point(d3, d5);
            pointArray[3].x = pointArray[0].x + this.globals.xOffset;
            pointArray[3].y = pointArray[0].y + this.globals.yOffset;
            gc.drawPolygon(graphics, pointArray);
        } else {
            pointArray[0] = this.dataXfm.point(d3, d6);
            pointArray[1] = this.dataXfm.point(d4, d6);
            pointArray[2].x = pointArray[1].x + this.globals.xOffset;
            pointArray[2].y = pointArray[1].y + this.globals.yOffset;
            pointArray[3].x = pointArray[0].x + this.globals.xOffset;
            pointArray[3].y = pointArray[0].y + this.globals.yOffset;
            gc.drawPolygon(graphics, pointArray);
        }
        gc.fillColor = color;
    }

    protected void doBarLabel(Graphics graphics, double d, int n, int n2) {
        String string;
        double d2 = 0.5 * this.clusterWidth;
        double d3 = (double)n2 - d2 + d * (double)n;
        double d4 = d3 + d;
        double d5 = this.datasets[n].getDataElementAt((int)n2).y;
        if (this.datasets[n].getDataElementAt((int)n2).label != null) {
            string = this.datasets[n].getDataElementAt((int)n2).label;
        } else {
            string = Double.toString(this.datasets[n].getDataElementAt((int)n2).y);
            int n3 = string.indexOf("e");
            if (n3 == -1) {
                n3 = string.indexOf("E");
            }
            if (n3 == -1) {
                string = Gc.formattedLabel(string, this.labelFormat, this.labelPrecision);
            } else {
                string = Gc.nonSciNumberStr(string, n3);
                string = Gc.formattedLabel(string, this.labelFormat, this.labelPrecision);
            }
        }
        graphics.setFont(this.datasets[n].labelFont);
        graphics.setColor(this.datasets[n].labelColor);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Point point = this.dataXfm.point(d3 + (d4 - d3) / 2.0, d5);
        this.datasets[n].gc.drawSmartString(graphics, point.x, point.y, 2, this.labelAngle, fontMetrics, string);
    }
}

