/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Background;
import javachart.chart.Chart;
import javachart.chart.Dataset;
import javachart.chart.DateAxis;
import javachart.chart.HiLoAxis;
import javachart.chart.HiLoClose;
import javachart.chart.LabelAxis;
import javachart.chart.Legend;
import javachart.chart.Line;
import javachart.chart.Plotarea;
import javachart.chart.Stick;

public class FinComboChart
extends Chart {
    HiLoClose hiLoClose;
    Stick stick;
    Line line;
    AxisInterface xAxis;
    AxisInterface yAxis;
    Dataset[] lineData;
    Dataset[] stickData;
    Dataset[] hlocData;
    public int[] dataAllocation;
    AxisInterface stickYAxis;
    AxisInterface lineYAxis;
    Plotarea stickPlotarea;
    Plotarea linePlotarea;
    boolean splitWindow = true;
    boolean hasStickData = false;
    boolean hasLineData = false;
    boolean hasHLOCData = false;
    public static final int LINE = 0;
    public static final int STICK = 1;
    public static final int HLOC = 2;

    public FinComboChart() {
    }

    public FinComboChart(String string) {
        super(string);
    }

    public FinComboChart(String string, Graphics graphics) {
        super(string, graphics);
    }

    void distributeAxisAttributes() {
        Axis axis = (Axis)this.stickYAxis;
        Axis axis2 = (Axis)this.yAxis;
        axis.majTickVis = axis2.majTickVis;
        axis.minTickVis = axis2.minTickVis;
        axis.gridVis = axis2.gridVis;
        axis.labelVis = axis2.labelVis;
        axis.lineVis = axis2.lineVis;
        axis.labelFormat = axis2.labelFormat;
        axis.labelPrecision = axis2.labelPrecision;
        axis.labelColor = axis2.labelColor;
        axis.labelFont = axis2.labelFont;
        axis.labelAngle = axis2.labelAngle;
        axis.lineGc = axis2.lineGc;
        axis.gridGc = axis2.gridGc;
        axis.tickGc = axis2.tickGc;
        axis.side = axis2.side;
        axis = (Axis)this.lineYAxis;
        axis.majTickVis = axis2.majTickVis;
        axis.minTickVis = axis2.minTickVis;
        axis.gridVis = axis2.gridVis;
        axis.labelVis = axis2.labelVis;
        axis.lineVis = axis2.lineVis;
        axis.labelFormat = axis2.labelFormat;
        axis.labelPrecision = axis2.labelPrecision;
        axis.labelColor = axis2.labelColor;
        axis.labelFont = axis2.labelFont;
        axis.labelAngle = axis2.labelAngle;
        axis.lineGc = axis2.lineGc;
        axis.gridGc = axis2.gridGc;
        axis.tickGc = axis2.tickGc;
        axis.side = axis2.side;
    }

    void distributeDatasets() {
        this.hasLineData = false;
        int n = 0;
        int n2 = 0;
        while (n2 < 20) {
            if (this.dataAllocation[n2] == 0) {
                this.lineData[n++] = this.datasets[n2];
                if (this.datasets[n2] != null) {
                    this.hasLineData = true;
                }
            }
            ++n2;
        }
        this.hasStickData = false;
        n = 0;
        n2 = 0;
        while (n2 < 20) {
            if (this.dataAllocation[n2] == 1) {
                this.stickData[n++] = this.datasets[n2];
                this.hasStickData = true;
            }
            ++n2;
        }
        this.hasHLOCData = false;
        n = 0;
        n2 = 0;
        while (n2 < 20) {
            if (this.dataAllocation[n2] == 2) {
                this.hlocData[n++] = this.datasets[n2];
                this.hasHLOCData = true;
            }
            ++n2;
        }
    }

    public void drawGraph() {
        if (this.canvas == null) {
            return;
        }
        this.drawGraph(this.canvas);
    }

    public void drawGraph(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.drawGraph();
        this.distributeDatasets();
        this.distributeAxisAttributes();
        this.background.draw(graphics);
        if (!this.splitWindow) {
            this.plotarea.draw(graphics);
            if (this.xAxisVisible) {
                this.xAxis.draw(graphics);
            } else {
                this.xAxis.scale();
            }
            if (this.yAxisVisible) {
                this.yAxis.draw(graphics);
            } else {
                this.yAxis.scale();
            }
            this.hiLoClose.draw(graphics);
            this.stick.draw(graphics);
            this.line.draw(graphics);
        } else {
            double d = this.plotarea.llY;
            double d2 = 0.0;
            if (this.hasStickData) {
                d2 += 1.0;
            }
            if (this.hasLineData) {
                d2 += 1.0;
            }
            if (this.hasHLOCData) {
                d2 += 1.0;
            }
            double d3 = (this.plotarea.urY - this.plotarea.llY) / d2;
            if (this.xAxisVisible) {
                this.xAxis.draw(graphics);
            } else {
                this.xAxis.scale();
            }
            if (this.hasHLOCData) {
                this.plotarea.llY = this.plotarea.urY - d3;
                this.plotarea.draw(graphics);
                this.yAxis.setDatasets(this.hlocData);
                if (this.yAxisVisible) {
                    this.yAxis.draw(graphics);
                } else {
                    this.yAxis.scale();
                }
                this.hiLoClose.draw(graphics);
            } else {
                this.plotarea.llY = this.plotarea.urY;
            }
            if (this.hasLineData) {
                this.linePlotarea.gc = this.plotarea.gc;
                this.linePlotarea.urY = this.plotarea.llY;
                this.linePlotarea.llY = this.plotarea.llY - d3;
                this.linePlotarea.llX = this.plotarea.llX;
                this.linePlotarea.urX = this.plotarea.urX;
                this.plotarea.llY = this.linePlotarea.llY;
                this.linePlotarea.draw(graphics);
                if (this.yAxisVisible) {
                    this.lineYAxis.draw(graphics);
                } else {
                    this.lineYAxis.scale();
                }
                this.line.plotarea = this.linePlotarea;
                this.line.yAxis = this.lineYAxis;
                this.line.draw(graphics);
            }
            if (this.hasStickData) {
                this.stickPlotarea.gc = this.plotarea.gc;
                this.stickPlotarea.urY = this.plotarea.llY;
                this.stickPlotarea.llY = this.plotarea.llY - d3;
                this.stickPlotarea.llX = this.plotarea.llX;
                this.stickPlotarea.urX = this.plotarea.urX;
                this.stickPlotarea.draw(graphics);
                this.stick.plotarea = this.stickPlotarea;
                if (this.yAxisVisible) {
                    this.stickYAxis.draw(graphics);
                } else {
                    this.stickYAxis.scale();
                }
                this.stick.yAxis = this.stickYAxis;
                this.stick.draw(graphics);
            }
            this.plotarea.llY = d;
        }
        if (this.legendVisible) {
            this.legend.draw(graphics);
        }
    }

    public HiLoClose getHiLoClose() {
        return this.hiLoClose;
    }

    public boolean getSplitWindow() {
        return this.splitWindow;
    }

    public AxisInterface getXAxis() {
        return this.xAxis;
    }

    public AxisInterface getYAxis() {
        return this.yAxis;
    }

    protected void initAxes() {
        this.xAxis = new DateAxis(this.datasets, true, this.plotarea);
        this.xAxis.setBarScaling(false);
        this.yAxis = new HiLoAxis(this.datasets, false, this.plotarea);
        this.yAxis.setBarScaling(false);
        this.stickPlotarea = new Plotarea(this.getGlobals());
        this.linePlotarea = new Plotarea(this.getGlobals());
        this.stickYAxis = new Axis(this.stickData, false, this.stickPlotarea);
        this.stickYAxis.setBarScaling(true);
        this.lineYAxis = new Axis(this.lineData, false, this.linePlotarea);
    }

    protected void initChart() {
        this.initGlobals();
        this.plotarea = new Plotarea(this.globals);
        this.background = new Background(this.globals);
        this.initDataSets();
        this.initAxes();
        this.dataAllocation = new int[20];
        int n = 0;
        while (n < 20) {
            this.dataAllocation[n] = 0;
            ++n;
        }
        this.hiLoClose = new HiLoClose(this.hlocData, this.xAxis, this.yAxis, this.plotarea);
        this.stick = new Stick(this.stickData, this.xAxis, this.yAxis, this.plotarea);
        this.line = new Line(this.lineData, this.xAxis, this.yAxis, this.plotarea);
        this.legend = new Legend(this.datasets, this.globals);
        this.resize(640, 480);
    }

    protected void initDataSets() {
        this.datasets = new Dataset[20];
        this.lineData = new Dataset[20];
        this.hlocData = new Dataset[20];
        this.stickData = new Dataset[20];
    }

    public void resize(int n, int n2) {
        super.resize(n, n2);
        this.stickPlotarea.resize(n, n2);
        this.linePlotarea.resize(n, n2);
    }

    public synchronized void setChartType(int n, int n2) {
        if (n2 < 0 || n2 > 2) {
            System.out.println("bad Chart Type");
            return;
        }
        if (n > 20) {
            System.out.println("bad dataset number");
            return;
        }
        this.dataAllocation[n] = n2;
    }

    public void setHiLoClose(HiLoClose hiLoClose) {
        this.hiLoClose = hiLoClose;
    }

    public void setSplitWindow(boolean bl) {
        this.splitWindow = bl;
    }

    public void setXAxis(LabelAxis labelAxis) {
        this.xAxis = labelAxis;
    }

    public void setYAxis(Axis axis) {
        this.yAxis = axis;
    }
}

