/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.util.Date;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Plotarea;

public class DateAxis
extends Axis
implements AxisInterface {
    Date startDate = new Date(0L);
    Date endDate = new Date(0L);
    Date tmpDate = new Date(0L);
    long stepSize;
    int scalingType = 4;
    static final int SecondScaling = 1;
    static final int MinuteScaling = 2;
    static final int HourScaling = 3;
    static final int DayScaling = 4;
    static final int WeekScaling = 5;
    static final int MonthScaling = 6;
    static final int YearScaling = 7;
    static final long oneMinute = 60000L;
    static final long oneHour = 3600000L;
    static final long oneDay = 86400000L;
    static final long oneWeek = 604800000L;
    static final long oneMonth = 2592000000L;
    static final long oneYear = 31536000000L;

    public DateAxis(Dataset[] datasetArray, boolean bl, Plotarea plotarea) {
        super(datasetArray, bl, plotarea);
    }

    public void setLogScaling(boolean bl) {
    }

    public void setAxisStart(double d) {
        this.axisStart = d;
        this.startDate.setTime((long)d);
    }

    public void setAxisEnd(double d) {
        this.axisEnd = d;
        this.endDate.setTime((long)d);
    }

    protected int whereOnAxis(int n, int n2) {
        if (!this.autoScale) {
            if (this.scalingType == 6) {
                this.stepSize = this.endDate.getYear() - this.startDate.getYear();
                this.stepSize = this.stepSize * 12L - (long)this.startDate.getMonth() + (long)this.endDate.getMonth();
            } else {
                this.stepSize = this.scalingType == 7 ? (long)(this.endDate.getYear() - this.startDate.getYear()) : (long)(this.axisEnd - this.axisStart);
            }
            if (n2 == 2) {
                this.stepSize /= (long)this.numGrids;
            }
            if (n2 == 1) {
                this.stepSize /= (long)this.numLabels;
            }
            if (n2 == 4) {
                this.stepSize /= (long)this.numMajTicks;
            }
            if (n2 == 3) {
                this.stepSize /= (long)this.numMinTicks;
            }
            if (this.stepSize == 0L) {
                this.stepSize = 1L;
            }
        }
        if (this.scalingType != 6 && this.scalingType != 7) {
            if (this.side == 0 || this.side == 2) {
                return this.startPoint.x + (int)(this.increment * (float)n);
            }
            return this.startPoint.y + (int)(this.increment * (float)n);
        }
        double d = this.scalingType == 6 ? (double)this.getMonthPosition(n) - this.axisStart : (double)this.getYearPosition(n) - this.axisStart;
        double d2 = d / (this.axisEnd - this.axisStart);
        if (this.isXAxis) {
            return this.startPoint.x + (int)(d2 * (double)(this.endPoint.x - this.startPoint.x));
        }
        return this.startPoint.y + (int)(d2 * (double)(this.endPoint.y - this.startPoint.y));
    }

    public synchronized void scale() {
        int n = this.datasetsInUse();
        if (n == 0) {
            return;
        }
        long l = (long)this.getMaxValsFromData(n);
        long l2 = (long)this.getMinValsFromData(n);
        long l3 = l - l2;
        this.startDate.setTime(l2);
        this.endDate.setTime(l);
        if (l3 < 0L) {
            System.out.println("doesn't work with reverse scales");
            return;
        }
        if (l3 < 300000L) {
            this.doSecondScale();
            this.scalingType = 1;
        } else if (l3 < 14400000L) {
            this.doMinuteScale();
            this.scalingType = 2;
        } else if (l3 < 345600000L) {
            this.doHourScale();
            this.scalingType = 3;
        } else if (l3 < 2419200000L) {
            this.doDayScale();
            this.scalingType = 4;
        } else if (l3 < 10368000000L) {
            this.doWeekScale();
            this.scalingType = 5;
        } else if (l3 < 126144000000L) {
            this.doMonthScale();
            this.scalingType = 6;
        } else {
            this.doYearScale();
            this.scalingType = 7;
        }
        this.numMajTicks = this.numLabels;
        this.numGrids = this.numLabels;
        this.numMinTicks = 2 * this.numLabels;
    }

    public void setScalingType(int n) {
        this.scalingType = n;
    }

    public int getScalingType() {
        return this.scalingType;
    }

    protected String getLabel(double d, int n) {
        switch (this.scalingType) {
            case 1: {
                return this.getSecondLabel(n);
            }
            case 2: {
                return this.getMinuteLabel(n);
            }
            case 3: {
                return this.getHourLabel(n);
            }
            case 4: {
                return this.getDayLabel(n);
            }
            case 5: {
                return this.getWeekLabel(n);
            }
            case 6: {
                return this.getMonthLabel(n);
            }
            case 7: {
                return this.getYearLabel(n);
            }
        }
        return "bad";
    }

    protected void doSecondScale() {
        long l;
        long l2;
        long l3 = this.endDate.getTime();
        long l4 = l3 - (l2 = this.startDate.getTime());
        long l5 = this.getMagnitude(l4);
        if (l5 < 0L) {
            l = this.getMsIncrement(l4, l5);
            while (l2 % l != 0L) {
                --l2;
            }
            while (l3 % l != 0L) {
                ++l3;
            }
        } else {
            l = this.getSIncrement(l4, l5);
            while (l2 % l != 0L) {
                --l2;
            }
            while (l3 % l != 0L) {
                ++l3;
            }
        }
        this.stepSize = l;
        this.axisStart = l2;
        this.axisEnd = l3;
        this.numLabels = (int)((this.axisEnd - this.axisStart) / (double)this.stepSize);
    }

    /*
     * Unable to fully structure code
     */
    long getSIncrement(long var1_1, long var3_2) {
        block3: {
            if (var1_1 <= 5000L) {
                return 1000L;
            }
            var5_3 = var1_1 / 4L;
            if (var5_3 > 5000L) ** GOTO lbl10
            while (var5_3 % 2000L > 0L) {
                ++var5_3;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                ++var5_3;
lbl10:
                // 2 sources

                ** while (var5_3 % 5000L > 0L)
            }
        }
        return var5_3;
    }

    long getMsIncrement(long l, long l2) {
        double d = l2 == -1L ? 1.0 : (l2 == -2L ? 10.0 : 100.0);
        double d2 = (double)l / (5.0 * d);
        double d3 = d2 > 0.0 && d2 < 0.5 ? d * 0.5 : (d2 > 0.5 && d2 < 1.0 ? d : (d2 > 1.0 && d2 < 9.0 ? d * 2.0 : d));
        return (long)d3;
    }

    long getMagnitude(long l) {
        if (l > 2000L) {
            long l2 = 15000L;
            int n = 1;
            while (true) {
                if (l2 > l) {
                    return n - 1;
                }
                l2 += 15000L;
                ++n;
            }
        }
        if (l < 10L) {
            return -1L;
        }
        if (l < 100L) {
            return -2L;
        }
        return -3L;
    }

    protected String getSecondLabel(int n) {
        this.tmpDate.setTime((long)this.axisStart + (long)n * this.stepSize);
        if (this.stepSize < 1000L) {
            long l = this.tmpDate.getTime();
            int n2 = this.tmpDate.getSeconds();
            if (n2 == 0) {
                return new String(String.valueOf(this.tmpDate.getMinutes()) + ":0" + this.tmpDate.getSeconds() + ":" + l);
            }
            return new String(String.valueOf(this.tmpDate.getSeconds()) + ":" + l);
        }
        int n3 = this.tmpDate.getSeconds();
        int n4 = this.tmpDate.getMinutes();
        if (n3 < 10) {
            return new String(String.valueOf(this.tmpDate.getMinutes()) + ":0" + this.tmpDate.getSeconds());
        }
        return new String(String.valueOf(this.tmpDate.getMinutes()) + ":" + this.tmpDate.getSeconds());
    }

    void doMinuteScale() {
        long l = this.endDate.getTime();
        long l2 = this.startDate.getTime();
        long l3 = l - l2;
        long l4 = this.getMinuteIncrement(l3);
        l2 = l2 / 1000L * 1000L;
        while (l2 % l4 != 0L) {
            l2 -= 1000L;
        }
        l = l / 1000L * 1000L;
        while (l % l4 != 0L) {
            l += 1000L;
        }
        this.stepSize = l4;
        this.axisStart = l2;
        this.axisEnd = l;
        this.numLabels = (int)((this.axisEnd - this.axisStart) / (double)this.stepSize);
    }

    /*
     * Unable to fully structure code
     */
    long getMinuteIncrement(long var1_1) {
        block5: {
            block4: {
                if (var1_1 <= 300000L) {
                    return 60000L;
                }
                var3_2 = var1_1 / 4L;
                var3_2 /= 1000L;
                if ((var3_2 *= 1000L) > 300000L) break block4;
                while (var3_2 % 120000L > 0L) {
                    var3_2 += 1000L;
                }
                break block5;
            }
            if (var3_2 > 300000L) ** GOTO lbl17
            while (var3_2 % 300000L > 0L) {
                var3_2 += 1000L;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                var3_2 += 1000L;
lbl17:
                // 2 sources

                ** while (var3_2 % 900000L > 0L)
            }
        }
        return var3_2;
    }

    protected String getMinuteLabel(int n) {
        this.tmpDate.setTime((long)this.axisStart + (long)n * this.stepSize);
        int n2 = this.tmpDate.getSeconds();
        int n3 = this.tmpDate.getMinutes();
        String string = n2 < 10 ? new String(":0" + n2) : new String(":" + n2);
        String string2 = n3 == 0 ? new String(String.valueOf(this.tmpDate.getHours()) + ":00") : (n3 < 10 ? new String(String.valueOf(this.tmpDate.getHours()) + ":0" + n3) : new String(String.valueOf(this.tmpDate.getHours()) + ":" + n3));
        return new String(String.valueOf(string2) + string);
    }

    protected void doHourScale() {
        int n = this.endDate.getMinutes();
        long l = this.endDate.getTime();
        l /= 3600000L;
        l *= 3600000L;
        if (n > 0) {
            this.endDate.setTime(l + 3600000L);
        } else {
            this.endDate.setTime(l);
        }
        long l2 = this.startDate.getTime();
        l2 /= 3600000L;
        this.startDate.setTime(l2 *= 3600000L);
        long l3 = l - l2;
        long l4 = this.getHourIncrement(l3);
        n = this.startDate.getHours();
        while ((long)n % l4 != 0L) {
            --n;
        }
        this.startDate.setHours(n);
        n = this.endDate.getHours();
        while ((long)n % l4 != 0L) {
            ++n;
        }
        while (n > 23) {
            long l5 = this.endDate.getTime();
            this.endDate.setTime(l5 += 86400000L);
            n -= 24;
        }
        this.endDate.setHours(n);
        this.stepSize = l4 * 3600000L;
        this.axisStart = this.startDate.getTime();
        this.axisEnd = this.endDate.getTime();
        this.numLabels = (int)((this.axisEnd - this.axisStart) / (double)this.stepSize);
    }

    /*
     * Unable to fully structure code
     */
    long getHourIncrement(long var1_1) {
        if (var1_1 <= 10800000L) {
            return 1L;
        }
        var3_2 = var1_1 / 5L / 60000L;
        if (var3_2 <= 60L) {
            return 2L;
        }
        if (var3_2 > 180L) ** GOTO lbl9
        return 3L;
lbl-1000:
        // 1 sources

        {
            ++var3_2;
lbl9:
            // 2 sources

            ** while (var3_2 % 360L > 0L)
        }
lbl10:
        // 1 sources

        return var3_2 / 60L;
    }

    protected String getHourLabel(int n) {
        int n2;
        this.tmpDate.setTime((long)this.axisStart + (long)n * this.stepSize);
        String string = null;
        int n3 = this.tmpDate.getHours();
        if (n3 == 0) {
            string = this.dayString(this.tmpDate.getDay());
            this.tmpDate.setHours(24);
        }
        String string2 = (n2 = this.tmpDate.getMinutes()) < 10 ? new String(String.valueOf(this.tmpDate.getHours()) + ":0" + n2) : new String(String.valueOf(this.tmpDate.getHours()) + ":" + n2);
        if (string != null) {
            return String.valueOf(string) + " " + string2;
        }
        return string2;
    }

    protected void doDayScale() {
        int n = this.endDate.getHours();
        long l = this.endDate.getTime();
        this.endDate.setHours(0);
        this.endDate.setMinutes(0);
        this.endDate.setSeconds(0);
        if (n > 0) {
            l = this.endDate.getTime();
            this.endDate.setTime(l + 86400000L);
        }
        this.startDate.setHours(0);
        this.startDate.setMinutes(0);
        this.startDate.setSeconds(0);
        long l2 = this.startDate.getTime();
        l = this.endDate.getTime();
        long l3 = l - l2;
        long l4 = this.getDayIncrement(l3);
        n = this.startDate.getDate();
        while ((long)n % l4 != 0L) {
            --n;
        }
        this.startDate.setDate(n);
        n = (int)((this.endDate.getTime() - this.startDate.getTime()) / 86400000L);
        while ((long)n % l4 != 0L) {
            ++n;
        }
        this.endDate.setTime(this.startDate.getTime() + (long)n * 86400000L);
        this.axisStart = this.startDate.getTime();
        this.axisEnd = this.endDate.getTime();
        this.stepSize = 86400000L * l4;
        this.numLabels = (int)((this.axisEnd - this.axisStart) / (double)this.stepSize);
    }

    long getDayIncrement(long l) {
        if (l <= 604800000L) {
            return 1L;
        }
        if (l <= 1209600000L) {
            return 2L;
        }
        if (l <= 2419200000L) {
            return 3L;
        }
        long l2 = l / 5L;
        l2 /= 86400000L;
        l2 *= 86400000L;
        while (l2 % 604800000L > 0L) {
            l2 += 86400000L;
        }
        return l2 / 86400000L;
    }

    protected String getDayLabel(int n) {
        this.tmpDate.setTime((long)this.axisStart + (long)n * this.stepSize);
        return String.valueOf(String.valueOf(this.tmpDate.getMonth() + 1)) + "/" + String.valueOf(this.tmpDate.getDate());
    }

    protected void doWeekScale() {
        int n = this.endDate.getHours();
        long l = this.endDate.getTime();
        this.endDate.setHours(0);
        this.endDate.setMinutes(0);
        this.endDate.setSeconds(0);
        if (n > 0) {
            l = this.endDate.getTime();
            this.endDate.setTime(l + 86400000L);
        }
        this.startDate.setHours(0);
        this.startDate.setMinutes(0);
        this.startDate.setSeconds(0);
        n = this.startDate.getDay();
        while (this.endDate.getDay() != n) {
            this.endDate.setDate(this.endDate.getDate() + 1);
        }
        long l2 = this.startDate.getTime();
        l = this.endDate.getTime();
        long l3 = l - l2;
        this.stepSize = this.getWIncrement(l3);
        while (l3 % this.stepSize > 86400000L) {
            l3 = (l += 86400000L) - l2;
        }
        this.endDate.setTime(l);
        this.axisStart = this.startDate.getTime();
        this.axisEnd = this.endDate.getTime();
        this.numLabels = (int)((this.axisEnd - this.axisStart) / (double)this.stepSize);
    }

    long getWIncrement(long l) {
        if (l <= 604800000L) {
            return 86400000L;
        }
        if (l <= 1209600000L) {
            return 172800000L;
        }
        if (l <= 2419200000L) {
            return 259200000L;
        }
        long l2 = l / 5L;
        l2 /= 86400000L;
        l2 *= 86400000L;
        while (l2 % 604800000L > 0L) {
            l2 += 86400000L;
        }
        return l2;
    }

    protected String getWeekLabel(int n) {
        this.tmpDate.setTime((long)this.axisStart + (long)n * this.stepSize);
        return String.valueOf(this.monthString(this.tmpDate.getMonth())) + " " + this.tmpDate.getDate();
    }

    protected void doMonthScale() {
        if (this.endDate.getDate() > 1) {
            this.endDate.setMonth(this.endDate.getMonth() + 1);
        }
        this.endDate.setDate(1);
        this.endDate.setHours(0);
        this.endDate.setMinutes(0);
        this.endDate.setSeconds(0);
        this.startDate.setDate(1);
        this.startDate.setHours(0);
        this.startDate.setMinutes(0);
        this.startDate.setSeconds(0);
        int n = this.startDate.getYear() * 12 + (this.startDate.getMonth() + 1);
        int n2 = this.endDate.getYear() * 12 + (this.endDate.getMonth() + 1);
        int n3 = n2 - n;
        int n4 = n3 / 5;
        if (n4 == 0) {
            n4 = 1;
        }
        while (n3 % n4 != 0) {
            ++n3;
            this.endDate.setMonth(this.endDate.getMonth() + 1);
        }
        this.axisStart = this.startDate.getTime();
        this.axisEnd = this.endDate.getTime();
        this.stepSize = n4;
        this.numLabels = n3 / (int)this.stepSize;
    }

    protected String getMonthLabel(int n) {
        this.tmpDate.setTime((long)this.axisStart);
        int n2 = this.tmpDate.getMonth();
        int n3 = (int)((long)n * this.stepSize + (long)n2) / 12;
        int n4 = (int)((long)n * this.stepSize + (long)n2) % 12;
        this.tmpDate.setYear(this.tmpDate.getYear() + n3);
        this.tmpDate.setMonth(n4);
        if (this.tmpDate.getYear() < 100) {
            return String.valueOf(this.monthString(this.tmpDate.getMonth())) + " '" + String.valueOf(this.tmpDate.getYear());
        }
        return String.valueOf(this.monthString(this.tmpDate.getMonth())) + " '" + String.valueOf(this.tmpDate.getYear() - 100);
    }

    long getMonthPosition(int n) {
        this.tmpDate.setTime((long)this.axisStart);
        this.tmpDate.setMonth(this.tmpDate.getMonth() + (int)((long)n * this.stepSize));
        return this.tmpDate.getTime();
    }

    protected void doYearScale() {
        if (this.endDate.getMonth() > 0) {
            this.endDate.setYear(this.endDate.getYear() + 1);
        }
        this.endDate.setMonth(0);
        this.endDate.setDate(1);
        this.endDate.setHours(0);
        this.endDate.setMinutes(0);
        this.endDate.setSeconds(0);
        this.startDate.setMonth(0);
        this.startDate.setDate(1);
        this.startDate.setHours(0);
        this.startDate.setMinutes(0);
        this.startDate.setSeconds(0);
        int n = this.startDate.getYear();
        int n2 = this.endDate.getYear();
        int n3 = n2 - n;
        int n4 = n3 / 5;
        if (n4 == 0) {
            n4 = 1;
        }
        while (n3 % n4 != 0) {
            ++n3;
            this.endDate.setYear(this.endDate.getYear() + 1);
        }
        this.axisStart = this.startDate.getTime();
        this.axisEnd = this.endDate.getTime();
        this.stepSize = n4;
        this.numLabels = (this.endDate.getYear() - this.startDate.getYear()) / n4;
    }

    protected String getYearLabel(int n) {
        this.tmpDate.setTime((long)this.axisStart);
        this.tmpDate.setYear(this.tmpDate.getYear() + (int)((long)n * this.stepSize));
        return String.valueOf(1900 + this.tmpDate.getYear());
    }

    long getYearPosition(int n) {
        this.tmpDate.setTime((long)this.axisStart);
        this.tmpDate.setYear(this.tmpDate.getYear() + (int)((long)n * this.stepSize));
        return this.tmpDate.getTime();
    }

    protected String monthString(int n) {
        switch (n) {
            case 0: {
                return "Jan";
            }
            case 1: {
                return "Feb";
            }
            case 2: {
                return "Mar";
            }
            case 3: {
                return "Apr";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "Jun";
            }
            case 6: {
                return "Jul";
            }
            case 7: {
                return "Aug";
            }
            case 8: {
                return "Sep";
            }
            case 9: {
                return "Oct";
            }
            case 10: {
                return "Nov";
            }
        }
        return "Dec";
    }

    protected String dayString(int n) {
        switch (n) {
            case 0: {
                return "Sun";
            }
            case 1: {
                return "Mon";
            }
            case 2: {
                return "Tue";
            }
            case 3: {
                return "Wed";
            }
            case 4: {
                return "Thu";
            }
            case 5: {
                return "Fri";
            }
        }
        return "Sat";
    }
}

