/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.Vector;
import javachart.chart.Datum;
import javachart.chart.Gc;
import javachart.chart.Globals;

public class Dataset
implements Serializable {
    Vector data;
    String setName;
    Gc gc;
    Color labelColor = Color.black;
    Font labelFont;
    Globals globals;

    public Dataset() {
        this("new", null, null, new Globals());
    }

    public Dataset(String string, double[] dArray, double[] dArray2, Globals globals) {
        this.init(string, -1, globals);
        int n = 0;
        while (n < dArray.length) {
            this.data.addElement(new Datum(dArray[n], dArray2[n], globals));
            ++n;
        }
    }

    public Dataset(String string, double[] dArray, double[] dArray2, int n, Globals globals) {
        this.init(string, n, globals);
        int n2 = 0;
        while (n2 < dArray.length) {
            this.data.addElement(new Datum(dArray[n2], dArray2[n2], n, globals));
            ++n2;
        }
    }

    public Dataset(String string, double[] dArray, int n, Globals globals) {
        this.init(string, n, globals);
        int n2 = 0;
        while (n2 < dArray.length) {
            this.data.addElement(new Datum((double)n2, dArray[n2], n, globals));
            ++n2;
        }
    }

    public Dataset(String string, double[] dArray, String[] stringArray, int n, Globals globals) {
        this.init(string, n, globals);
        int n2 = 0;
        while (n2 < dArray.length) {
            try {
                this.data.addElement(new Datum((double)n2, dArray[n2], stringArray[n2], n, globals));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.data.addElement(new Datum((double)n2, dArray[n2], "", n, globals));
            }
            ++n2;
        }
    }

    public Dataset(String string, double[] dArray, double[] dArray2, String[] stringArray, int n, Globals globals) {
        this.init(string, n, globals);
        int n2 = 0;
        while (n2 < dArray2.length) {
            this.data.addElement(new Datum(dArray[n2], dArray2[n2], stringArray[n2], n, globals));
            ++n2;
        }
    }

    public Dataset(String string, double[] dArray, double[] dArray2, double[] dArray3, String[] stringArray, int n, Globals globals) {
        this.init(string, n, globals);
        int n2 = 0;
        while (n2 < dArray2.length) {
            try {
                this.data.addElement(new Datum(dArray[n2], dArray2[n2], dArray3[n2], stringArray[n2], n, globals));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
            ++n2;
        }
    }

    public Dataset(String string, double[] dArray, double[] dArray2, double[] dArray3, int n, Globals globals) {
        this.init(string, n, globals);
        int n2 = 0;
        while (n2 < dArray2.length) {
            this.data.addElement(new Datum(dArray[n2], dArray2[n2], dArray3[n2], n, globals));
            ++n2;
        }
    }

    public Dataset(String string, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n, Globals globals) {
        this.init(string, n, globals);
        int n2 = 0;
        while (n2 < dArray2.length) {
            this.data.addElement(new Datum(dArray[n2], dArray2[n2], dArray3[n2], dArray4[n2], globals));
            ++n2;
        }
    }

    public Dataset(String string, double[] dArray, String[] stringArray, boolean bl, Globals globals) {
        this.init(string, 1, globals);
        int n = 0;
        while (n < dArray.length) {
            try {
                this.data.addElement(new Datum((double)n, dArray[n], stringArray[n], bl, globals));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.data.addElement(new Datum((double)n, dArray[n], bl, globals));
            }
            ++n;
        }
    }

    public Dataset(String string, double[] dArray, boolean bl, Globals globals) {
        this.init(string, 1, globals);
        int n = 0;
        while (n < dArray.length) {
            this.data.addElement(new Datum((double)n, dArray[n], bl, globals));
            ++n;
        }
    }

    public synchronized void replaceYData(double[] dArray) {
        int n = this.data.size();
        if (dArray.length > n) {
            int n2 = 0;
            while (n2 < n) {
                ((Datum)this.data.elementAt((int)n2)).y = dArray[n2];
                ++n2;
            }
            n2 = n;
            while (n2 < dArray.length) {
                this.data.addElement(new Datum(0.0, dArray[n2], 0.0, 0.0, this.globals));
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < dArray.length) {
            ((Datum)this.data.elementAt((int)n3)).y = dArray[n3];
            ++n3;
        }
    }

    public synchronized void replaceY2Data(double[] dArray) {
        int n = this.data.size();
        if (dArray.length > n) {
            int n2 = 0;
            while (n2 < n) {
                ((Datum)this.data.elementAt((int)n2)).y2 = dArray[n2];
                ++n2;
            }
            n2 = n;
            while (n2 < dArray.length) {
                this.data.addElement(new Datum(0.0, 0.0, dArray[n2], 0.0, this.globals));
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < dArray.length) {
            ((Datum)this.data.elementAt((int)n3)).y2 = dArray[n3];
            ++n3;
        }
    }

    public synchronized void replaceY3Data(double[] dArray) {
        int n = this.data.size();
        if (dArray.length > n) {
            int n2 = 0;
            while (n2 < n) {
                ((Datum)this.data.elementAt((int)n2)).y3 = dArray[n2];
                ++n2;
            }
            n2 = n;
            while (n2 < dArray.length) {
                this.data.addElement(new Datum(0.0, 0.0, 0.0, dArray[n2], this.globals));
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < dArray.length) {
            ((Datum)this.data.elementAt((int)n3)).y3 = dArray[n3];
            ++n3;
        }
    }

    public synchronized void replaceXData(double[] dArray) {
        int n = this.data.size();
        if (dArray.length > n) {
            int n2 = 0;
            while (n2 < n) {
                ((Datum)this.data.elementAt((int)n2)).x = dArray[n2];
                ++n2;
            }
            n2 = n;
            while (n2 < dArray.length) {
                this.data.addElement(new Datum(dArray[n2], 0.0, this.globals));
                ++n2;
            }
            return;
        }
        int n3 = 0;
        while (n3 < dArray.length) {
            ((Datum)this.data.elementAt((int)n3)).x = dArray[n3];
            ++n3;
        }
    }

    public Vector getData() {
        return this.data;
    }

    public void setData(Vector vector) {
        this.data = vector;
    }

    public String getName() {
        return this.setName;
    }

    public void setName(String string) {
        this.setName = string;
    }

    public Gc getGc() {
        return this.gc;
    }

    public void setGc(Gc gc) {
        this.gc = gc;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Globals getGlobals() {
        return this.globals;
    }

    public void setGlobals(Globals globals) {
        this.globals = globals;
    }

    public synchronized double minX() {
        double d = ((Datum)this.data.elementAt((int)0)).x;
        int n = this.data.size();
        int n2 = 1;
        while (n2 < n) {
            d = this.min(d, ((Datum)this.data.elementAt((int)n2)).x);
            ++n2;
        }
        return d;
    }

    public synchronized double minY() {
        double d = ((Datum)this.data.elementAt((int)0)).y;
        int n = this.data.size();
        int n2 = 1;
        while (n2 < n) {
            d = this.min(d, ((Datum)this.data.elementAt((int)n2)).y);
            ++n2;
        }
        return d;
    }

    public synchronized double minY2() {
        double d = ((Datum)this.data.elementAt((int)0)).y2;
        int n = this.data.size();
        int n2 = 1;
        while (n2 < n) {
            d = this.min(d, ((Datum)this.data.elementAt((int)n2)).y2);
            ++n2;
        }
        return d;
    }

    public synchronized double minY3() {
        double d = ((Datum)this.data.elementAt((int)0)).y3;
        int n = this.data.size();
        int n2 = 1;
        while (n2 < n) {
            d = this.min(d, ((Datum)this.data.elementAt((int)n2)).y3);
            ++n2;
        }
        return d;
    }

    public synchronized double maxX() {
        double d = ((Datum)this.data.elementAt((int)0)).x;
        int n = this.data.size();
        int n2 = 1;
        while (n2 < n) {
            d = this.max(d, ((Datum)this.data.elementAt((int)n2)).x);
            ++n2;
        }
        return d;
    }

    public synchronized double maxY() {
        double d = ((Datum)this.data.elementAt((int)0)).y;
        int n = this.data.size();
        int n2 = 1;
        while (n2 < n) {
            d = this.max(d, ((Datum)this.data.elementAt((int)n2)).y);
            ++n2;
        }
        return d;
    }

    public synchronized double maxY2() {
        double d = ((Datum)this.data.elementAt((int)0)).y2;
        int n = this.data.size();
        int n2 = 1;
        while (n2 < n) {
            d = this.max(d, ((Datum)this.data.elementAt((int)n2)).y2);
            ++n2;
        }
        return d;
    }

    public synchronized double maxY3() {
        double d = ((Datum)this.data.elementAt((int)0)).y3;
        int n = this.data.size();
        int n2 = 1;
        while (n2 < n) {
            d = this.max(d, ((Datum)this.data.elementAt((int)n2)).y3);
            ++n2;
        }
        return d;
    }

    private double min(double d, double d2) {
        if (d2 == Double.NEGATIVE_INFINITY) {
            return d;
        }
        return Math.min(d, d2);
    }

    private double max(double d, double d2) {
        if (d2 == Double.NEGATIVE_INFINITY) {
            return d;
        }
        return Math.max(d, d2);
    }

    public synchronized double[] getXValues() {
        double[] dArray = new double[this.data.size()];
        int n = 0;
        while (n < this.data.size()) {
            dArray[n] = ((Datum)this.data.elementAt((int)n)).x;
            ++n;
        }
        return dArray;
    }

    public synchronized double[] getYValues() {
        double[] dArray = new double[this.data.size()];
        int n = 0;
        while (n < this.data.size()) {
            dArray[n] = ((Datum)this.data.elementAt((int)n)).y;
            ++n;
        }
        return dArray;
    }

    public synchronized double[] getY2Values() {
        double[] dArray = new double[this.data.size()];
        int n = 0;
        while (n < this.data.size()) {
            dArray[n] = ((Datum)this.data.elementAt((int)n)).y2;
            ++n;
        }
        return dArray;
    }

    public synchronized double[] getY3Values() {
        double[] dArray = new double[this.data.size()];
        int n = 0;
        while (n < this.data.size()) {
            dArray[n] = ((Datum)this.data.elementAt((int)n)).y3;
            ++n;
        }
        return dArray;
    }

    public Datum getDataElementAt(int n) {
        return (Datum)this.data.elementAt(n);
    }

    public void dump() {
        int n = 0;
        while (n < this.data.size()) {
            System.out.println("X " + ((Datum)this.data.elementAt((int)n)).x + " Y " + ((Datum)this.data.elementAt((int)n)).y + " Y2 " + ((Datum)this.data.elementAt((int)n)).y2);
            ++n;
        }
    }

    private void init(String string, int n, Globals globals) {
        this.setName = string;
        this.data = new Vector();
        this.globals = globals;
        this.gc = n == -1 ? new Gc(globals) : new Gc(n, globals);
        this.labelFont = new Font("TimesRoman", 0, 12);
        this.labelColor = Color.black;
    }
}

