/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Point;
import java.io.Serializable;
import javachart.chart.Chart;
import javachart.chart.Datum;
import javachart.chart.Transform;

public class DataTransform
implements Serializable {
    private Transform dataXfm;
    private Chart myChart;

    public DataTransform(Chart chart) {
        this.myChart = chart;
        this.buildTransform();
    }

    public void resize() {
        this.buildTransform();
    }

    public Point datumToPoint(Datum datum) {
        return this.dataXfm.point(datum.x, datum.y);
    }

    public Datum pointToDatum(Point point) {
        return new Datum(this.dataXfm.xValue(point.x), this.dataXfm.yValue(this.myChart.globals.maxY - point.y), this.myChart.globals);
    }

    private void buildTransform() {
        double d = this.myChart.getXAxis().getAxisStart();
        double d2 = this.myChart.getXAxis().getAxisEnd();
        double d3 = this.myChart.getYAxis().getAxisStart();
        double d4 = this.myChart.getYAxis().getAxisEnd();
        this.dataXfm = new Transform(d, d3, d2, d4, this.myChart.plotarea.transform.point(this.myChart.plotarea.llX, this.myChart.plotarea.llY), this.myChart.plotarea.transform.point(this.myChart.plotarea.urX, this.myChart.plotarea.urY));
        this.dataXfm.logXScaling = this.myChart.getXAxis().getLogScaling();
        this.dataXfm.logYScaling = this.myChart.getYAxis().getLogScaling();
    }
}

