/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import javachart.chart.AxisInterface;
import javachart.chart.Background;
import javachart.chart.ChartInterface;
import javachart.chart.Dataset;
import javachart.chart.DisplayList;
import javachart.chart.Globals;
import javachart.chart.LegendInterface;
import javachart.chart.Plotarea;
import javachart.chart.RotateString;

public abstract class Chart
implements ChartInterface,
Serializable {
    String name = "New Chart";
    protected Graphics canvas;
    protected boolean legendVisible = false;
    protected int width = 640;
    protected int height = 480;
    boolean xAxisVisible = true;
    boolean yAxisVisible = true;
    protected Globals globals;
    protected Dataset[] datasets;
    protected Plotarea plotarea;
    protected Background background;
    protected LegendInterface legend;
    int numberOfDatasets = 0;
    String routineName = "Initialization Value";
    int errNo = 0;
    public static final int MAX_DATASETS = 40;

    public Chart() {
        this.initChart();
    }

    public Chart(String string) {
        this.name = string;
        this.initChart();
    }

    public Chart(String string, Graphics graphics) {
        this.name = string;
        if (graphics == null) {
            return;
        }
        this.canvas = graphics;
        this.initChart();
    }

    public void addDataSet(String string, double[] dArray) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = new Dataset(string, dArray, this.numberOfDatasets, this.globals);
            ++this.numberOfDatasets;
        } else {
            System.out.println("max datasets is 40");
        }
    }

    public void addDataSet(String string, double[] dArray, double[] dArray2) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = new Dataset(string, dArray, dArray2, this.numberOfDatasets, this.globals);
            ++this.numberOfDatasets;
        } else {
            System.out.println("max datasets is 40");
        }
    }

    public void addDataSet(String string, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = new Dataset(string, dArray, dArray2, dArray3, dArray4, this.numberOfDatasets, this.globals);
            ++this.numberOfDatasets;
        } else {
            System.out.println("maximum number of datasets is 40");
        }
    }

    public void addDataSet(String string, double[] dArray, double[] dArray2, String[] stringArray) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = new Dataset(string, dArray, dArray2, stringArray, this.numberOfDatasets, this.globals);
            ++this.numberOfDatasets;
        } else {
            System.out.println("max datasets is 40");
        }
    }

    public void addDataSet(String string, double[] dArray, String[] stringArray) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = new Dataset(string, dArray, stringArray, this.numberOfDatasets, this.globals);
            ++this.numberOfDatasets;
        } else {
            System.out.println("maximum number of datasets is 40");
        }
    }

    public void addDataset(Dataset dataset) {
        if (this.numberOfDatasets < 40) {
            this.datasets[this.numberOfDatasets] = dataset;
            ++this.numberOfDatasets;
        } else {
            System.out.println("max datasets is 40");
        }
    }

    public void deleteDataSet(String string) {
        int n = 0;
        while (n < this.numberOfDatasets) {
            if (this.datasets[n].setName.equals(string)) {
                this.deleteDataSet(this.datasets[n]);
                return;
            }
            ++n;
        }
    }

    public void deleteDataSet(Dataset dataset) {
        int n = 0;
        while (n < this.numberOfDatasets) {
            if (this.datasets[n] == dataset) {
                this.datasets[n] = null;
                int n2 = n + 1;
                while (n2 < this.numberOfDatasets) {
                    this.datasets[n2 - 1] = this.datasets[n2];
                    ++n2;
                }
            }
            ++n;
        }
        --this.numberOfDatasets;
    }

    public void drawGraph() {
        if (this.globals.useDisplayList) {
            this.globals.displayList.clear();
        }
    }

    public void drawGraph(Graphics graphics) {
        if (this.globals.useDisplayList) {
            this.globals.displayList.clear();
        }
    }

    public Background getBackground() {
        return this.background;
    }

    public Graphics getCanvas() {
        return this.canvas;
    }

    public Dataset getDataset(String string) {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] != null && this.datasets[n].setName.equals(string)) {
                return this.datasets[n];
            }
            ++n;
        }
        return null;
    }

    public Dataset[] getDatasets() {
        return this.datasets;
    }

    public DisplayList getDisplayList() {
        return this.globals.getDisplayList();
    }

    public Globals getGlobals() {
        return this.globals;
    }

    public int getHeight() {
        return this.height;
    }

    public Image getImage() {
        return this.globals.getImage();
    }

    public LegendInterface getLegend() {
        return this.legend;
    }

    public String getName() {
        return this.name;
    }

    public int getNumDatasets() {
        return this.numberOfDatasets;
    }

    public Plotarea getPlotarea() {
        return this.plotarea;
    }

    public RotateString getStringRotator() {
        return this.globals.stringRotator;
    }

    public boolean getUseDisplayList() {
        return this.globals.getUseDisplayList();
    }

    public int getWidth() {
        return this.width;
    }

    public AxisInterface getXAxis() {
        return null;
    }

    public int getXOffset() {
        return this.globals.xOffset;
    }

    public AxisInterface getYAxis() {
        return null;
    }

    public int getYOffset() {
        return this.globals.yOffset;
    }

    public boolean includesDataset(Dataset dataset) {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] == dataset) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void initChart() {
    }

    protected void initDataSets() {
        this.datasets = new Dataset[40];
    }

    protected void initGlobals() {
        this.globals = new Globals();
    }

    public boolean isLegendVisible() {
        return this.legendVisible;
    }

    public boolean isThreeD() {
        return this.globals.threeD;
    }

    public boolean isXAxisVisible() {
        return this.xAxisVisible;
    }

    public boolean isYAxisVisible() {
        return this.yAxisVisible;
    }

    public void paint() {
        this.drawGraph();
    }

    public void paint(Graphics graphics) {
        this.drawGraph(graphics);
    }

    public void resize(int n, int n2) {
        this.globals.maxY = n2;
        this.plotarea.resize(n, n2);
        this.background.resize(n, n2);
        this.legend.resize(n, n2);
        this.globals.maxX = n;
        this.globals.maxY = n2;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public void setCanvas(Graphics graphics) {
        this.canvas = graphics;
    }

    public void setDisplayList(DisplayList displayList) {
        this.globals.setDisplayList(displayList);
    }

    public void setGlobals(Globals globals) {
        this.globals = globals;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setImage(Image image) {
        this.globals.setImage(image);
    }

    public void setLegend(LegendInterface legendInterface) {
        this.legend = legendInterface;
    }

    public void setLegendVisible(boolean bl) {
        this.legendVisible = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPlotarea(Plotarea plotarea) {
        this.plotarea = plotarea;
    }

    public void setStringRotator(RotateString rotateString) {
        this.globals.stringRotator = rotateString;
    }

    public void setThreeD(boolean bl) {
        this.globals.threeD = bl;
    }

    public void setUseDisplayList(boolean bl) {
        this.globals.setUseDisplayList(bl);
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setXAxis(AxisInterface axisInterface) {
    }

    public void setXAxisVisible(boolean bl) {
        this.xAxisVisible = bl;
    }

    public void setXOffset(int n) {
        this.globals.xOffset = n;
    }

    public void setYAxis(AxisInterface axisInterface) {
    }

    public void setYAxisVisible(boolean bl) {
        this.yAxisVisible = bl;
    }

    public void setYOffset(int n) {
        this.globals.yOffset = n;
    }
}

