/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Background;
import javachart.chart.Bar;
import javachart.chart.Chart;
import javachart.chart.Dataset;
import javachart.chart.LabelAxis;
import javachart.chart.Legend;
import javachart.chart.Line;
import javachart.chart.Plotarea;
import javachart.chart.StackAxis;
import javachart.chart.StackColumn;

public class BarLineChart
extends Chart {
    Line line;
    Bar bar;
    AxisInterface xAxis;
    AxisInterface yAxis;
    Dataset[] lineData;
    Dataset[] barData;
    public int[] dataAllocation;
    public static final int BAR = 0;
    public static final int LINE = 1;

    public BarLineChart() {
    }

    public BarLineChart(String string) {
        super(string);
    }

    public BarLineChart(String string, Graphics graphics) {
        super(string, graphics);
    }

    private void distributeDatasets() {
        int n = 0;
        int n2 = 0;
        while (n2 < 20) {
            if (this.dataAllocation[n2] == 0) {
                this.barData[n++] = this.datasets[n2];
            }
            ++n2;
        }
        this.bar.datasets = this.barData;
        n = 0;
        n2 = 0;
        while (n2 < 20) {
            if (this.dataAllocation[n2] == 1) {
                this.lineData[n++] = this.datasets[n2];
            }
            ++n2;
        }
        this.line.datasets = this.lineData;
        if (!this.yAxis.getAutoScale()) {
            return;
        }
        Axis axis = this.yAxis instanceof StackAxis ? (StackAxis)this.yAxis : (Axis)this.yAxis;
        axis.datasets = this.lineData;
        axis.scale();
        double d = axis.axisEnd;
        axis.datasets = this.barData;
        axis.scale();
        double d2 = axis.axisEnd;
        if (d > d2) {
            axis.datasets = this.lineData;
        }
    }

    public void drawGraph() {
        if (this.canvas == null) {
            return;
        }
        this.drawGraph(this.canvas);
    }

    public void drawGraph(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.drawGraph();
        this.distributeDatasets();
        this.background.draw(graphics);
        this.plotarea.draw(graphics);
        if (this.xAxisVisible) {
            this.xAxis.draw(graphics);
        } else {
            this.xAxis.scale();
        }
        if (this.yAxisVisible) {
            this.yAxis.draw(graphics);
        } else {
            this.yAxis.scale();
        }
        this.bar.draw(graphics);
        this.line.draw(graphics);
        if (this.legendVisible) {
            this.legend.draw(graphics);
        }
    }

    public Bar getBar() {
        return this.bar;
    }

    public Line getLine() {
        return this.line;
    }

    public AxisInterface getXAxis() {
        return this.xAxis;
    }

    public AxisInterface getYAxis() {
        return this.yAxis;
    }

    protected void initAxes() {
        this.xAxis = new LabelAxis(this.datasets, true, this.plotarea);
        this.xAxis.setBarScaling(true);
        this.yAxis = new Axis(this.datasets, false, this.plotarea);
        this.yAxis.setBarScaling(true);
    }

    protected synchronized void initChart() {
        this.initGlobals();
        this.plotarea = new Plotarea(this.globals);
        this.background = new Background(this.globals);
        this.initDataSets();
        this.initAxes();
        this.dataAllocation = new int[20];
        int n = 0;
        while (n < 20) {
            this.dataAllocation[n] = 1;
            ++n;
        }
        this.bar = new Bar(this.datasets, this.xAxis, this.yAxis, this.plotarea);
        this.line = new Line(this.datasets, this.xAxis, this.yAxis, this.plotarea);
        this.legend = new Legend(this.datasets, this.globals);
        this.resize(640, 480);
    }

    protected void initDataSets() {
        this.datasets = new Dataset[20];
        this.barData = new Dataset[20];
        this.lineData = new Dataset[20];
    }

    public void setArea(Line line) {
        this.line = line;
    }

    public void setBar(Bar bar) {
        this.bar = bar;
    }

    public synchronized void setChartType(int n, int n2) {
        if (n2 < 0 || n2 > 1) {
            System.out.println("bad Chart Type");
            return;
        }
        if (n > 20) {
            System.out.println("bad dataset number");
            return;
        }
        this.dataAllocation[n] = n2;
    }

    public synchronized void setStackedBar(boolean bl) {
        if (bl) {
            this.yAxis = new StackAxis(this.datasets, false, this.plotarea);
            this.yAxis.setBarScaling(true);
            this.bar = new StackColumn(this.datasets, this.xAxis, this.yAxis, this.plotarea);
            this.line.setYAxis(this.yAxis);
        } else {
            this.bar = new Bar(this.datasets, this.xAxis, this.yAxis, this.plotarea);
        }
    }

    public void setXAxis(LabelAxis labelAxis) {
        this.xAxis = labelAxis;
    }

    public void setYAxis(Axis axis) {
        this.yAxis = axis;
    }
}

