/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Graphics;
import javachart.chart.Area;
import javachart.chart.Axis;
import javachart.chart.AxisInterface;
import javachart.chart.Background;
import javachart.chart.Chart;
import javachart.chart.LabelAxis;
import javachart.chart.Legend;
import javachart.chart.Plotarea;
import javachart.chart.StackAxis;

public class AreaChart
extends Chart {
    Area area;
    AxisInterface xAxis;
    AxisInterface yAxis;

    public AreaChart() {
    }

    public AreaChart(String string) {
        super(string);
    }

    public AreaChart(String string, Graphics graphics) {
        super(string, graphics);
    }

    public Area area() {
        return this.area;
    }

    public synchronized void drawGraph() {
        if (this.canvas == null) {
            return;
        }
        this.drawGraph(this.canvas);
    }

    public synchronized void drawGraph(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.drawGraph();
        this.background.draw(graphics);
        this.plotarea.draw(graphics);
        this.xAxis.draw(graphics);
        this.yAxis.draw(graphics);
        if (this.area.doClip) {
            if (this.legendVisible) {
                this.legend.draw(graphics);
            }
            this.area.draw(graphics);
            return;
        }
        this.area.draw(graphics);
        if (this.legendVisible) {
            this.legend.draw(graphics);
        }
    }

    public AxisInterface getXAxis() {
        return this.xAxis;
    }

    public AxisInterface getYAxis() {
        return this.yAxis;
    }

    protected void initAxes() {
        this.xAxis = new LabelAxis(this.datasets, true, this.plotarea);
        this.xAxis.setBarScaling(false);
        this.yAxis = new StackAxis(this.datasets, false, this.plotarea);
    }

    protected synchronized void initChart() {
        this.initGlobals();
        this.plotarea = new Plotarea(this.globals);
        this.background = new Background(this.globals);
        this.initDataSets();
        this.initAxes();
        this.area = new Area(this.datasets, this.xAxis, this.yAxis, this.plotarea);
        this.legend = new Legend(this.datasets, this.globals);
        this.resize(640, 480);
    }

    public void setXAxis(LabelAxis labelAxis) {
        this.xAxis = labelAxis;
    }

    public void setYAxis(Axis axis) {
        this.yAxis = axis;
    }
}

