/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import javachart.chart.AxisInterface;
import javachart.chart.Dataset;
import javachart.chart.Globals;
import javachart.chart.Plotarea;
import javachart.chart.Transform;

public class Area
implements Serializable {
    AxisInterface yAxis;
    AxisInterface xAxis;
    Plotarea plotarea;
    Dataset[] datasets;
    double xAxisStart;
    double xAxisEnd;
    double yAxisStart;
    double yAxisEnd;
    boolean doClip = false;
    Transform dataXfm;
    boolean useDisplayList = true;
    protected Globals globals;
    private int numDataSets;

    public Area(Dataset[] datasetArray, AxisInterface axisInterface, AxisInterface axisInterface2, Plotarea plotarea) {
        this.datasets = datasetArray;
        this.xAxis = axisInterface;
        this.yAxis = axisInterface2;
        this.plotarea = plotarea;
        this.globals = this.plotarea.globals;
    }

    public void setDoClip(boolean bl) {
        this.doClip = bl;
    }

    public boolean getDoClip() {
        return this.doClip;
    }

    public boolean getUseDisplayList() {
        return this.useDisplayList;
    }

    public void setUseDisplayList(boolean bl) {
        this.useDisplayList = bl;
    }

    public void draw(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        this.doAreas(graphics);
    }

    private synchronized void doAreas(Graphics graphics) {
        this.numDataSets = this.datasetsInUse();
        this.xAxisStart = this.xAxis.getAxisStart();
        this.xAxisEnd = this.xAxis.getAxisEnd();
        if (this.yAxis.getLogScaling()) {
            this.yAxisStart = Math.pow(10.0, this.yAxis.getAxisStart());
            this.yAxisEnd = Math.pow(10.0, this.yAxis.getAxisEnd());
        } else {
            this.yAxisStart = this.yAxis.getAxisStart();
            this.yAxisEnd = this.yAxis.getAxisEnd();
        }
        this.dataXfm = new Transform(this.xAxisStart, this.yAxis.getAxisStart(), this.xAxisEnd, this.yAxis.getAxisEnd(), this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY), this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY));
        this.dataXfm.logXScaling = this.xAxis.getLogScaling();
        this.dataXfm.logYScaling = this.yAxis.getLogScaling();
        if (this.doClip) {
            Point point = this.plotarea.transform.point(this.plotarea.llX, this.plotarea.llY);
            Point point2 = this.plotarea.transform.point(this.plotarea.urX, this.plotarea.urY);
            graphics.clipRect(point.x, this.globals.maxY - point2.y, point2.x - point.x, point2.y - point.y);
        }
        int n = 0;
        while (n < this.numDataSets) {
            this.doArea(graphics, this.numDataSets - n - 1);
            ++n;
        }
    }

    private int datasetsInUse() {
        int n = 0;
        while (n < this.datasets.length) {
            if (this.datasets[n] == null) {
                return n;
            }
            ++n;
        }
        return n;
    }

    protected synchronized double getBaseY(int n, int n2) {
        double d = 0.0;
        int n3 = 0;
        while (n3 < n) {
            d += this.datasets[n3].getDataElementAt((int)n2).y;
            ++n3;
        }
        if (d <= 0.0 && this.yAxis.getLogScaling()) {
            d = Math.pow(10.0, this.yAxis.getAxisStart());
        }
        return d;
    }

    private synchronized void doArea(Graphics graphics, int n) {
        double[] dArray = this.datasets[n].getXValues();
        double[] dArray2 = this.datasets[n].getYValues();
        double[] dArray3 = new double[dArray2.length + 2];
        double[] dArray4 = new double[dArray.length + 2];
        int n2 = 0;
        while (n2 < dArray2.length) {
            dArray3[n2] = dArray2[n2] + this.getBaseY(n, n2);
            dArray4[n2] = dArray[n2];
            ++n2;
        }
        dArray4[n2] = dArray4[n2 - 1];
        dArray4[n2 + 1] = dArray4[0];
        dArray3[n2] = this.yAxisStart;
        dArray3[n2 + 1] = this.yAxisStart;
        if (this.globals.threeD) {
            if (n == this.numDataSets - 1) {
                this.doTop(graphics, n, dArray4, dArray3);
            }
            this.doSide(graphics, n, dArray4[dArray4.length - 3], dArray3[dArray3.length - 3]);
        }
        this.dataXfm.pointList(dArray4, dArray3);
        this.datasets[n].gc.drawPolygon(graphics, this.dataXfm.pointList(dArray4, dArray3));
        if (this.useDisplayList && this.globals.useDisplayList) {
            this.globals.displayList.addPolygon(this.datasets[n], this.dataXfm.pointList(dArray4, dArray3));
        }
    }

    private synchronized void doTop(Graphics graphics, int n, double[] dArray, double[] dArray2) {
        int n2 = this.globals.xOffset;
        int n3 = this.globals.yOffset;
        Point[] pointArray = new Point[4];
        Color color = this.datasets[n].gc.fillColor;
        this.datasets[n].gc.fillColor = color.darker();
        int n4 = 0;
        while (n4 < dArray.length - 3) {
            pointArray[0] = this.dataXfm.point(dArray[n4], dArray2[n4]);
            pointArray[1] = new Point(pointArray[0].x + n2, pointArray[0].y + n3);
            pointArray[3] = this.dataXfm.point(dArray[n4 + 1], dArray2[n4 + 1]);
            pointArray[2] = new Point(pointArray[3].x + n2, pointArray[3].y + n3);
            this.datasets[n].gc.drawPolygon(graphics, pointArray);
            this.datasets[n].gc.drawPolyline(graphics, pointArray);
            ++n4;
        }
        this.datasets[n].gc.fillColor = color;
    }

    private synchronized void doSide(Graphics graphics, int n, double d, double d2) {
        Point[] pointArray = new Point[4];
        Color color = this.datasets[n].gc.fillColor;
        this.datasets[n].gc.fillColor = color.darker();
        pointArray[0] = this.dataXfm.point(d, d2);
        double d3 = d;
        double d4 = this.getBaseY(n, this.datasets[n].data.size() - 1);
        d4 = this.yAxis.getAxisStart() > d4 ? this.yAxis.getAxisStart() : d4;
        pointArray[1] = this.dataXfm.point(d3, d4);
        pointArray[2] = new Point(pointArray[1].x + this.globals.xOffset, pointArray[1].y + this.globals.yOffset);
        pointArray[3] = new Point(pointArray[0].x + this.globals.xOffset, pointArray[0].y + this.globals.yOffset);
        this.datasets[n].gc.drawPolygon(graphics, pointArray);
        this.datasets[n].gc.fillColor = color;
    }
}

