/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.data;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;
import javachart.beans.data.SimpleDataFeed;

public abstract class URLDataFeed
extends SimpleDataFeed
implements Runnable {
    private int interval = 60;
    private transient Thread myThread = null;
    private String delimitString = ",";
    private String myURLString = "http://www.ve.com/data/dummy.dat";
    private boolean externalTrigger = true;
    private InputStream myInputStream;
    private static int BUFFLEN = 4096;
    private char[] buff = new char[BUFFLEN];
    protected Vector tokenizedLines = new Vector();

    public URLDataFeed() {
        this.start();
    }

    protected boolean closeURL(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("can't close URL");
            return false;
        }
        return true;
    }

    public boolean getAutomaticUpdates() {
        return !this.externalTrigger;
    }

    public String getDelimiter() {
        return this.delimitString;
    }

    public int getInterval() {
        return this.interval;
    }

    protected String getLineFromURL(InputStream inputStream) {
        boolean bl = true;
        int n = -1;
        int n2 = 0;
        while (n2 < BUFFLEN) {
            this.buff[n2] = '\u0000';
            ++n2;
        }
        n2 = 0;
        while (bl) {
            try {
                n = inputStream.read();
            }
            catch (IOException iOException) {
                System.out.println("bad i/o operation");
            }
            if (n == -1) {
                bl = false;
                if (n2 == 0) {
                    return null;
                }
                return new String(this.buff, 0, n2);
            }
            if (n == 10 || n == 13) {
                if (n2 <= 0) continue;
                return new String(this.buff, 0, n2);
            }
            this.buff[n2] = (char)n;
            ++n2;
        }
        return new String(this.buff, 0, n2);
    }

    public String getURL() {
        return this.myURLString;
    }

    protected InputStream openURL(String string) {
        InputStream inputStream;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("couldn't open " + string);
            return null;
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            System.out.println("can't open stream " + string);
            return null;
        }
        return inputStream;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean readURLInfo() {
        var2_1 = this.openURL(this.myURLString);
        if (var2_1 != null) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            this.tokenizedLines.addElement(new StringTokenizer(var1_2, this.delimitString, false));
lbl5:
            // 2 sources

            ** while ((var1_2 = this.getLineFromURL((InputStream)var2_1)) != null)
        }
lbl6:
        // 1 sources

        this.closeURL(var2_1);
        this.updateDataArrays();
        this.tokenizedLines.removeAllElements();
        return true;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.interval * 1000);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("URL data feed interrupted!");
            }
            if (this.externalTrigger) continue;
            this.update();
            this.fireEvent();
        }
    }

    public void setAutomaticUpdates(boolean bl) {
        this.externalTrigger = !bl;
    }

    public void setDelimiter(String string) {
        this.delimitString = string;
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public void setURL(String string) {
        this.myURLString = string;
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
        }
        if (this.myThread.isAlive()) {
            return;
        }
        this.myThread.start();
    }

    public void stop() {
        if (this.myThread != null) {
            this.myThread.stop();
            this.myThread = null;
        }
    }

    public void update() {
        if (this.readURLInfo()) {
            super.update();
        }
    }

    protected void updateDataArrays() {
    }
}

