/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.StringTokenizer;
import java.util.Vector;
import javachart.beans.data.SimpleDataFeed;
import javachart.chart.Dataset;
import javachart.chart.Datum;

public class SocketListener
extends SimpleDataFeed
implements Runnable {
    private transient char[] buff = new char[256];
    private transient InputStreamReader myReader;
    private transient Socket mySocket;
    private transient InputStream myInputStream = null;
    private transient Thread myThread = null;
    boolean debug = false;
    String ipAddr = "localhost";
    int portNum = 830;
    boolean expectXValues = false;
    int maxObservations = 50;

    public SocketListener() {
        this.init();
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean getExpectXValues() {
        return this.expectXValues;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public String getLineFromSocket() {
        boolean bl = true;
        int n = -1;
        int n2 = 0;
        while (n2 < 256) {
            this.buff[n2] = '\u0000';
            ++n2;
        }
        n2 = 0;
        while (bl) {
            try {
                n = this.myReader.read();
            }
            catch (IOException iOException) {
                System.out.println("bad i/o operation");
                System.out.println("exiting...");
                System.exit(1);
            }
            if (n == -1) {
                bl = false;
                if (n2 == 0) {
                    return null;
                }
                return new String(this.buff, 0, n2);
            }
            if (n == 10 || n == 13) {
                if (n2 <= 0) continue;
                return new String(this.buff, 0, n2);
            }
            this.buff[n2] = (char)n;
            ++n2;
        }
        return new String(this.buff, 0, n2);
    }

    public int getMaxObservations() {
        return this.maxObservations;
    }

    public int getPortNum() {
        return this.portNum;
    }

    public void init() {
        try {
            this.mySocket = new Socket(this.ipAddr, this.portNum);
            this.myInputStream = this.mySocket.getInputStream();
            this.myReader = new InputStreamReader(this.myInputStream);
            this.start();
        }
        catch (Exception exception) {
            System.out.println("couldn't open a socket!");
        }
    }

    public static void main(String[] stringArray) {
        new SocketListener();
    }

    public void run() {
        while (true) {
            String string = this.getLineFromSocket();
            if (this.debug) {
                System.out.println(string);
            }
            this.stringToData(string);
            this.fireEvent();
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setExpectXValues(boolean bl) {
        this.expectXValues = bl;
    }

    public void setIpAddr(String string) {
        this.ipAddr = string;
    }

    public void setMaxObservations(int n) {
        this.maxObservations = n;
    }

    public void setPortNum(int n) {
        this.portNum = n;
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
        }
        if (this.myThread.isAlive()) {
            return;
        }
        this.myThread.start();
    }

    public void stop() {
        if (this.myThread != null) {
            this.myThread.stop();
            this.myThread = null;
        }
    }

    private void stringToData(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        double d = this.expectXValues ? Double.valueOf(stringTokenizer.nextToken()) : 0.0;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Vector vector;
            object = stringTokenizer.nextToken();
            if (this.debug) {
                System.out.println("got token " + (String)object);
            }
            if (this.myDatasetArray[n] == null) {
                this.myDatasetArray[n] = new Dataset("Dataset " + n, new double[0], n, this.myGlobals);
            }
            if ((vector = this.myDatasetArray[n].getData()).size() == this.maxObservations) {
                vector.removeElementAt(0);
            }
            double d2 = Double.valueOf((String)object);
            vector.addElement(new Datum(d, d2, true, this.myGlobals));
            ++n;
        }
        if (!this.expectXValues) {
            n = 0;
            while (n < this.myDatasetArray.length) {
                if (this.myDatasetArray[n] != null) {
                    object = this.myDatasetArray[n];
                    int n2 = 0;
                    while (n2 < ((Dataset)object).getData().size()) {
                        ((Dataset)object).getDataElementAt(n2).setX(n2);
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }
}

