/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.data;

import java.io.Serializable;
import java.util.Vector;
import javachart.beans.data.DataEvent;
import javachart.beans.data.DataFeedListener;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.Globals;

public abstract class SimpleDataFeed
implements Serializable {
    protected Globals myGlobals = new Globals();
    protected Dataset[] myDatasetArray = new Dataset[40];
    protected Vector listeners = null;
    protected DataEvent myEvent = new DataEvent(this);
    protected double[][] xArray;
    protected double[][] yArray;
    protected String[][] labelArray;

    public void addDataFeedListener(DataFeedListener dataFeedListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(dataFeedListener);
    }

    protected void fireEvent() {
        this.myEvent.datasetArray = this.myDatasetArray;
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        int n = 0;
        while (n < this.listeners.size()) {
            DataFeedListener dataFeedListener = (DataFeedListener)this.listeners.elementAt(n);
            dataFeedListener.newData(this.myEvent);
            ++n;
        }
    }

    public boolean getSendAuxData() {
        return (this.myEvent.modifiers & 8) != 0;
    }

    public boolean getSendLabels() {
        return (this.myEvent.modifiers & 0x10) != 0;
    }

    public boolean getSendSetNames() {
        return (this.myEvent.modifiers & 0x20) != 0;
    }

    public boolean getSendXData() {
        return (this.myEvent.modifiers & 2) != 0;
    }

    public boolean getSendYData() {
        return (this.myEvent.modifiers & 1) != 0;
    }

    public boolean getSendZData() {
        return (this.myEvent.modifiers & 4) != 0;
    }

    public void removeDataFeedListener(DataFeedListener dataFeedListener) {
        this.listeners.removeElement(dataFeedListener);
    }

    public void setSendAuxData(boolean bl) {
        this.myEvent.modifiers = bl ? (this.myEvent.modifiers |= 8) : (this.myEvent.modifiers &= 0xFFFFFFF7);
    }

    public void setSendLabels(boolean bl) {
        this.myEvent.modifiers = bl ? (this.myEvent.modifiers |= 0x10) : (this.myEvent.modifiers &= 0xFFFFFFEF);
    }

    public void setSendSetNames(boolean bl) {
        this.myEvent.modifiers = bl ? (this.myEvent.modifiers |= 0x20) : (this.myEvent.modifiers &= 0xFFFFFFDF);
    }

    public void setSendXData(boolean bl) {
        this.myEvent.modifiers = bl ? (this.myEvent.modifiers |= 2) : (this.myEvent.modifiers &= 0xFFFFFFFD);
    }

    public void setSendYData(boolean bl) {
        this.myEvent.modifiers = bl ? (this.myEvent.modifiers |= 1) : (this.myEvent.modifiers &= 0xFFFFFFFE);
    }

    public void setSendZData(boolean bl) {
        this.myEvent.modifiers = bl ? (this.myEvent.modifiers |= 4) : (this.myEvent.modifiers &= 0xFFFFFFFB);
    }

    public void update() {
        this.fireEvent();
    }

    protected void updateDataset(int n, Dataset dataset) {
        Vector vector = dataset.getData();
        int n2 = this.yArray[n].length;
        while (vector.size() > n2) {
            vector.removeElementAt(n2);
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            ((Datum)vector.elementAt(n3)).setY(this.yArray[n][n3]);
            ((Datum)vector.elementAt(n3)).setX(this.xArray[n][n3]);
            if (this.labelArray != null && this.labelArray.length > n && this.labelArray[n] != null) {
                ((Datum)vector.elementAt(n3)).setLabel(this.labelArray[n][n3]);
            }
            ++n3;
        }
        if (vector.size() < n2) {
            n3 = vector.size();
            while (n3 < n2) {
                if (this.labelArray != null) {
                    if (this.labelArray.length > n && this.labelArray[n] != null) {
                        vector.addElement(new Datum(this.xArray[n][n3], this.yArray[n][n3], this.labelArray[n][n3], true, this.myGlobals));
                    } else {
                        vector.addElement(new Datum(this.xArray[n][n3], this.yArray[n][n3], true, this.myGlobals));
                    }
                } else {
                    vector.addElement(new Datum(this.xArray[n][n3], this.yArray[n][n3], true, this.myGlobals));
                }
                ++n3;
            }
        }
    }

    protected void updateDatasets() {
        int n;
        int n2 = n = this.yArray.length;
        while (n2 < this.myDatasetArray.length) {
            this.myDatasetArray[n2] = null;
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            Dataset dataset = this.myDatasetArray[n2];
            if (dataset == null) {
                this.myDatasetArray[n2] = dataset = new Dataset("Dataset " + n2, new double[0], n2, this.myGlobals);
            }
            this.updateDataset(n2, dataset);
            ++n2;
        }
    }
}

