/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.data;

import java.beans.PropertyChangeEvent;
import java.util.Date;
import java.util.Vector;
import javachart.beans.data.SimpleDataFeed;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.Globals;

public class QuoteMonitorBridge
extends SimpleDataFeed {
    private int maximumQuotes = 500;
    private int numberOfQuotes = 0;
    String[] qMonitorNames = new String[]{"bid", "ask", "price"};
    private double[] thisObservation = new double[3];
    private double currentDate;
    private double currentBid;
    private double currentAsk;
    private double currentPrice;
    private double currentVolume;
    private Globals dummyGlobals = new Globals();

    public int getMaximumQuotes() {
        return this.maximumQuotes;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("date")) {
            this.currentDate = ((Date)propertyChangeEvent.getNewValue()).getTime();
        }
        if (propertyChangeEvent.getPropertyName().equals("bid")) {
            this.currentBid = (Double)propertyChangeEvent.getNewValue();
        }
        if (propertyChangeEvent.getPropertyName().equals("ask")) {
            this.currentAsk = (Double)propertyChangeEvent.getNewValue();
        }
        if (propertyChangeEvent.getPropertyName().equals("price")) {
            this.currentPrice = (Double)propertyChangeEvent.getNewValue();
            this.update();
        }
    }

    public void reset() {
        this.numberOfQuotes = 0;
    }

    public void setMaximumQuotes(int n) {
        this.maximumQuotes = n;
    }

    public void update() {
        this.thisObservation[0] = this.currentBid;
        this.thisObservation[1] = this.currentAsk;
        this.thisObservation[2] = this.currentPrice;
        this.updateDatasets();
        ++this.numberOfQuotes;
        this.fireEvent();
    }

    protected void updateDataset(int n, Dataset dataset) {
        dataset.setName(this.qMonitorNames[n]);
        Vector vector = dataset.getData();
        if (this.numberOfQuotes == 0) {
            vector.removeAllElements();
        }
        if (this.numberOfQuotes > this.maximumQuotes) {
            while (vector.size() > this.maximumQuotes) {
                vector.removeElementAt(0);
            }
        }
        vector.addElement(new Datum(this.currentDate, this.thisObservation[n], true, this.dummyGlobals));
    }

    protected void updateDatasets() {
        int n = 0;
        while (n < this.thisObservation.length) {
            if (this.myDatasetArray[n] == null) {
                this.myDatasetArray[n] = new Dataset();
            }
            this.updateDataset(n, this.myDatasetArray[n]);
            ++n;
        }
    }
}

