/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.data;

import javachart.beans.data.SimpleDataFeed;

public class DataFeedSimulator
extends SimpleDataFeed
implements Runnable {
    private int interval = 5;
    private transient Thread myThread = null;
    private int numberOfPoints = 3;
    private int numberOfSets = 1;
    private float scaleFactor = 1.0f;
    private String[] myLabels = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "X"};

    public DataFeedSimulator() {
        this.start();
    }

    public int getInterval() {
        return this.interval;
    }

    public int getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public int getNumberOfSets() {
        return this.numberOfSets;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.interval * 1000);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Simple data feed interrupted!");
            }
            this.updateDataArrays();
            this.fireEvent();
        }
    }

    public void setInterval(int n) {
        this.interval = n;
        this.updateDataArrays();
        this.fireEvent();
    }

    public void setNumberOfPoints(int n) {
        this.numberOfPoints = n;
        this.updateDataArrays();
        this.fireEvent();
    }

    public void setNumberOfSets(int n) {
        if (n > 40) {
            return;
        }
        this.numberOfSets = n;
        this.updateDataArrays();
        this.fireEvent();
    }

    public void setScaleFactor(float f) {
        this.scaleFactor = f;
        this.updateDataArrays();
        this.fireEvent();
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
        }
        if (this.myThread.isAlive()) {
            return;
        }
        this.myThread.start();
        System.out.println("Starting...");
    }

    public void stop() {
        if (this.myThread != null) {
            this.myThread.stop();
            System.out.println("Stopping...");
            this.myThread = null;
        }
    }

    public void update() {
        this.updateDataArrays();
        super.update();
    }

    protected void updateDataArrays() {
        if (this.xArray == null || this.xArray.length != this.numberOfSets) {
            this.xArray = new double[this.numberOfSets][];
        }
        if (this.yArray == null || this.yArray.length != this.numberOfSets) {
            this.yArray = new double[this.numberOfSets][];
        }
        if (this.labelArray == null || this.labelArray.length != this.numberOfSets) {
            this.labelArray = new String[this.numberOfSets][];
        }
        int n = 0;
        while (n < this.numberOfSets) {
            if (this.xArray[n] == null || this.xArray[n].length != this.numberOfPoints) {
                this.xArray[n] = new double[this.numberOfPoints];
            }
            if (this.yArray[n] == null || this.yArray[n].length != this.numberOfPoints) {
                this.yArray[n] = new double[this.numberOfPoints];
            }
            if (this.labelArray[n] == null || this.labelArray[n].length != this.numberOfPoints) {
                this.labelArray[n] = new String[this.numberOfPoints];
            }
            ++n;
        }
        n = 0;
        while (n < this.numberOfSets) {
            int n2 = 0;
            while (n2 < this.numberOfPoints) {
                this.xArray[n][n2] = n2;
                this.yArray[n][n2] = Math.random() * (double)this.scaleFactor;
                this.labelArray[n][n2] = this.myLabels[n2 % 26];
                ++n2;
            }
            ++n;
        }
        this.updateDatasets();
    }
}

