/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.customizer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;

class TabStrip
extends Canvas
implements MouseListener {
    static final int TAB_HEIGHT = 18;
    protected static final int END_MARGIN = 10;
    protected String[] labels;
    protected int numLabels;
    protected int currentTab;
    protected PropertyChangeSupport propertyManager;
    protected int currentTabStripWidth;
    protected int tabWidth;
    protected Polygon deselectedTabShape;
    protected Polygon selectedTabShape;
    protected Vector onImages;
    protected Vector offImages;
    protected Color panelColor;
    protected Color textColor;
    protected Color highlightColor;
    protected Color shadowColor;
    protected static String[] _testTabs = new String[]{"Tab1", "Tab2", "Tab3", "Tab4"};

    public TabStrip() {
        this(_testTabs);
    }

    public TabStrip(String[] stringArray) {
        this.labels = stringArray;
        this.currentTab = 0;
        this.propertyManager = new PropertyChangeSupport(this);
        this.setBackground(SystemColor.control);
        this.addMouseListener(this);
        this.reInitialize();
    }

    protected void reInitialize() {
        this.numLabels = this.labels.length;
        this.currentTabStripWidth = -1;
    }

    public void setSelectedTab(int n) {
        int n2 = this.currentTab;
        this.currentTab = n;
        this.propertyManager.firePropertyChange("selected Tab", this.labels[n2], this.labels[this.currentTab]);
        this.repaint();
    }

    public int getSelectedTab() {
        return this.currentTab;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        if (this.panelColor == null) {
            this.panelColor = SystemColor.control;
            this.textColor = SystemColor.textText;
            this.highlightColor = SystemColor.controlLtHighlight;
            this.shadowColor = SystemColor.controlShadow;
        }
        if ((n = this.getSize().width - 10) != this.currentTabStripWidth) {
            this.currentTabStripWidth = n;
            this.tabWidth = n / this.numLabels;
            this.selectedTabShape = this.recalcSelectedTabShape(this.tabWidth);
            this.deselectedTabShape = this.recalcDeselectedTabShape(this.tabWidth);
            this.onImages = new Vector();
            this.offImages = new Vector();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n2 = 0;
            while (n2 < this.numLabels) {
                Image image = this.renderSelectedTab(this.selectedTabShape, this.labels[n2], fontMetrics);
                this.onImages.addElement(image);
                Image image2 = this.renderDeselectedTab(this.deselectedTabShape, this.labels[n2], fontMetrics);
                this.offImages.addElement(image2);
                ++n2;
            }
        }
        graphics.setColor(this.highlightColor);
        graphics.drawLine(0, 17, this.getSize().width, 17);
        graphics.translate(5, 0);
        int n3 = 0;
        while (n3 < this.numLabels) {
            if (n3 == this.currentTab) {
                graphics.drawImage((Image)this.onImages.elementAt(n3), 0, 0, this);
            } else {
                graphics.drawImage((Image)this.offImages.elementAt(n3), 0, 0, this);
            }
            graphics.translate(this.tabWidth, 0);
            ++n3;
        }
    }

    protected Image renderSelectedTab(Polygon polygon, String string, FontMetrics fontMetrics) {
        Image image = this.createImage(this.tabWidth, 18);
        Graphics graphics = image.getGraphics();
        graphics.setColor(this.panelColor);
        graphics.fillRect(0, 0, this.tabWidth, 18);
        graphics.setColor(this.textColor);
        graphics.drawString(string, (this.tabWidth - fontMetrics.stringWidth(string)) / 2, 14);
        this.addSelectedEffects(polygon, graphics);
        return image;
    }

    protected Image renderDeselectedTab(Polygon polygon, String string, FontMetrics fontMetrics) {
        Image image = this.createImage(this.tabWidth, 18);
        Graphics graphics = image.getGraphics();
        graphics.setColor(this.panelColor);
        graphics.fillRect(0, 0, this.tabWidth, 18);
        graphics.setColor(SystemColor.textInactiveText);
        graphics.drawString(string, (this.tabWidth - fontMetrics.stringWidth(string)) / 2, 14);
        this.addDeSelectedEffects(polygon, graphics);
        return image;
    }

    private void addSelectedEffects(Polygon polygon, Graphics graphics) {
        graphics.setColor(this.highlightColor);
        graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[1], polygon.ypoints[1]);
        graphics.drawLine(polygon.xpoints[1], polygon.ypoints[1], polygon.xpoints[2], polygon.ypoints[2]);
        graphics.drawLine(polygon.xpoints[2], polygon.ypoints[2], polygon.xpoints[3], polygon.ypoints[3]);
        graphics.drawLine(polygon.xpoints[3], polygon.ypoints[3], polygon.xpoints[4] - 1, polygon.ypoints[4]);
        graphics.setColor(this.shadowColor);
        graphics.drawLine(polygon.xpoints[4] - 1, polygon.ypoints[4], polygon.xpoints[5] - 1, polygon.ypoints[5]);
        graphics.drawLine(polygon.xpoints[5] - 1, polygon.ypoints[5], polygon.xpoints[6] - 1, polygon.ypoints[6]);
        graphics.drawLine(polygon.xpoints[6] - 1, polygon.ypoints[6], polygon.xpoints[7] - 1, polygon.ypoints[7]);
    }

    private void addDeSelectedEffects(Polygon polygon, Graphics graphics) {
        graphics.setColor(this.highlightColor);
        graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0] - 1, polygon.xpoints[polygon.xpoints.length - 1], polygon.ypoints[polygon.ypoints.length - 1] - 1);
        graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[1], polygon.ypoints[1]);
        graphics.drawLine(polygon.xpoints[1], polygon.ypoints[1], polygon.xpoints[2], polygon.ypoints[2]);
        graphics.drawLine(polygon.xpoints[2], polygon.ypoints[2], polygon.xpoints[3], polygon.ypoints[3]);
        graphics.drawLine(polygon.xpoints[3], polygon.ypoints[3], polygon.xpoints[4] - 1, polygon.ypoints[4]);
        graphics.setColor(this.shadowColor);
        graphics.drawLine(polygon.xpoints[4] - 1, polygon.ypoints[4], polygon.xpoints[5] - 1, polygon.ypoints[5]);
        graphics.drawLine(polygon.xpoints[5] - 1, polygon.ypoints[5], polygon.xpoints[6] - 1, polygon.ypoints[6]);
        graphics.drawLine(polygon.xpoints[6] - 1, polygon.ypoints[6], polygon.xpoints[7] - 1, polygon.ypoints[7] - 2);
    }

    protected Polygon recalcDeselectedTabShape(int n) {
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 18);
        polygon.addPoint(0, 4);
        polygon.addPoint(1, 3);
        polygon.addPoint(2, 2);
        polygon.addPoint(this.tabWidth - 2, 2);
        polygon.addPoint(this.tabWidth - 1, 3);
        polygon.addPoint(this.tabWidth, 4);
        polygon.addPoint(this.tabWidth, 18);
        return polygon;
    }

    protected Polygon recalcSelectedTabShape(int n) {
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 18);
        polygon.addPoint(0, 2);
        polygon.addPoint(1, 1);
        polygon.addPoint(2, 0);
        polygon.addPoint(this.tabWidth - 2, 0);
        polygon.addPoint(this.tabWidth - 1, 1);
        polygon.addPoint(this.tabWidth, 2);
        polygon.addPoint(this.tabWidth, 18);
        return polygon;
    }

    public Dimension preferredSize() {
        return new Dimension(80 * this.numLabels, 18);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyManager.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyManager.removePropertyChangeListener(propertyChangeListener);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / this.tabWidth;
        this.setSelectedTab(n);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

