/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.customizer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javachart.beans.customizer.TabStrip;

public class TabPanel
extends Panel
implements PropertyChangeListener {
    protected String[] panelNames;
    protected Component[] panels;
    protected Panel overallContainer;
    protected Panel panelContainer;
    protected TabStrip tabStrip;
    protected CardLayout cardLayout = new CardLayout();
    protected int currentCard;

    public TabPanel(String[] stringArray, Component[] componentArray) {
        this.panelNames = stringArray;
        this.panels = componentArray;
        this.currentCard = 0;
        this.overallContainer = new Panel();
        this.add(this.overallContainer);
        this.setBackground(SystemColor.control);
        this.overallContainer.setBackground(SystemColor.control);
        this.panelContainer = new Panel();
        this.panelContainer.setLayout(this.cardLayout);
        this.panelContainer.setBackground(SystemColor.control);
        int n = 0;
        while (n < this.panels.length) {
            if (this.panels[n] instanceof Container) {
                this.panelContainer.add(this.panelNames[n], this.panels[n]);
            } else {
                Panel panel = new Panel();
                panel.add(this.panels[n]);
                this.panelContainer.add(this.panelNames[n], panel);
            }
            ++n;
        }
        this.panels[0].show();
        this.tabStrip = new TabStrip(this.panelNames);
        this.overallContainer.setLayout(new BorderLayout());
        this.overallContainer.add("North", this.tabStrip);
        this.overallContainer.add("Center", this.panelContainer);
        this.tabStrip.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.cardLayout.show(this.panelContainer, (String)propertyChangeEvent.getNewValue());
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("TabPanel Self Test");
        String[] stringArray2 = new String[]{"A One", "And a Two", "And A Three"};
        Checkbox checkbox = new Checkbox("Check Me");
        Choice choice = new Choice();
        choice.add("hello");
        choice.add("goodbye");
        Panel panel = new Panel();
        panel.add(new Button("hello"));
        panel.add(new Button("goodbye"));
        Component[] componentArray = new Component[]{panel, choice, checkbox};
        TabPanel tabPanel = new TabPanel(stringArray2, componentArray);
        tabPanel.setSize(200, 200);
        Checkbox checkbox2 = new Checkbox("Parental Check");
        Checkbox checkbox3 = new Checkbox("just checking...");
        Component[] componentArray2 = new Component[]{tabPanel, checkbox2, checkbox3};
        TabPanel tabPanel2 = new TabPanel(stringArray2, componentArray2);
        frame.add("Center", tabPanel2);
        ((Component)frame).setSize(new Dimension(300, 300));
        ((Component)frame).setVisible(true);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.overallContainer.getBounds();
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(rectangle.x - 1, rectangle.y - 1 + 18, rectangle.x - 1, rectangle.y + rectangle.height);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x + rectangle.width, rectangle.y + 18, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
    }
}

