/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.customizer;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javachart.beans.customizer.ColorComponent;
import javachart.beans.customizer.Dialog;
import javachart.beans.customizer.OnOffComponent;
import javachart.chart.Chart;
import javachart.chart.Speedo;
import javachart.chart.SpeedoAxis;
import javachart.chart.SpeedoChart;

public class SpeedoDialog
extends Dialog
implements ItemListener {
    private String[] styles = new String[]{"Arrow", "Needle", "Pointer", "Sweep"};
    private String[] positionNameList = new String[]{"Full Circle", "Half Circle Up", "Half Circle Down", "Half Circle Left", "Half Circle Right", "Quarter Circle LL", "Quarter Circle LR", "Quarter Circle UR", "Quarter Circle UL"};
    private Choice needleStyleList;
    private ColorComponent needleColors;
    private Choice speedoPositionList;
    private OnOffComponent labelsInside;
    private int saveNeedleStyle;
    private int saveSpeedoPosition;
    private boolean saveLabelsInside;
    private Color saveNeedleColor;
    private Speedo speedo;
    private SpeedoAxis axis;

    public SpeedoDialog() {
        this.setLayout(null);
    }

    public void show() {
        if (this.speedoPositionList != null) {
            super.show();
            return;
        }
        this.init();
        this.setVals();
        this.saveVals();
        super.show();
    }

    void setVals() {
        this.speedoPositionList.select(this.axis.getSpeedoPosition());
        this.needleStyleList.select(this.speedo.getNeedleStyle());
        this.needleColors.setValue(this.chart.getDatasets()[0].getGc().getLineColor());
        this.labelsInside.setValue(this.axis.getLabelsInside());
    }

    void getVals() {
        this.axis.setSpeedoPosition(this.stringToSpeedoPosition(this.speedoPositionList.getSelectedItem()));
        this.speedo.setNeedleStyle(this.stringToNeedleStyle(this.needleStyleList.getSelectedItem()));
        this.chart.getDatasets()[0].getGc().setLineColor(this.needleColors.getValue());
        this.chart.getDatasets()[0].getGc().setFillColor(this.needleColors.getValue());
        this.axis.setLabelsInside(this.labelsInside.getValue());
    }

    void saveVals() {
        this.saveSpeedoPosition = this.axis.getSpeedoPosition();
        this.saveNeedleStyle = this.speedo.getNeedleStyle();
        this.saveNeedleColor = this.chart.getDatasets()[0].getGc().getLineColor();
        this.saveLabelsInside = this.axis.getLabelsInside();
    }

    void restoreVals() {
        this.axis.setSpeedoPosition(this.speedoPositionList.getSelectedIndex());
        this.speedo.setNeedleStyle(this.needleStyleList.getSelectedIndex());
        this.chart.getDatasets()[0].getGc().setLineColor(this.needleColors.getValue());
        this.chart.getDatasets()[0].getGc().setFillColor(this.needleColors.getValue());
        this.axis.setLabelsInside(this.labelsInside.getValue());
    }

    public void setObject(Object object) {
        this.chart = (Chart)object;
        this.speedo = ((SpeedoChart)this.chart).getSpeedo();
        this.axis = (SpeedoAxis)((SpeedoChart)this.chart).getYAxis();
    }

    private void init() {
        Label label = new Label("Needle Style", 0);
        this.add(label);
        label.reshape(60, this.yPos, 80, 30);
        this.needleStyleList = new Choice();
        int n = 0;
        while (n < this.styles.length) {
            this.needleStyleList.addItem(this.styles[n]);
            ++n;
        }
        this.add(this.needleStyleList);
        this.needleStyleList.addItemListener(this);
        this.needleStyleList.reshape(140, this.yPos, 80, 30);
        this.yPos += 35;
        Label label2 = new Label("Orientation", 0);
        this.add(label2);
        label2.reshape(60, this.yPos, 80, 30);
        this.speedoPositionList = new Choice();
        int n2 = 0;
        while (n2 < this.positionNameList.length) {
            this.speedoPositionList.addItem(this.positionNameList[n2]);
            ++n2;
        }
        this.speedoPositionList.addItemListener(this);
        this.add(this.speedoPositionList);
        this.speedoPositionList.reshape(140, this.yPos, 80, 30);
        this.yPos += 35;
        this.needleColors = new ColorComponent("Needle Color", null);
        this.add(this.needleColors);
        this.needleColors.addPropertyChangeListener(this);
        this.needleColors.reshape(60, this.yPos, 250, 30);
        this.yPos += 35;
        this.labelsInside = new OnOffComponent("Labels Inside", true);
        this.add(this.labelsInside);
        this.labelsInside.addPropertyChangeListener(this);
        this.labelsInside.reshape(60, this.yPos, 250, 30);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.propertyChange(null);
    }

    private int stringToNeedleStyle(String string) {
        int n = 0;
        while (n < this.styles.length) {
            if (string == this.styles[n]) {
                return n;
            }
            ++n;
        }
        return 3;
    }

    private int stringToSpeedoPosition(String string) {
        int n = 0;
        while (n < this.positionNameList.length) {
            if (string == this.positionNameList[n]) {
                return n;
            }
            ++n;
        }
        return 1;
    }
}

