/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.customizer;

import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeListener;

class RangeComponent
extends Panel
implements AdjustmentListener {
    PropertyChangeListener parent;
    Label labelL;
    Label valueL;
    Scrollbar slider;

    public RangeComponent(String string, double d) {
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.setLayout(null);
        this.labelL = new Label(string);
        this.add(this.labelL);
        this.labelL.reshape(0, 0, 80, 30);
        this.slider = new Scrollbar(0, (int)(d * 100.0), 1, 0, 101);
        this.slider.addAdjustmentListener(this);
        this.add(this.slider);
        this.slider.reshape(80, 7, 150, 15);
        this.valueL = new Label("blank");
        this.setLabelText((int)(d * 100.0));
        this.add(this.valueL);
        this.valueL.reshape(252, 0, 30, 30);
    }

    public double getValue() {
        return (double)this.slider.getValue() / 100.0;
    }

    public void setValue(double d) {
        this.slider.setValue((int)(d * 100.0));
        this.setLabelText(this.slider.getValue());
    }

    private void setLabelText(int n) {
        if (n == 100) {
            this.valueL.setText("1.0");
            return;
        }
        if (n < 10) {
            this.valueL.setText("0.0" + String.valueOf(n));
            return;
        }
        this.valueL.setText("0." + String.valueOf(n));
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.setLabelText(this.slider.getValue());
        if (this.parent != null) {
            this.parent.propertyChange(null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.parent = propertyChangeListener;
    }
}

