/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.customizer;

import java.awt.Choice;
import java.awt.Label;
import java.awt.event.ItemEvent;
import javachart.beans.chart.ChartBean;
import javachart.beans.customizer.DatasetDialog;
import javachart.beans.customizer.IntComponent;

public class LineDatasetDialog
extends DatasetDialog {
    Choice markerSelector;
    IntComponent lineWidth;
    int saveWidth;
    private ChartBean myChartBean;
    private String[] markerList = new String[]{"None", "Yellow Ball", "Blue Ball", "Red Ball", "Purple Ball", "Orange Ball", "Pink Ball", "Green Ball"};

    protected void init() {
        super.init();
        this.yPos += 35;
        Label label = new Label("Marker:");
        this.add(label);
        label.reshape(40, this.yPos, 80, 30);
        this.markerSelector = new Choice();
        int n = 0;
        while (n < this.markerList.length) {
            this.markerSelector.addItem(this.markerList[n]);
            ++n;
        }
        this.markerSelector.addItemListener(this);
        this.add(this.markerSelector);
        this.markerSelector.reshape(120, this.yPos, 200, 30);
        this.yPos += 35;
        this.lineWidth = new IntComponent("Line Width", 1, 1, 10);
        this.lineWidth.addPropertyChangeListener(this);
        this.add(this.lineWidth);
        this.lineWidth.reshape(40, this.yPos, 250, 30);
    }

    void setVals() {
        super.setVals();
        this.lineWidth.setValue(this.dataset.getGc().getLineWidth());
    }

    void getVals() {
        super.getVals();
        this.dataset.getGc().setLineWidth(this.lineWidth.getValue());
    }

    void saveVals() {
        this.saveWidth = this.dataset.getGc().getLineWidth();
    }

    void restoreVals() {
        this.dataset.getGc().setLineWidth(this.saveWidth);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.markerSelector) {
            if (this.myChartBean != null) {
                this.myChartBean.setDatasetImageIndex(this.datasetSelector.getSelectedIndex(), this.markerSelector.getSelectedIndex());
            }
        } else {
            this.markerSelector.select(this.myChartBean.getDatasetImageIndex(this.datasetSelector.getSelectedIndex()));
        }
        super.itemStateChanged(itemEvent);
    }

    public void setChartBean(ChartBean chartBean) {
        this.myChartBean = chartBean;
    }
}

