/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.customizer;

import java.awt.Choice;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javachart.beans.customizer.IntComponent;

class FontComponent
extends Panel
implements ItemListener,
PropertyChangeListener {
    Label labelL;
    Choice menu;
    Font myFont;
    IntComponent pointSize;
    PropertyChangeListener parent;
    String[] fontList;

    public FontComponent(String string, Font font) {
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.fontList = this.getToolkit().getFontList();
        this.myFont = font == null ? new Font(this.fontList[0], 0, 12) : font;
        this.setLayout(null);
        this.labelL = new Label(string);
        this.add(this.labelL);
        this.labelL.reshape(0, 0, 80, 30);
        this.menu = new Choice();
        int n = 0;
        while (n < this.fontList.length) {
            this.menu.addItem(this.fontList[n]);
            ++n;
        }
        n = 0;
        while (n < this.fontList.length) {
            this.menu.addItem(String.valueOf(this.fontList[n]) + " Bold");
            ++n;
        }
        n = 0;
        while (n < this.fontList.length) {
            this.menu.addItem(String.valueOf(this.fontList[n]) + " Italic");
            ++n;
        }
        n = 0;
        while (n < this.fontList.length) {
            this.menu.addItem(String.valueOf(this.fontList[n]) + " Bold Italic");
            ++n;
        }
        this.menu.select(this.myFont.getName());
        this.menu.addItemListener(this);
        this.add(this.menu);
        this.menu.reshape(80, 0, 120, 30);
        this.pointSize = new IntComponent("Point Size", this.myFont.getSize(), 5, 50);
        this.pointSize.addPropertyChangeListener(this);
        this.add(this.pointSize);
        this.pointSize.reshape(0, 30, 262, 30);
    }

    public Font getValue() {
        if (this.menu.getSelectedItem().indexOf("Bold Italic") != -1) {
            return new Font(this.fontList[this.menu.getSelectedIndex() % this.fontList.length], 3, this.pointSize.getValue());
        }
        if (this.menu.getSelectedItem().indexOf("Italic") != -1) {
            return new Font(this.fontList[this.menu.getSelectedIndex() % this.fontList.length], 2, this.pointSize.getValue());
        }
        if (this.menu.getSelectedItem().indexOf("Bold") != -1) {
            return new Font(this.fontList[this.menu.getSelectedIndex() % this.fontList.length], 1, this.pointSize.getValue());
        }
        return new Font(this.menu.getSelectedItem(), 0, this.pointSize.getValue());
    }

    public void setValue(Font font) {
        this.myFont = font;
        if (this.myFont.getStyle() == 0) {
            this.menu.select(this.myFont.getName());
        } else if (this.myFont.getStyle() == 1) {
            this.menu.select(String.valueOf(this.myFont.getName()) + " Bold");
        } else if (this.myFont.getStyle() == 2) {
            this.menu.select(String.valueOf(this.myFont.getName()) + " Italic");
        } else if (this.myFont.getStyle() == 3) {
            this.menu.select(String.valueOf(this.myFont.getName()) + " Bold Italic");
        } else {
            this.menu.select(0);
        }
        this.pointSize.setValue(this.myFont.getSize());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.parent = propertyChangeListener;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.parent != null) {
            this.parent.propertyChange(null);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.parent != null) {
            this.parent.propertyChange(null);
        }
    }
}

