/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.customizer;

import java.awt.Choice;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import javachart.beans.customizer.ColorComponent;
import javachart.beans.customizer.Dialog;
import javachart.beans.customizer.StringComponent;
import javachart.chart.Chart;
import javachart.chart.Datum;

public class DatumDialog
extends Dialog
implements ItemListener {
    Chart chart;
    Datum myDatum;
    Vector datumList;
    StringComponent nameField;
    ColorComponent fillColor;
    Choice datumSelector;
    Label nameLabel;

    public DatumDialog() {
        this.setLayout(null);
    }

    public void show() {
        if (this.datumSelector != null) {
            super.show();
            return;
        }
        this.init();
        this.setVals();
        this.saveVals();
        super.show();
    }

    protected void init() {
        this.yPos = 40;
        Label label = new Label("Slice:");
        this.add(label);
        label.reshape(40, this.yPos, 80, 30);
        this.datumSelector = new Choice();
        this.datumSelector.addItemListener(this);
        this.add(this.datumSelector);
        this.datumSelector.reshape(120, this.yPos, 100, 30);
        this.yPos += 35;
        this.nameField = new StringComponent("Label", null, 20);
        this.nameField.addPropertyChangeListener(this);
        this.add(this.nameField);
        this.nameField.reshape(40, this.yPos, 300, 40);
        this.yPos += 40;
        this.fillColor = new ColorComponent("Color", null);
        this.fillColor.addPropertyChangeListener(this);
        this.add(this.fillColor);
        this.fillColor.reshape(40, this.yPos, 200, 30);
    }

    public void setObject(Object object) {
        this.chart = (Chart)object;
        this.datumList = this.chart.getDatasets()[0].getData();
        this.myDatum = (Datum)this.datumList.elementAt(0);
    }

    private void resetDatumSelector() {
        this.datumSelector.removeAll();
        int n = 0;
        while (n < this.datumList.size()) {
            this.datumSelector.addItem(((Datum)this.datumList.elementAt(n)).getString());
            ++n;
        }
        this.datumSelector.select(this.myDatum.getString());
    }

    void setVals() {
        this.resetDatumSelector();
        this.fillColor.setValue(this.myDatum.getGc().getFillColor());
        this.nameField.setValue(this.myDatum.getString());
    }

    void getVals() {
        this.myDatum.getGc().setFillColor(this.fillColor.getValue());
        this.myDatum.getGc().setLineColor(this.fillColor.getValue());
        if (this.nameField.getValue().length() > 0 && !this.myDatum.getString().equals(this.nameField.getValue())) {
            this.myDatum.setLabel(this.nameField.getValue());
        }
    }

    void saveVals() {
        this.saveColor1 = this.myDatum.getGc().getFillColor();
        this.saveString = this.myDatum.getString();
    }

    void restoreVals() {
        this.myDatum.getGc().setFillColor(this.saveColor1);
        this.myDatum.setLabel(this.saveString);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        this.resetDatumSelector();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.getVals();
        int n = 0;
        while (n < this.datumList.size()) {
            if (this.datumSelector.getSelectedItem().equals(((Datum)this.datumList.elementAt(n)).getString())) {
                this.myDatum = (Datum)this.datumList.elementAt(n);
                this.setVals();
                this.saveVals();
                return;
            }
            ++n;
        }
    }
}

