/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.customizer;

import java.awt.Choice;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import javachart.beans.customizer.ColorComponent;
import javachart.beans.customizer.Dialog;
import javachart.beans.customizer.StringComponent;
import javachart.chart.Chart;
import javachart.chart.Dataset;

public class DatasetDialog
extends Dialog
implements ItemListener {
    Chart chart;
    Dataset dataset;
    Dataset[] datasetList;
    StringComponent nameField;
    ColorComponent fillColor;
    Choice datasetSelector;

    public DatasetDialog() {
        this.setLayout(null);
    }

    public void show() {
        if (this.datasetSelector != null) {
            super.show();
            return;
        }
        this.init();
        this.setVals();
        this.saveVals();
        super.show();
    }

    protected void init() {
        this.yPos = 40;
        Label label = new Label("Dataset:");
        this.add(label);
        label.reshape(40, this.yPos, 80, 30);
        this.datasetSelector = new Choice();
        this.datasetSelector.addItemListener(this);
        this.add(this.datasetSelector);
        this.datasetSelector.reshape(120, this.yPos, 200, 30);
        this.yPos += 35;
        this.nameField = new StringComponent("Name", null, 20);
        this.nameField.addPropertyChangeListener(this);
        this.add(this.nameField);
        this.nameField.reshape(40, this.yPos, 300, 40);
        this.yPos += 40;
        this.fillColor = new ColorComponent("Color", null);
        this.fillColor.addPropertyChangeListener(this);
        this.add(this.fillColor);
        this.fillColor.reshape(40, this.yPos, 200, 30);
    }

    public void setObject(Object object) {
        this.chart = (Chart)object;
        this.datasetList = this.chart.getDatasets();
        this.dataset = this.datasetList[0];
    }

    private void resetDatasetSelector() {
        this.datasetSelector.removeAll();
        int n = 0;
        while (this.datasetList[n] != null) {
            this.datasetSelector.addItem(this.datasetList[n].getName());
            ++n;
        }
        this.datasetSelector.select(this.dataset.getName());
    }

    void setVals() {
        this.resetDatasetSelector();
        this.fillColor.setValue(this.dataset.getGc().getFillColor());
        this.nameField.setValue(this.dataset.getName());
    }

    void getVals() {
        this.dataset.getGc().setFillColor(this.fillColor.getValue());
        this.dataset.getGc().setLineColor(this.fillColor.getValue());
        this.dataset.setName(this.nameField.getValue());
    }

    void saveVals() {
        this.saveColor1 = this.dataset.getGc().getFillColor();
        this.saveString = this.dataset.getName();
    }

    void restoreVals() {
        this.dataset.getGc().setFillColor(this.saveColor1);
        this.dataset.setName(this.saveString);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        this.resetDatasetSelector();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.getVals();
        int n = 0;
        while (this.datasetList[n] != null) {
            if (this.datasetSelector.getSelectedItem().equals(this.datasetList[n].getName())) {
                this.dataset = this.datasetList[n];
                this.setVals();
                this.saveVals();
                return;
            }
            ++n;
        }
    }
}

