/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javachart.beans.customizer.Picker;

class ColorWell
extends Component
implements MouseListener,
PropertyChangeListener {
    private Frame parentFrame;
    private Color currentColor;
    private PropertyChangeListener parent;
    private Picker colorPicker;

    public void paint(Graphics graphics) {
        graphics.setColor(this.currentColor);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(0, 0, 0, this.getSize().height);
        graphics.drawLine(0, 0, this.getSize().width, 0);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(0, this.getSize().height - 1, this.getSize().width, this.getSize().height - 1);
        graphics.drawLine(this.getSize().width - 1, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public Dimension getPreferredSize() {
        return new Dimension(40, 20);
    }

    void setCurrentColor(Color color) {
        this.currentColor = color;
        this.repaint();
    }

    Color getCurrentColor() {
        return this.currentColor;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.parentFrame == null) {
            this.parentFrame = this.getParentFrame();
            this.colorPicker = new Picker(this.parentFrame);
            this.colorPicker.addPropertyChangeListener(this);
            this.addMouseMotionListener(this.colorPicker);
        }
        this.colorPicker.xOffset = mouseEvent.getX();
        this.colorPicker.yOffset = mouseEvent.getY();
        this.colorPicker.popUp(this.getLocationOnScreen().x + mouseEvent.getX(), this.getLocationOnScreen().y + mouseEvent.getY());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.colorPicker.popDown();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.parent = propertyChangeListener;
    }

    public void firePropertyChange(ItemEvent itemEvent) {
        if (this.parent != null) {
            this.parent.propertyChange(null);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setCurrentColor((Color)propertyChangeEvent.getNewValue());
        this.firePropertyChange(null);
    }

    private Frame getParentFrame() {
        Container container = this.getParent();
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    ColorWell() {
    }
}

