/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javachart.beans.customizer.ColorWell;

class ColorComponent
extends Panel
implements PropertyChangeListener {
    Label labelL;
    Color currentColor = Color.red;
    ColorWell colorWell = new ColorWell();
    private PropertyChangeListener parent;

    public ColorComponent(String string, Color color) {
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.setLayout(null);
        this.labelL = new Label(string);
        this.add(this.labelL);
        this.labelL.reshape(1, 0, 80, 30);
        this.add(this.colorWell);
        this.colorWell.reshape(80, 5, 40, 20);
        this.colorWell.addPropertyChangeListener(this);
        this.colorWell.addMouseListener(this.colorWell);
        this.setSize(145, 30);
    }

    public Color getValue() {
        return this.currentColor;
    }

    public void setValue(Color color) {
        this.currentColor = color;
        this.colorWell.setCurrentColor(color);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.parent = propertyChangeListener;
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.parent != null) {
            this.parent.propertyChange(null);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.currentColor = this.colorWell.getCurrentColor();
        this.firePropertyChange(propertyChangeEvent);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("ColorComponent Self Test");
        ColorComponent colorComponent = new ColorComponent("Red", Color.red);
        frame.setLayout(new FlowLayout());
        frame.add(colorComponent);
        frame.add(new ColorComponent("Blue", Color.blue));
        frame.add(new ColorComponent("Green", Color.green));
        frame.add(new ColorComponent("Yellow", Color.yellow));
        ((Component)frame).setSize(new Dimension(200, 400));
        ((Component)frame).setVisible(true);
    }
}

