/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.customizer;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javachart.beans.customizer.AxisDetails;
import javachart.beans.customizer.OnOffComponent;
import javachart.chart.AxisInterface;
import javachart.chart.Chart;

public class AxisDialog
extends Panel
implements PropertyChangeListener,
ActionListener,
ItemListener {
    protected PropertyChangeListener myParent;
    protected Choice axisSide;
    Button detailButton;
    protected AxisDetails xAxisDetails;
    protected AxisDetails yAxisDetails;
    protected Chart chart;
    protected boolean isYAxis;
    int topBottomOffset;
    protected AxisInterface axis;
    OnOffComponent axisVisible;
    boolean saveOnOff1;
    boolean saveOnOff2;
    boolean saveOnOff3;
    boolean saveOnOff4;
    boolean saveOnOff5;

    public AxisDialog() {
    }

    public AxisDialog(Chart chart, boolean bl) {
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.controlText);
        this.chart = chart;
        this.isYAxis = !bl;
        this.axis = bl ? this.chart.getXAxis() : this.chart.getYAxis();
        this.setLayout(null);
        this.setSize(380, 180);
    }

    public void show() {
        if (this.axisVisible != null) {
            super.show();
            return;
        }
        this.axisVisible = new OnOffComponent("Show Axis", this.axis.getLabelVis());
        this.axisVisible.addPropertyChangeListener(this);
        this.axisVisible.reshape(40, 20, 150, 30);
        this.add(this.axisVisible);
        Label label = new Label("Location");
        this.add(label);
        label.reshape(40, 50, 79, 30);
        this.axisSide = new Choice();
        if (this.axis.getSide() == 0 || this.axis.getSide() == 2) {
            this.axisSide.addItem("Bottom");
            this.axisSide.addItem("Top");
            this.topBottomOffset = 0;
        } else {
            this.axisSide.addItem("Left");
            this.axisSide.addItem("Right");
            this.topBottomOffset = 1;
        }
        this.axisSide.addItemListener(this);
        this.add("North", this.axisSide);
        this.axisSide.reshape(120, 50, 70, 30);
        this.detailButton = new Button("Layout & Scaling Details...");
        this.add("South", this.detailButton);
        this.detailButton.reshape(40, 100, 150, 30);
        this.detailButton.addActionListener(this);
        super.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Container container = this.getParent();
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        if (!this.isYAxis) {
            if (this.xAxisDetails == null) {
                this.xAxisDetails = new AxisDetails(this.chart, true, (Frame)container);
                this.xAxisDetails.addPropertyChangeListener(this);
                ((Component)this.xAxisDetails).setFont(this.getFont());
            }
            this.xAxisDetails.setVisible(true);
            return;
        }
        if (this.yAxisDetails == null) {
            this.yAxisDetails = new AxisDetails(this.chart, false, (Frame)container);
            this.yAxisDetails.addPropertyChangeListener(this);
            ((Component)this.yAxisDetails).setFont(this.getFont());
        }
        this.yAxisDetails.setVisible(true);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent != null && propertyChangeEvent.getSource() == this.axisVisible) {
            if (!this.axisVisible.getValue()) {
                this.detailButton.disable();
                this.saveVals();
                this.axis.setMinTickVis(false);
                this.axis.setMajTickVis(false);
                this.axis.setLineVis(false);
                this.axis.setLabelVis(false);
                this.axis.setGridVis(false);
            } else {
                this.detailButton.enable();
                this.restoreVals();
            }
        }
        if (this.myParent != null) {
            this.myParent.propertyChange(null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myParent = propertyChangeListener;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myParent = null;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isYAxis) {
            this.chart.getYAxis().setSide(this.axisSide.getSelectedIndex() * 2 + this.topBottomOffset);
        } else {
            this.chart.getXAxis().setSide(this.axisSide.getSelectedIndex() * 2 + this.topBottomOffset);
        }
        if (this.myParent != null) {
            this.myParent.propertyChange(null);
        }
    }

    void saveVals() {
        this.saveOnOff1 = this.axis.getGridVis();
        this.saveOnOff2 = this.axis.getMinTickVis();
        this.saveOnOff3 = this.axis.getMajTickVis();
        this.saveOnOff4 = this.axis.getLineVis();
        this.saveOnOff5 = this.axis.getLabelVis();
    }

    void restoreVals() {
        this.axis.setGridVis(this.saveOnOff1);
        this.axis.setMinTickVis(this.saveOnOff2);
        this.axis.setMajTickVis(this.saveOnOff3);
        this.axis.setLineVis(this.saveOnOff4);
        this.axis.setLabelVis(this.saveOnOff5);
    }
}

