/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.chart;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ImageProducer;
import java.net.URL;
import javachart.beans.chart.ChartBean;

public class LineChart
extends ChartBean {
    String[] markerNames = new String[]{"ball_yellow", "ball_blue", "ball_red", "ball_purple", "ball_orange", "ball_pink", "ball_green"};
    int[] markerList;
    transient Image[] markerImages;
    transient MediaTracker imageTracker;

    public LineChart() {
        double[] dArray = new double[3];
        String[] stringArray = new String[3];
        dArray[0] = 1234.0;
        stringArray[0] = "A";
        dArray[1] = 5678.0;
        stringArray[1] = "B";
        dArray[2] = 8910.0;
        stringArray[2] = "C";
        this.chart = new javachart.chart.LineChart("Test Chart");
        this.loadMarkers();
        this.markerList = new int[this.chart.getDatasets().length];
        int n = 0;
        while (n < this.markerList.length) {
            this.markerList[n] = 0;
            ++n;
        }
        this.chart.addDataSet("Apples", dArray, stringArray);
        this.chart.getBackground().setTitleString("Line Chart");
        this.setVisible(true);
    }

    public int getDatasetImageIndex(int n) {
        return this.markerList[n];
    }

    private Image loadImage(String string) {
        try {
            URL uRL = this.getClass().getResource(string);
            return this.createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    void loadMarkers() {
        this.imageTracker = new MediaTracker(this);
        this.markerImages = new Image[this.markerNames.length];
        int n = 0;
        while (n < this.markerNames.length) {
            this.markerImages[n] = this.loadImage(String.valueOf(this.markerNames[n]) + ".gif");
            this.imageTracker.addImage(this.markerImages[n], 0);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        if (this.imageTracker == null) {
            this.loadMarkers();
            int n = 0;
            while (n < this.markerList.length) {
                try {
                    if (this.markerList[n] == 0) {
                        this.chart.getDatasets()[n].getGc().setImage(null);
                    } else {
                        this.chart.getDatasets()[n].getGc().setImage(this.markerImages[this.markerList[n] - 1]);
                    }
                }
                catch (Exception exception) {}
                ++n;
            }
        }
        try {
            this.imageTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        super.paint(graphics);
    }

    public void setDatasetImageIndex(int n, int n2) {
        this.markerList[n] = n2;
        if (n2 == 0) {
            this.chart.getDatasets()[n].getGc().setImage(null);
        } else {
            this.chart.getDatasets()[n].getGc().setImage(this.markerImages[n2 - 1]);
        }
        this.repaint();
    }
}

