/*
 * Decompiled with CFR 0.152.
 */
package javachart.beans.chart;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javachart.beans.data.DataEvent;
import javachart.beans.data.DataFeedListener;
import javachart.chart.Chart;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.RotateString;

public abstract class ChartBean
extends Canvas
implements Serializable,
DataFeedListener,
PropertyChangeListener {
    int width = 200;
    int height = 150;
    protected int modifiers;
    Chart chart;
    private transient Image offScreenImage;
    private transient Dimension offScreenSize;
    private transient Graphics offScreenGraphics;

    private void copyData(Vector vector, Vector vector2) {
        Object object;
        int n = vector.size();
        while (vector2.size() > n) {
            vector2.removeElementAt(n);
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            if ((this.modifiers & 1) != 0) {
                ((Datum)vector2.elementAt(n2)).setY(((Datum)vector.elementAt(n2)).getY());
            }
            if ((this.modifiers & 2) != 0) {
                ((Datum)vector2.elementAt(n2)).setX(((Datum)vector.elementAt(n2)).getX());
            }
            if ((this.modifiers & 0x10) != 0) {
                object = ((Datum)vector.elementAt(n2)).getLabel();
                ((Datum)vector2.elementAt(n2)).setLabel((String)object);
            }
            ++n2;
        }
        if (vector2.size() < n) {
            n2 = vector2.size();
            while (n2 < n) {
                object = (Datum)vector.elementAt(n2);
                Datum datum = new Datum(((Datum)object).getX(), ((Datum)object).getY(), ((Datum)object).getY2(), ((Datum)object).getLabel(), n2, this.chart.getGlobals());
                vector2.addElement(datum);
                ++n2;
            }
        }
    }

    public Chart getChart() {
        return this.chart;
    }

    public int getDatasetImageIndex(int n) {
        return 0;
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public String getTitle() {
        return this.chart.getBackground().getTitleString();
    }

    public void newData(DataEvent dataEvent) {
        this.modifiers = dataEvent.modifiers;
        this.updateDatasets(dataEvent.datasetArray);
        this.repaint();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        this.chart.resize(dimension.width, dimension.height);
        try {
            if (this.offScreenImage == null || dimension.width != this.offScreenSize.width || dimension.height != this.offScreenSize.height) {
                this.offScreenImage = this.createImage(dimension.width, dimension.height);
                this.offScreenSize = dimension;
                this.offScreenGraphics = this.offScreenImage.getGraphics();
            }
            this.chart.setImage(this.offScreenImage);
            if (this.chart.getStringRotator() == null) {
                this.chart.setStringRotator(new RotateString(this));
            }
            if (this.offScreenGraphics != null) {
                this.chart.drawGraph(this.offScreenGraphics);
            }
            graphics.drawImage(this.offScreenImage, 0, 0, null);
        }
        catch (Exception exception) {
            this.chart.drawGraph(graphics);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.repaint();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.width = n3;
        this.height = n4;
        super.reshape(n, n2, this.width, this.height);
    }

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.reshape(n, n2, n3, n4);
    }

    public void setDatasetImageIndex(int n, int n2) {
    }

    public void setPreferredSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setPreferredSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setTitle(String string) {
        this.chart.getBackground().setTitleString(string);
    }

    public final synchronized void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected void updateDatasets(Dataset[] datasetArray) {
        Dataset[] datasetArray2 = this.chart.getDatasets();
        int n = 0;
        while (datasetArray[n] != null) {
            ++n;
        }
        int n2 = n;
        while (n2 < datasetArray2.length) {
            datasetArray2[n2] = null;
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (datasetArray2[n2] == null) {
                datasetArray2[n2] = new Dataset(null, new double[0], n2, this.chart.getGlobals());
                datasetArray2[n2].setName(datasetArray[n2].getName());
                datasetArray2[n2].setData(datasetArray[n2].getData());
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (datasetArray[n2] != null) {
                if ((this.modifiers & 0x20) != 0) {
                    datasetArray2[n2].setName(datasetArray[n2].getName());
                }
                this.copyData(datasetArray[n2].getData(), datasetArray2[n2].getData());
            }
            ++n2;
        }
    }
}

