/*
 * Decompiled with CFR 0.152.
 */
package javachart.applet;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Point;
import javachart.applet.lineApp;
import javachart.chart.DataTransform;
import javachart.chart.Datum;
import javachart.chart.LineChart;
import javachart.chart.RotateString;

public class zoomLine
extends lineApp {
    DataTransform transformer;
    Datum datOne;
    Datum datTwo;
    boolean altClick = false;
    int x1;
    int y1;
    int x2;
    int y2;
    boolean drag = false;
    int x2old;
    int y2old;

    public void getMyOptions() {
        super.getMyOptions();
        if (this.chart.getXAxis().getAutoScale()) {
            this.chart.getXAxis().scale();
            this.chart.getXAxis().setAutoScale(false);
        }
        if (this.chart.getYAxis().getAutoScale()) {
            this.chart.getYAxis().scale();
            this.chart.getYAxis().setAutoScale(false);
        }
        LineChart lineChart = (LineChart)this.chart;
        lineChart.getLine().setClip(true);
    }

    public boolean handleEvent(Event event) {
        Point point;
        if (this.transformer == null) {
            this.transformer = new DataTransform((LineChart)this.chart);
        }
        if (event.id == 501) {
            if (!this.home) {
                this.doVEMessage();
                return true;
            }
            if (event.metaDown()) {
                this.chart.getXAxis().scale();
                this.chart.getYAxis().scale();
                this.transformer.resize();
                this.repaint();
                this.altClick = true;
                return true;
            }
            this.x2 = this.x2old = event.x;
            this.x1 = this.x2old;
            this.y2 = this.y2old = event.y;
            this.y1 = this.y2old;
            point = new Point(event.x, event.y);
            this.datOne = this.transformer.pointToDatum(point);
        }
        if (event.id == 506) {
            if (!this.home) {
                return true;
            }
            if (this.altClick) {
                return true;
            }
            this.drag = true;
            this.x2 = event.x;
            this.y2 = event.y;
            this.repaint();
            this.transformer.resize();
        }
        if (event.id == 502) {
            if (this.altClick) {
                this.altClick = false;
                return true;
            }
            this.drag = false;
            point = new Point(event.x, event.y);
            this.datTwo = this.transformer.pointToDatum(point);
            if (this.datOne.getX() > this.datTwo.getX()) {
                this.chart.getXAxis().setAxisStart(this.datTwo.getX());
                this.chart.getXAxis().setAxisEnd(this.datOne.getX());
            } else {
                this.chart.getXAxis().setAxisStart(this.datOne.getX());
                this.chart.getXAxis().setAxisEnd(this.datTwo.getX());
            }
            if (this.datOne.getY() > this.datTwo.getY()) {
                this.chart.getYAxis().setAxisStart(this.datTwo.getY());
                this.chart.getYAxis().setAxisEnd(this.datOne.getY());
            } else {
                this.chart.getYAxis().setAxisStart(this.datOne.getY());
                this.chart.getYAxis().setAxisEnd(this.datTwo.getY());
            }
            this.repaint();
            this.transformer.resize();
        }
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.gotImages) {
            try {
                this.imageTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        Dimension dimension = this.size();
        this.offScreenImage = this.createImage(dimension.width, dimension.height);
        this.offScreenGraphics = this.offScreenImage.getGraphics();
        this.chart.setImage(this.offScreenImage);
        if (this.chart.getStringRotator() == null) {
            this.chart.setStringRotator(new RotateString(this));
        }
        if (this.offScreenGraphics != null) {
            this.chart.drawGraph(this.offScreenGraphics);
        } else {
            System.out.println("null graphics in app shell");
        }
        this.drawMyStuff(this.offScreenGraphics);
        graphics.drawImage(this.offScreenImage, 0, 0, null);
        if (this.messageFrame != null && this.messageFrame.isShowing()) {
            this.messageFrame.repaint();
        }
    }

    public void update(Graphics graphics) {
        Color color = graphics.getColor();
        if (this.drag) {
            graphics.setXORMode(Color.white);
            graphics.drawLine(this.x1, this.y1, this.x2old, this.y1);
            graphics.drawLine(this.x2old, this.y1, this.x2old, this.y2old);
            graphics.drawLine(this.x2old, this.y2old, this.x1, this.y2old);
            graphics.drawLine(this.x1, this.y2old, this.x1, this.y1);
            graphics.drawLine(this.x1, this.y1, this.x2, this.y1);
            graphics.drawLine(this.x2, this.y1, this.x2, this.y2);
            graphics.drawLine(this.x2, this.y2, this.x1, this.y2);
            graphics.drawLine(this.x1, this.y2, this.x1, this.y1);
            graphics.setColor(color);
            this.x2old = this.x2;
            this.y2old = this.y2;
            return;
        }
        this.paint(graphics);
    }
}

