/*
 * Decompiled with CFR 0.152.
 */
package javachart.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javachart.applet.MessageFrame;
import javachart.chart.AxisInterface;
import javachart.chart.ChartInterface;
import javachart.chart.Dataset;
import javachart.chart.Datum;
import javachart.chart.Gc;
import javachart.chart.RotateString;
import javachart.chart.Transform;

public abstract class ChartAppShell
extends Applet
implements Runnable {
    public ChartInterface chart;
    double[] yArr = new double[]{0.0};
    boolean gotDatasets = false;
    URL myUrl;
    Thread getThread;
    int networkInterval = -1;
    MediaTracker imageTracker;
    boolean gotImages;
    char[] buff = new char[8192];
    String delimiter;
    MessageFrame messageFrame;
    Transform logoTransform;
    boolean home = false;
    boolean useDwellLabel = true;
    int dwellLabelPrecision = 2;
    int dwellLabelFormat = 1;
    boolean dwellUseXValue = true;
    boolean dwellUseYValue = true;
    boolean dwellUseString = false;
    String dwellXString;
    String dwellYString;
    private int secondsSoFar = 0;
    protected Image offScreenImage;
    Dimension offScreenSize;
    Graphics offScreenGraphics;
    Vector displayList = new Vector();
    boolean showDataPopup = false;
    boolean dwellLabelVisible = false;
    int popupX = 0;
    int popupY = 0;
    String dwellLabelXString;
    String dwellLabelYString;
    String dwellLabelLabelString;

    public boolean closeURL(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("can't close URL");
            return false;
        }
        return true;
    }

    protected void displayInfo(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof Datum) {
                this.dwellLabelXString = this.getDwellLabelXString((Datum)e);
                this.dwellLabelYString = this.getDwellLabelYString((Datum)e);
                this.dwellLabelLabelString = this.getDwellLabelLabelString((Datum)e);
                this.showDataPopup = true;
                this.repaint();
                return;
            }
            ++n;
        }
    }

    protected void doDwellLabel() {
        if (this.dwellLabelVisible || !this.useDwellLabel) {
            return;
        }
        Point point = new Point(this.popupX, this.popupY);
        this.displayList.removeAllElements();
        if (this.chart.getDisplayList().contains(point, this.displayList)) {
            this.displayInfo(this.displayList);
        }
    }

    void doVEMessage() {
        if (this.messageFrame == null) {
            this.messageFrame = new MessageFrame();
            this.messageFrame.setAppletContext(this.getAppletContext());
        }
        this.messageFrame.show();
    }

    protected void drawDataPopup(Graphics graphics) {
        int n;
        int n2;
        int n3;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = 0;
        StringTokenizer stringTokenizer = null;
        int n5 = 0;
        if (this.dwellLabelLabelString != null && this.dwellUseString) {
            if (this.dwellLabelLabelString.indexOf("|") == -1) {
                n4 = fontMetrics.stringWidth(this.dwellLabelLabelString) + 6;
                n5 = 1;
            } else {
                n3 = 0;
                n2 = 0;
                stringTokenizer = new StringTokenizer(this.dwellLabelLabelString, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    n2 = fontMetrics.stringWidth(stringTokenizer.nextToken());
                    if (n2 > n3) {
                        n3 = n2;
                    }
                    ++n5;
                }
                n4 = n3 + 6;
            }
        }
        if ((n2 = this.dwellUseYValue ? fontMetrics.stringWidth(this.dwellLabelYString) + 6 : 0) > (n = n4 > (n3 = this.dwellUseXValue ? fontMetrics.stringWidth(this.dwellLabelXString) + 6 : 0) ? n4 : n3)) {
            n = n2;
        }
        int n6 = fontMetrics.getHeight() + 4;
        int n7 = 4;
        if (this.dwellUseXValue) {
            n7 += n6;
        }
        if (this.dwellUseYValue) {
            n7 += n6;
        }
        if (this.dwellUseString) {
            n7 += n5 * n6;
        }
        if (this.popupX + n > this.size().width) {
            this.popupX = this.size().width - n - 10;
        }
        this.popupY -= n7;
        if (this.popupY < 0) {
            this.popupY = 0;
        }
        graphics.setColor(Color.white);
        graphics.fillRect(this.popupX, this.popupY, n, n7);
        graphics.setColor(Color.black);
        graphics.drawRect(this.popupX, this.popupY, n, n7);
        int n8 = n6;
        if (this.dwellUseString && this.dwellLabelLabelString != null) {
            if (stringTokenizer == null) {
                graphics.drawString(this.dwellLabelLabelString, this.popupX + 3, this.popupY + n8);
                n8 += n6;
            } else {
                StringTokenizer stringTokenizer2 = new StringTokenizer(this.dwellLabelLabelString, "|");
                while (stringTokenizer2.hasMoreTokens()) {
                    graphics.drawString(stringTokenizer2.nextToken(), this.popupX + 3, this.popupY + n8);
                    n8 += n6;
                }
            }
        }
        if (this.dwellUseXValue) {
            graphics.drawString(this.dwellLabelXString, this.popupX + 3, this.popupY + n8);
            n8 += n6;
        }
        if (this.dwellUseYValue) {
            graphics.drawString(this.dwellLabelYString, this.popupX + 3, this.popupY + n8);
        }
        this.popupY += n7;
    }

    public void drawMyStuff(Graphics graphics) {
        if (this.home) {
            return;
        }
        graphics.setColor(Color.blue);
        graphics.fillRect(this.size().width - 20, this.size().height - 20, 5, 5);
    }

    protected void getAxisOptions() {
        this.parseAxOptions("yAxis", this.chart.getYAxis());
        this.parseAxOptions("xAxis", this.chart.getXAxis());
        String string = this.getParameter("xAxisLabels");
        if (string != null) {
            this.getXAxisLabels(string);
        }
    }

    protected void getAxisOptions(AxisInterface axisInterface, String string) {
        if (string.indexOf("logScaling") != -1) {
            axisInterface.setLogScaling(true);
        }
        if (string.indexOf("autoScale") != -1) {
            axisInterface.setAutoScale(true);
        }
        if (string.indexOf("noAutoScale") != -1) {
            axisInterface.setAutoScale(false);
        }
        if (string.indexOf("lineOn") != -1) {
            axisInterface.setLineVis(true);
        }
        if (string.indexOf("lineOff") != -1) {
            axisInterface.setLineVis(false);
        }
        if (string.indexOf("labelsOn") != -1) {
            axisInterface.setLabelVis(true);
        }
        if (string.indexOf("labelsOff") != -1) {
            axisInterface.setLabelVis(false);
        }
        if (string.indexOf("gridOn") != -1) {
            axisInterface.setGridVis(true);
        }
        if (string.indexOf("gridOff") != -1) {
            axisInterface.setGridVis(false);
        }
        if (string.indexOf("tickOn") != -1) {
            axisInterface.setMajTickVis(true);
        }
        if (string.indexOf("tickOff") != -1) {
            axisInterface.setMajTickVis(false);
        }
        if (string.indexOf("minTickOn") != -1) {
            axisInterface.setMinTickVis(true);
        }
        if (string.indexOf("minTickOff") != -1) {
            axisInterface.setMinTickVis(false);
        }
        if (string.indexOf("rightAxis") != -1) {
            axisInterface.setSide(3);
        }
        if (string.indexOf("leftAxis") != -1) {
            axisInterface.setSide(1);
        }
        if (string.indexOf("topAxis") != -1) {
            axisInterface.setSide(2);
        }
        if (string.indexOf("bottomAxis") != -1) {
            axisInterface.setSide(0);
        }
        if (string.indexOf("rotateTitle") != -1) {
            axisInterface.setTitleRotated(true);
        }
    }

    protected Color getColor(String string) {
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (string.equalsIgnoreCase("transparent")) {
            return Gc.TRANSPARENT;
        }
        try {
            return new Color(Integer.parseInt(string, 16));
        }
        catch (NumberFormatException numberFormatException) {
            return Color.black;
        }
    }

    public boolean getDataset(int n) {
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        String string = this.getParameter("dataset" + n + "xValues");
        if (string != null) {
            dArray = this.getVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "dateValues")) != null) {
            dArray = this.getDateVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "yValues")) != null) {
            dArray2 = this.getVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "y2Values")) != null) {
            dArray3 = this.getVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "y3Values")) != null) {
            dArray4 = this.getVals(string);
        }
        if ((string = this.getParameter("dataset" + n + "xyValues")) != null) {
            System.out.println("xyVals not supported yet");
        }
        return this.getDatasetParameters(n, dArray, dArray2, dArray3, dArray4);
    }

    public boolean getDatasetParameters(int n, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        String[] stringArray = null;
        String string = this.getParameter("dataset" + n + "Name");
        String string2 = string != null ? new String(string) : new String("dataset" + n);
        string = this.getParameter("dataset" + n + "Labels");
        if (string != null) {
            stringArray = this.getLabels(string);
        }
        if ((string = this.getParameter("dataset" + n + "URLLabels")) != null) {
            InputStream inputStream = this.openURL(string);
            if (inputStream != null) {
                string = this.getLineFromURL(inputStream);
                stringArray = this.getLabels(string);
            }
            this.closeURL(inputStream);
        }
        if (dArray4 != null && dArray3 != null && dArray2 != null) {
            this.chart.addDataSet(string2, dArray, dArray2, dArray3, dArray4);
        } else if (dArray3 != null && dArray2 != null && stringArray != null) {
            if (dArray == null) {
                this.chart.addDataSet(string2, dArray2, dArray3, stringArray);
            } else {
                this.chart.addDataSet(string2, dArray, dArray2, stringArray);
            }
        } else if (dArray3 != null && dArray2 != null && stringArray == null) {
            if (dArray == null) {
                this.chart.addDataSet(string2, dArray2, dArray3);
            } else {
                this.chart.addDataSet(string2, dArray, dArray2);
            }
        } else if (dArray2 != null) {
            if (stringArray != null) {
                if (dArray == null) {
                    this.chart.addDataSet(string2, dArray2, stringArray);
                } else {
                    this.chart.addDataSet(string2, dArray, dArray2, stringArray);
                }
            } else if (dArray == null) {
                this.chart.addDataSet(string2, dArray2);
            } else {
                this.chart.addDataSet(string2, dArray, dArray2);
            }
        }
        if (dArray2 == null) {
            return false;
        }
        string = this.getParameter("dataset" + n + "Color");
        if (string != null) {
            this.chart.getDatasets()[n].getGc().setFillColor(this.getColor(string));
            this.chart.getDatasets()[n].getGc().setLineColor(this.getColor(string));
        }
        if ((string = this.getParameter("dataset" + n + "Colors")) != null) {
            stringArray = this.getLabels(string);
            Dataset dataset = this.chart.getDatasets()[n];
            int n2 = 0;
            while (n2 < stringArray.length) {
                dataset.getDataElementAt(n2).getGc().setFillColor(this.getColor(stringArray[n2]));
                ++n2;
            }
        }
        if ((string = this.getParameter("dataset" + n + "LineWidth")) != null) {
            this.chart.getDatasets()[n].getGc().setLineWidth(Integer.parseInt(string));
        }
        if ((string = this.getParameter("dataset" + n + "LabelFont")) != null) {
            this.chart.getDatasets()[n].setLabelFont(this.getFont(string));
        }
        if ((string = this.getParameter("dataset" + n + "LabelColor")) != null) {
            this.chart.getDatasets()[n].setLabelColor(this.getColor(string));
        }
        if ((string = this.getParameter("dataset" + n + "Image")) != null) {
            this.chart.getDatasets()[n].getGc().setImage(this.makeURLImage(string));
        }
        return true;
    }

    protected void getDatasets() {
        int n = 0;
        if (this.gotDatasets) {
            return;
        }
        this.gotDatasets = true;
        while (this.getDataset(n)) {
            ++n;
        }
        if (this.chart.getNumDatasets() < 1) {
            this.chart.addDataSet("dummy", this.yArr);
        }
    }

    protected double[] getDateVals(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.delimiter);
        double[] dArray = new double[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                dArray[n] = Date.parse(stringTokenizer.nextToken().trim());
            }
            catch (Exception exception) {
                dArray[n] = Double.NEGATIVE_INFINITY;
            }
            ++n;
        }
        return dArray;
    }

    protected String getDwellLabelLabelString(Datum datum) {
        String string = datum.getLabel();
        return string;
    }

    protected String getDwellLabelXString(Datum datum) {
        int n;
        String string = Double.toString(datum.getX());
        if (this.dwellLabelFormat != 0) {
            n = string.indexOf("e");
            if (n == -1) {
                n = string.indexOf("E");
            }
            if (n != -1) {
                string = Gc.nonSciNumberStr(string, n);
            }
        }
        n = this.dwellXString.indexOf("#");
        return String.valueOf(this.dwellXString.substring(0, n)) + Gc.formattedLabel(string, this.dwellLabelFormat, this.dwellLabelPrecision) + this.dwellXString.substring(n + 1);
    }

    protected String getDwellLabelYString(Datum datum) {
        int n;
        String string = Double.toString(datum.getY());
        if (this.dwellLabelFormat != 0) {
            n = string.indexOf("e");
            if (n == -1) {
                n = string.indexOf("E");
            }
            if (n != -1) {
                string = Gc.nonSciNumberStr(string, n);
            }
        }
        n = this.dwellYString.indexOf("#");
        return String.valueOf(this.dwellYString.substring(0, n)) + Gc.formattedLabel(string, this.dwellLabelFormat, this.dwellLabelPrecision) + this.dwellYString.substring(n + 1);
    }

    protected Font getFont(String string) {
        int n = string.indexOf(this.delimiter, 0);
        String string2 = string.substring(0, n);
        string2 = string.substring(0, n);
        int n2 = string.indexOf(this.delimiter, n + 1);
        int n3 = Integer.valueOf(string.substring(n + 1, n2));
        int n4 = Integer.valueOf(string.substring(n2 + 1));
        Font font = new Font(string2, n4, n3);
        if (font != null) {
            return font;
        }
        return new Font("TimesRoman", 0, 12);
    }

    protected String[] getLabels(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.delimiter);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                stringArray[n] = stringTokenizer.nextToken().trim();
            }
            catch (Exception exception) {
                stringArray[n] = " ";
            }
            ++n;
        }
        return stringArray;
    }

    public String getLineFromURL(InputStream inputStream) {
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer(256);
        while (true) {
            try {
                n = inputStream.read();
            }
            catch (IOException iOException) {
                System.out.println("bad i/o operation");
                return null;
            }
            if (n == -1) {
                if (stringBuffer.length() == 0) {
                    return null;
                }
                return stringBuffer.toString();
            }
            if (n == 10 || n == 13) {
                if (stringBuffer.length() <= 0) continue;
                return stringBuffer.toString();
            }
            stringBuffer.append((char)n);
        }
    }

    public void getMyDatasets(String string) {
    }

    public void getMyOptions() {
        this.getAxisOptions();
    }

    protected void getOptions() {
        String string;
        if (this.getCodeBase().getHost().equals("www.ve.com")) {
            this.home = true;
        } else {
            string = this.getParameter("CopyrightNotification");
            if (string != null) {
                if (string.equals("KavaChart is a copyrighted work, and subject to full legal protection")) {
                    this.home = true;
                } else if (string.equals("JavaChart is a copyrighted work, and subject to full legal protection")) {
                    this.home = true;
                }
            }
        }
        string = this.getParameter("delimiter");
        this.delimiter = string != null ? new String(string) : new String(",");
        string = this.getParameter("networkInterval");
        if (string != null) {
            this.networkInterval = Integer.parseInt(string);
        }
        if ((string = this.getParameter("dwellLabelsOn")) != null && string.equalsIgnoreCase("false")) {
            this.useDwellLabel = false;
        }
        if ((string = this.getParameter("dwellUseLabelString")) != null && string.equalsIgnoreCase("true")) {
            this.dwellUseString = true;
        }
        if ((string = this.getParameter("dwellUseXValue")) != null && string.equalsIgnoreCase("false")) {
            this.dwellUseXValue = false;
        }
        if ((string = this.getParameter("dwellUseYValue")) != null && string.equalsIgnoreCase("false")) {
            this.dwellUseYValue = false;
        }
        this.dwellXString = (string = this.getParameter("dwellXString")) != null ? string : "X: #";
        string = this.getParameter("dwellYString");
        this.dwellYString = string != null ? string : "Y: #";
        string = this.getParameter("dwellLabelPrecision");
        if (string != null) {
            this.dwellLabelPrecision = Integer.parseInt(string);
        }
        if ((string = this.getParameter("dwellLabelFormat")) != null) {
            this.dwellLabelFormat = Integer.parseInt(string);
        }
        if ((string = this.getParameter("URLDataBlock")) != null) {
            this.getURLDataBlock(string);
        }
        if ((string = this.getParameter("URLXYDataRows")) != null) {
            this.getURLXYDataRows(string);
        }
        if ((string = this.getParameter("URLXYDataColumns")) != null) {
            this.getURLXYDataColumns(string);
        }
        if ((string = this.getParameter("dataset0xURL")) != null) {
            this.getURLDatasets();
        }
        if ((string = this.getParameter("dataset0yURL")) != null) {
            this.getURLDatasets();
        }
        if ((string = this.getParameter("dataset0xyURL")) != null) {
            this.getURLDatasets();
        }
        if ((string = this.getParameter("dataset0xValues")) != null) {
            this.getDatasets();
        }
        if ((string = this.getParameter("dataset0yValues")) != null) {
            this.getDatasets();
        }
        if ((string = this.getParameter("dataset0xyValues")) != null) {
            this.getDatasets();
        }
        if ((string = this.getParameter("customDatasetHandler")) != null) {
            this.getMyDatasets(string);
        }
        if ((string = this.getParameter("legendOn")) != null) {
            this.chart.setLegendVisible(true);
        }
        if ((string = this.getParameter("legendOff")) != null) {
            this.chart.setLegendVisible(false);
        }
        if ((string = this.getParameter("legendColor")) != null) {
            this.chart.getLegend().getBackgroundGc().setFillColor(this.getColor(string));
            this.chart.getLegend().getBackgroundGc().setLineColor(this.getColor(string));
        }
        if ((string = this.getParameter("legendVertical")) != null) {
            this.chart.getLegend().setVerticalLayout(true);
        }
        if ((string = this.getParameter("legendHorizontal")) != null) {
            this.chart.getLegend().setVerticalLayout(false);
        }
        if ((string = this.getParameter("legendLabelColor")) != null) {
            this.chart.getLegend().setLabelColor(this.getColor(string));
        }
        if ((string = this.getParameter("legendLabelFont")) != null) {
            this.chart.getLegend().setLabelFont(this.getFont(string));
        }
        if ((string = this.getParameter("legendllX")) != null) {
            this.chart.getLegend().setLlX(Double.valueOf(string));
        }
        if ((string = this.getParameter("legendllY")) != null) {
            this.chart.getLegend().setLlY(Double.valueOf(string));
        }
        if ((string = this.getParameter("iconWidth")) != null) {
            this.chart.getLegend().setIconWidth(Double.valueOf(string.trim()));
        }
        if ((string = this.getParameter("iconHeight")) != null) {
            this.chart.getLegend().setIconHeight(Double.valueOf(string.trim()));
        }
        if ((string = this.getParameter("iconGap")) != null) {
            this.chart.getLegend().setIconGap(Double.valueOf(string.trim()));
        }
        if ((string = this.getParameter("plotAreaTop")) != null) {
            this.chart.getPlotarea().setUrY(Double.valueOf(string));
        }
        if ((string = this.getParameter("plotAreaBottom")) != null) {
            this.chart.getPlotarea().setLlY(Double.valueOf(string));
        }
        if ((string = this.getParameter("plotAreaLeft")) != null) {
            this.chart.getPlotarea().setLlX(Double.valueOf(string));
        }
        if ((string = this.getParameter("plotAreaRight")) != null) {
            this.chart.getPlotarea().setUrX(Double.valueOf(string));
        }
        if ((string = this.getParameter("plotAreaColor")) != null) {
            this.chart.getPlotarea().getGc().setFillColor(this.getColor(string));
        }
        if ((string = this.getParameter("backgroundColor")) != null) {
            this.chart.getBackground().getGc().setFillColor(this.getColor(string));
        }
        if ((string = this.getParameter("titleColor")) != null) {
            this.chart.getBackground().setTitleColor(this.getColor(string));
        }
        if ((string = this.getParameter("titleFont")) != null) {
            this.chart.getBackground().setTitleFont(this.getFont(string));
        }
        if ((string = this.getParameter("titleString")) != null) {
            this.chart.getBackground().setTitleString(string);
        }
        if ((string = this.getParameter("3D")) != null) {
            this.chart.setThreeD(true);
        }
        if ((string = this.getParameter("2D")) != null) {
            this.chart.setThreeD(false);
        }
        if ((string = this.getParameter("XDepth")) != null) {
            this.chart.setXOffset(Integer.parseInt(string));
        }
        if ((string = this.getParameter("YDepth")) != null) {
            this.chart.setYOffset(Integer.parseInt(string));
        }
    }

    protected boolean getURLDataBlock(String string) {
        String string2;
        InputStream inputStream;
        double[] dArray = null;
        double[] dArray2 = null;
        int n = 0;
        if (string != null) {
            inputStream = this.openURL(string);
            if (inputStream == null) {
                return false;
            }
        } else {
            return false;
        }
        this.gotDatasets = true;
        while ((string2 = this.getLineFromURL(inputStream)) != null) {
            dArray2 = this.getVals(string2);
            this.getDatasetParameters(n, dArray, dArray2, null, null);
            ++n;
        }
        this.closeURL(inputStream);
        return true;
    }

    protected boolean getURLDataset(int n) {
        int n2;
        String string;
        InputStream inputStream;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        String string2 = this.getParameter("dataset" + n + "xURL");
        if (string2 != null && (inputStream = this.openURL(string2)) != null) {
            string = this.getLineFromURL(inputStream);
            dArray = this.getVals(string);
            this.closeURL(inputStream);
        }
        if ((string2 = this.getParameter("dataset" + n + "yURL")) != null) {
            if (string2.equalsIgnoreCase("fake")) {
                dArray2 = new double[5];
                n2 = 0;
                while (n2 < 5) {
                    dArray2[n2] = 10.0 * Math.random();
                    ++n2;
                }
            } else {
                inputStream = this.openURL(string2);
                if (inputStream != null) {
                    string = this.getLineFromURL(inputStream);
                    dArray2 = this.getVals(string);
                    this.closeURL(inputStream);
                }
            }
        }
        if ((string2 = this.getParameter("dataset" + n + "y2URL")) != null) {
            if (string2.equalsIgnoreCase("fake")) {
                dArray2 = new double[5];
                n2 = 0;
                while (n2 < 5) {
                    dArray3[n2] = 10.0 * Math.random();
                    ++n2;
                }
            } else {
                inputStream = this.openURL(string2);
                if (inputStream != null) {
                    string = this.getLineFromURL(inputStream);
                    dArray3 = this.getVals(string);
                    this.closeURL(inputStream);
                }
            }
        }
        if ((string2 = this.getParameter("dataset" + n + "xyURL")) != null) {
            System.out.println("xyVals not supported yet");
        }
        return this.getDatasetParameters(n, dArray, dArray2, dArray3, null);
    }

    protected void getURLDatasets() {
        int n = 0;
        if (this.gotDatasets) {
            return;
        }
        this.gotDatasets = true;
        while (this.getURLDataset(n)) {
            ++n;
        }
        if (this.chart.getNumDatasets() < 1) {
            this.chart.addDataSet("dummy", this.yArr);
        }
    }

    protected boolean getURLXYDataColumns(String string) {
        InputStream inputStream;
        double[] dArray = null;
        double[] dArray2 = null;
        if (string != null) {
            inputStream = this.openURL(string);
            if (inputStream == null) {
                return false;
            }
        } else {
            return false;
        }
        this.gotDatasets = true;
        String string2 = this.getLineFromURL(inputStream);
        int n = Integer.parseInt(string2.trim());
        double[][] dArray3 = new double[n][];
        dArray = new double[n];
        dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            string2 = this.getLineFromURL(inputStream);
            dArray3[n2] = this.getVals(string2);
            ++n2;
        }
        this.closeURL(inputStream);
        int n3 = dArray3[0].length;
        n2 = 0;
        while (n2 < n3) {
            int n4 = 0;
            while (n4 < n) {
                try {
                    dArray[n4] = dArray3[n4][n2];
                    dArray2[n4] = dArray3[n4][n2 + 1];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println("need same number of x & y observations in column " + n2 + " and row " + n4);
                    return false;
                }
                ++n4;
            }
            this.getDatasetParameters(n2 / 2, dArray, dArray2, null, null);
            n2 += 2;
        }
        return true;
    }

    protected boolean getURLXYDataRows(String string) {
        String string2;
        InputStream inputStream;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        int n = 0;
        if (string != null) {
            inputStream = this.openURL(string);
            if (inputStream == null) {
                return false;
            }
        } else {
            return false;
        }
        this.gotDatasets = true;
        while ((string2 = this.getLineFromURL(inputStream)) != null) {
            dArray = this.getVals(string2);
            dArray2 = new double[dArray.length / 2];
            dArray3 = new double[dArray2.length];
            int n2 = 0;
            int n3 = 0;
            while (n3 < dArray.length) {
                try {
                    dArray2[n2] = dArray[n3];
                    dArray3[n2] = dArray[++n3];
                    ++n2;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println("need same number of x & y observations in dataset " + n);
                    return false;
                }
                ++n3;
            }
            this.getDatasetParameters(n, dArray2, dArray3, null, null);
            ++n;
        }
        this.closeURL(inputStream);
        return true;
    }

    protected double[] getVals(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, this.delimiter);
        double[] dArray = new double[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                dArray[n] = Double.valueOf(stringTokenizer.nextToken().trim());
            }
            catch (Exception exception) {
                dArray[n] = Double.NEGATIVE_INFINITY;
            }
            ++n;
        }
        return dArray;
    }

    protected void getXAxisLabels(String string) {
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            n = string.indexOf(this.delimiter, n + 1);
            ++n2;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        n = 0;
        while (n < n2 - 1) {
            int n4 = string.indexOf(this.delimiter, n3);
            stringArray[n] = string.substring(n3, n4);
            n3 = n4 + 1;
            ++n;
        }
        stringArray[n] = string.substring(n3);
        this.chart.getXAxis().addLabels(stringArray);
    }

    public boolean handleEvent(Event event) {
        if (event.id == 501) {
            this.mouseDown(event, 0, 0);
            return true;
        }
        if (this.showDataPopup) {
            this.showDataPopup = false;
            this.repaint();
            return true;
        }
        this.popupX = event.x;
        this.popupY = event.y;
        return false;
    }

    protected Image makeURLImage(String string) {
        Image image = this.getImage(this.getCodeBase(), string);
        if (!this.gotImages) {
            this.imageTracker = new MediaTracker(this);
            this.gotImages = true;
        }
        this.imageTracker.addImage(image, 0);
        return image;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (!this.home) {
            this.doVEMessage();
        }
        return true;
    }

    public InputStream openURL(String string) {
        InputStream inputStream;
        try {
            this.myUrl = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                String string2 = this.getDocumentBase().toExternalForm();
                String string3 = string2.substring(0, string2.lastIndexOf("/") + 1);
                this.myUrl = new URL(String.valueOf(string3) + string);
            }
            catch (MalformedURLException malformedURLException2) {
                System.out.println("couldn't open " + string);
                return null;
            }
        }
        try {
            URLConnection uRLConnection = this.myUrl.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            System.out.println("can't open stream " + string);
            return null;
        }
        return inputStream;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        if (this.gotImages) {
            try {
                this.imageTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        if (this.offScreenImage == null || dimension.width != this.offScreenSize.width || dimension.height != this.offScreenSize.height) {
            this.offScreenImage = this.createImage(dimension.width, dimension.height);
            this.offScreenSize = dimension;
            this.offScreenGraphics = this.offScreenImage.getGraphics();
        }
        this.chart.setImage(this.offScreenImage);
        if (this.chart.getStringRotator() == null) {
            this.chart.setStringRotator(new RotateString(this));
        }
        if (this.offScreenGraphics != null) {
            this.chart.drawGraph(this.offScreenGraphics);
        } else {
            System.out.println("null graphics in app shell");
        }
        this.drawMyStuff(this.offScreenGraphics);
        graphics.drawImage(this.offScreenImage, 0, 0, null);
        if (this.showDataPopup) {
            this.drawDataPopup(graphics);
            this.dwellLabelVisible = true;
        } else {
            this.dwellLabelVisible = false;
        }
        if (this.messageFrame != null && this.messageFrame.isShowing()) {
            this.messageFrame.repaint();
        }
    }

    private void parseAxOptions(String string, AxisInterface axisInterface) {
        String string2 = this.getParameter(String.valueOf(string) + "Options");
        if (string2 != null) {
            this.getAxisOptions(axisInterface, string2);
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "Start")) != null) {
            axisInterface.setAxisStart(Double.valueOf(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "End")) != null) {
            axisInterface.setAxisEnd(Double.valueOf(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelFont")) != null) {
            axisInterface.setLabelFont(this.getFont(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelAngle")) != null) {
            axisInterface.setLabelAngle(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelPrecision")) != null) {
            axisInterface.setLabelPrecision(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelFormat")) != null) {
            axisInterface.setLabelFormat(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "Color")) != null) {
            axisInterface.setLabelColor(this.getColor(string2));
            axisInterface.getLineGc().setLineColor(this.getColor(string2));
            axisInterface.getGridGc().setLineColor(this.getColor(string2));
            axisInterface.getTickGc().setLineColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelColor")) != null) {
            axisInterface.setLabelColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LineColor")) != null) {
            axisInterface.getLineGc().setLineColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "GridColor")) != null) {
            axisInterface.getGridGc().setLineColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TickColor")) != null) {
            axisInterface.getTickGc().setLineColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TickLength")) != null) {
            axisInterface.setMajTickLength(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "MinTickLength")) != null) {
            axisInterface.setMinTickLength(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TickCount")) != null) {
            axisInterface.setNumMajTicks(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "MinTickCount")) != null) {
            axisInterface.setNumMinTicks(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "GridCount")) != null) {
            axisInterface.setNumGrids(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "LabelCount")) != null) {
            axisInterface.setNumLabels(Integer.parseInt(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "Title")) != null) {
            axisInterface.setTitleString(string2);
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TitleColor")) != null) {
            axisInterface.setTitleColor(this.getColor(string2));
        }
        if ((string2 = this.getParameter(String.valueOf(string) + "TitleFont")) != null) {
            axisInterface.setTitleFont(this.getFont(string2));
        }
    }

    public void replaceDataLabels(int n, String[] stringArray) {
        Vector vector = this.chart.getDatasets()[n].getData();
        int n2 = 0;
        while (n2 < vector.size()) {
            Datum datum = (Datum)vector.elementAt(n2);
            try {
                datum.setLabel(stringArray[n2]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            ++n2;
        }
    }

    protected void reReadURLDatasets() {
        int n;
        int n2;
        int n3;
        double[] dArray;
        Object object;
        double[] dArray2;
        String string;
        int n4;
        InputStream inputStream;
        String string2 = this.getParameter("URLDataBlock");
        if (string2 != null) {
            inputStream = this.openURL(string2);
            if (inputStream != null) {
                n4 = 0;
                while (n4 < this.chart.getNumDatasets()) {
                    string = this.getLineFromURL(inputStream);
                    dArray2 = this.getVals(string);
                    this.chart.getDatasets()[n4].replaceYData(dArray2);
                    ++n4;
                }
            }
            this.closeURL(inputStream);
        }
        if ((string2 = this.getParameter("URLXYDataRows")) != null) {
            inputStream = this.openURL(string2);
            if (inputStream != null) {
                n4 = 0;
                while (n4 < this.chart.getNumDatasets()) {
                    string = this.getLineFromURL(inputStream);
                    object = this.getVals(string);
                    dArray = new double[((double[])object).length / 2];
                    dArray2 = new double[dArray.length];
                    n3 = 0;
                    n2 = 0;
                    while (n2 < ((double[])object).length) {
                        try {
                            dArray[n3] = object[n2];
                            dArray2[n3] = object[++n2];
                            ++n3;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            System.out.println("need same number of x & y observations in dataset " + n4);
                            return;
                        }
                        ++n2;
                    }
                    this.chart.getDatasets()[n4].replaceYData(dArray2);
                    this.chart.getDatasets()[n4].replaceXData(dArray);
                    ++n4;
                }
            }
            this.closeURL(inputStream);
        }
        if ((string2 = this.getParameter("URLXYDataColumns")) != null) {
            inputStream = this.openURL(string2);
            if (inputStream != null) {
                string = this.getLineFromURL(inputStream);
                n2 = Integer.parseInt(string.trim());
                n3 = this.chart.getNumDatasets() * 2;
                object = new double[n2][];
                dArray = new double[n2];
                dArray2 = new double[n2];
                n4 = 0;
                while (n4 < n2) {
                    string = this.getLineFromURL(inputStream);
                    object[n4] = (double)this.getVals(string);
                    ++n4;
                }
            } else {
                return;
            }
            this.closeURL(inputStream);
            n4 = 0;
            while (n4 < n3) {
                n = 0;
                while (n < n2) {
                    try {
                        dArray[n] = object[n][n4];
                        dArray2[n] = object[n][n4 + 1];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.out.println("need same number of x & y observations in column " + n4 + " and row " + n);
                        return;
                    }
                    ++n;
                }
                this.chart.getDatasets()[n4 / 2].replaceYData(dArray2);
                this.chart.getDatasets()[n4 / 2].replaceXData(dArray);
                n4 += 2;
            }
        }
        n4 = 0;
        while (n4 < this.chart.getNumDatasets()) {
            string2 = this.getParameter("dataset" + n4 + "xURL");
            if (string2 != null) {
                inputStream = this.openURL(string2);
                if (inputStream != null) {
                    string = this.getLineFromURL(inputStream);
                    dArray = this.getVals(string);
                    this.chart.getDatasets()[n4].replaceXData(dArray);
                }
                this.closeURL(inputStream);
            }
            if ((string2 = this.getParameter("dataset" + n4 + "yURL")) != null) {
                if (string2.equalsIgnoreCase("fake")) {
                    dArray2 = new double[5];
                    n = 0;
                    while (n < 5) {
                        dArray2[n] = 10.0 * Math.random();
                        ++n;
                    }
                    this.chart.getDatasets()[n4].replaceYData(dArray2);
                } else {
                    inputStream = this.openURL(string2);
                    if (inputStream != null) {
                        string = this.getLineFromURL(inputStream);
                        dArray2 = this.getVals(string);
                        this.chart.getDatasets()[n4].replaceYData(dArray2);
                        this.closeURL(inputStream);
                    }
                }
            }
            if ((string2 = this.getParameter("dataset" + n4 + "URLLabels")) != null && (inputStream = this.openURL(string2)) != null) {
                string = this.getLineFromURL(inputStream);
                String[] stringArray = this.getLabels(string);
                this.replaceDataLabels(n4, stringArray);
                this.closeURL(inputStream);
            }
            ++n4;
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(1000L);
                if (this.networkInterval != -1 && this.secondsSoFar > this.networkInterval) {
                    this.secondsSoFar = 0;
                    this.reReadURLDatasets();
                    this.showDataPopup = false;
                    this.repaint();
                    continue;
                }
                this.doDwellLabel();
                ++this.secondsSoFar;
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void start() {
        if (this.useDwellLabel) {
            this.chart.setUseDisplayList(true);
        } else {
            this.chart.setUseDisplayList(false);
        }
        if (this.getThread == null) {
            this.getThread = new Thread(this);
            this.getThread.start();
        }
    }

    public void stop() {
        if (this.getThread != null) {
            this.getThread.stop();
            this.getThread = null;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

