/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.ViewportLayout;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.Serializable;

public class JViewport
extends JComponent
implements Accessible {
    protected boolean isViewSizeSet = false;
    protected Point lastPaintPosition;
    protected boolean backingStore = false;
    protected transient Image backingStoreImage;
    protected boolean scrollUnderway = false;
    private ComponentListener viewListener;
    private transient ChangeEvent changeEvent;
    static /* synthetic */ Class class$com$sun$java$swing$event$ChangeListener;

    public JViewport() {
        this.setLayout(this.createLayoutManager());
    }

    protected void addImpl(Component component, Object object, int n) {
        this.setView(component);
    }

    public void remove(Component component) {
        component.removeComponentListener(this.viewListener);
        super.remove(component);
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Component component = this.getView();
        if (component == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        Rectangle rectangle2 = this.getBounds();
        n = this.positionAdjustment(rectangle2.width, rectangle.width, rectangle.x);
        n2 = this.positionAdjustment(rectangle2.height, rectangle.height, rectangle.y);
        if (n != 0 || n2 != 0) {
            Point point = this.getViewPosition();
            this.setViewPosition(new Point(point.x - n, point.y - n2));
            this.scrollUnderway = false;
        }
    }

    private int positionAdjustment(int n, int n2, int n3) {
        if (n3 >= 0 && n2 + n3 <= n) {
            return 0;
        }
        if (n3 <= 0 && n2 + n3 >= n) {
            return 0;
        }
        if (n3 > 0 && n2 <= n) {
            return -n3 + n - n2;
        }
        if (n3 >= 0 && n2 >= n) {
            return -n3;
        }
        if (n3 <= 0 && n2 <= n) {
            return -n3;
        }
        if (n3 < 0 && n2 >= n) {
            return -n3 + n - n2;
        }
        return 0;
    }

    public final void setBorder(Border border) {
        if (border != null) {
            throw new IllegalArgumentException("JViewport.setBorder() not supported");
        }
    }

    public final Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    private Graphics getBackingStoreGraphics(Graphics graphics) {
        Graphics graphics2 = this.backingStoreImage.getGraphics();
        graphics2.setColor(graphics.getColor());
        graphics2.setFont(graphics.getFont());
        graphics2.setClip(graphics.getClipBounds());
        return graphics2;
    }

    private void paintViaBackingStore(Graphics graphics) {
        Graphics graphics2 = this.getBackingStoreGraphics(graphics);
        super.paint(graphics2);
        graphics.drawImage(this.backingStoreImage, 0, 0, this);
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n == 0 || n2 == 0) {
            return;
        }
        if (!this.backingStore) {
            super.paint(graphics);
            this.lastPaintPosition = this.getViewLocation();
            return;
        }
        if (this.backingStoreImage == null) {
            this.backingStoreImage = this.createImage(n, n2);
            this.paintViaBackingStore(graphics);
        } else if (!this.scrollUnderway || this.lastPaintPosition.equals(this.getViewLocation())) {
            this.paintViaBackingStore(graphics);
        } else {
            Point point = new Point();
            Point point2 = new Point();
            Dimension dimension = new Dimension();
            Rectangle rectangle = new Rectangle();
            Point point3 = this.getViewLocation();
            int n3 = point3.x - this.lastPaintPosition.x;
            int n4 = point3.y - this.lastPaintPosition.y;
            boolean bl = this.computeBlit(n3, n4, point, point2, dimension, rectangle);
            if (!bl) {
                this.paintViaBackingStore(graphics);
            } else {
                int n5 = point2.x - point.x;
                int n6 = point2.y - point.y;
                Graphics graphics2 = this.getBackingStoreGraphics(graphics);
                graphics2.copyArea(point.x, point.y, dimension.width, dimension.height, n5, n6);
                Rectangle rectangle2 = this.getView().getBounds().intersection(rectangle);
                graphics2.setClip(rectangle2);
                super.paint(graphics2);
                graphics.drawImage(this.backingStoreImage, 0, 0, this);
            }
        }
        this.lastPaintPosition = this.getViewLocation();
        this.scrollUnderway = false;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        if (dimension.width != n3 || dimension.height != n4) {
            this.backingStoreImage = null;
        }
        super.setBounds(n, n2, n3, n4);
    }

    public boolean isBackingStoreEnabled() {
        return this.backingStore;
    }

    public void setBackingStoreEnabled(boolean bl) {
        this.backingStore = bl;
    }

    public Component getView() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0);
        }
        return null;
    }

    public void setView(Component component) {
        int n = this.getComponentCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.remove(n2);
            --n2;
        }
        this.isViewSizeSet = false;
        if (component != null) {
            super.addImpl(component, null, -1);
            this.viewListener = this.createViewListener();
            component.addComponentListener(this.viewListener);
        }
    }

    public Dimension getViewSize() {
        Component component = this.getView();
        if (component == null) {
            return new Dimension(0, 0);
        }
        if (this.isViewSizeSet) {
            return component.getSize();
        }
        return component.getPreferredSize();
    }

    public void setViewSize(Dimension dimension) {
        Dimension dimension2;
        Component component = this.getView();
        if (component != null && !dimension.equals(dimension2 = component.getSize())) {
            component.setSize(dimension);
            this.isViewSizeSet = true;
            this.fireStateChanged();
        }
    }

    public Point getViewPosition() {
        Component component = this.getView();
        if (component != null) {
            Point point = component.getLocation();
            point.x = -point.x;
            point.y = -point.y;
            return point;
        }
        return new Point(0, 0);
    }

    private Point getViewLocation() {
        Component component = this.getView();
        if (component != null) {
            return component.getLocation();
        }
        return new Point(0, 0);
    }

    public void setViewPosition(Point point) {
        Component component = this.getView();
        if (component != null && !(point = new Point(-point.x, -point.y)).equals(component.getLocation())) {
            this.scrollUnderway = true;
            component.setLocation(point);
            this.fireStateChanged();
        }
    }

    public Rectangle getViewRect() {
        return new Rectangle(this.getViewPosition(), this.getExtentSize());
    }

    protected boolean computeBlit(int n, int n2, Point point, Point point2, Dimension dimension, Rectangle rectangle) {
        int n3 = Math.abs(n);
        int n4 = Math.abs(n2);
        Dimension dimension2 = this.getExtentSize();
        if (n == 0 && n2 != 0 && n4 < dimension2.height) {
            if (n2 < 0) {
                point.y = -n2;
                point2.y = 0;
                rectangle.y = dimension2.height + n2;
            } else {
                point.y = 0;
                point2.y = n2;
                rectangle.y = 0;
            }
            point2.x = 0;
            point.x = 0;
            rectangle.x = 0;
            dimension.width = dimension2.width;
            dimension.height = dimension2.height - n4;
            rectangle.width = dimension2.width;
            rectangle.height = n4;
            return true;
        }
        if (n2 == 0 && n != 0 && n3 < dimension2.width) {
            if (n < 0) {
                point.x = -n;
                point2.x = 0;
                rectangle.x = dimension2.width + n;
            } else {
                point.x = 0;
                point2.x = n;
                rectangle.x = 0;
            }
            point2.y = 0;
            point.y = 0;
            rectangle.y = 0;
            dimension.width = dimension2.width - n3;
            dimension.height = dimension2.height;
            rectangle.y = 0;
            rectangle.width = n3;
            rectangle.height = dimension2.height;
            return true;
        }
        return false;
    }

    public Dimension getExtentSize() {
        return this.getSize();
    }

    public Dimension toViewCoordinates(Dimension dimension) {
        return new Dimension(dimension);
    }

    public Point toViewCoordinates(Point point) {
        return new Point(point);
    }

    public void setExtentSize(Dimension dimension) {
        Dimension dimension2 = this.getExtentSize();
        if (!dimension.equals(dimension2)) {
            this.setSize(dimension);
            this.fireStateChanged();
        }
    }

    protected ViewListener createViewListener() {
        return new ViewListener();
    }

    protected LayoutManager createLayoutManager() {
        return new ViewportLayout();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = JComponent.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : (class$com$sun$java$swing$event$ChangeListener = JComponent.class$("com.sun.java.swing.event.ChangeListener")), changeListener);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$ChangeListener != null ? class$com$sun$java$swing$event$ChangeListener : JComponent.class$("com.sun.java.swing.event.ChangeListener"))) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
            }
            n -= 2;
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        Container container = this.getParent();
        if (container != null) {
            container.repaint(l, n + this.getX(), n2 + this.getY(), n3, n4);
            return;
        }
        super.repaint(l, n, n2, n3, n4);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJViewport();
        }
        return this.accessibleContext;
    }

    protected class ViewListener
    extends ComponentAdapter
    implements Serializable {
        public void componentResized(ComponentEvent componentEvent) {
            JViewport.this.fireStateChanged();
        }

        ViewListener() {
            JViewport.this = JViewport.this;
        }
    }

    protected class AccessibleJViewport
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.VIEWPORT;
        }

        AccessibleJViewport() {
            JViewport.this = JViewport.this;
        }
    }
}

