/*
 * Decompiled with CFR 0.152.
 */
package Zql;

import Zql.ZConstant;
import Zql.ZExp;
import Zql.ZQuery;
import java.util.Vector;

public class ZExpression
implements ZExp {
    String op_;
    Vector operands_;

    public ZExpression(String string) {
        this.op_ = new String(string);
    }

    public ZExpression(String string, ZExp zExp) {
        this.op_ = new String(string);
        this.addOperand(zExp);
    }

    public ZExpression(String string, ZExp zExp, ZExp zExp2) {
        this.op_ = new String(string);
        this.addOperand(zExp);
        this.addOperand(zExp2);
    }

    public String getOperator() {
        return this.op_;
    }

    public void setOperands(Vector vector) {
        this.operands_ = vector;
    }

    public Vector getOperands() {
        return this.operands_;
    }

    public void addOperand(ZExp zExp) {
        if (this.operands_ == null) {
            this.operands_ = new Vector();
        }
        this.operands_.addElement(zExp);
    }

    public ZExp getOperand(int n) {
        if (this.operands_ == null || n >= this.operands_.size()) {
            return null;
        }
        return (ZExp)this.operands_.elementAt(n);
    }

    public int nbOperands() {
        if (this.operands_ == null) {
            return 0;
        }
        return this.operands_.size();
    }

    public String toReversePolish() {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.op_);
        int n = 0;
        while (n < this.nbOperands()) {
            ZExp zExp = this.getOperand(n);
            if (zExp instanceof ZExpression) {
                stringBuffer.append(" " + ((ZExpression)zExp).toReversePolish());
            } else if (zExp instanceof ZQuery) {
                stringBuffer.append(" (" + zExp.toString() + ")");
            } else {
                stringBuffer.append(" " + zExp.toString());
            }
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.needPar(this.op_)) {
            stringBuffer.append("(");
        }
        switch (this.nbOperands()) {
            case 1: {
                ZExp zExp = this.getOperand(0);
                if (zExp instanceof ZConstant) {
                    if (this.isAggregate(this.op_)) {
                        stringBuffer.append(String.valueOf(this.op_) + "(" + zExp.toString() + ")");
                        break;
                    }
                    stringBuffer.append(String.valueOf(this.op_) + " " + zExp.toString());
                    break;
                }
                if (zExp instanceof ZQuery) {
                    stringBuffer.append(String.valueOf(this.op_) + " (" + zExp.toString() + ")");
                    break;
                }
                stringBuffer.append(String.valueOf(this.op_) + " " + zExp.toString());
                break;
            }
            case 3: {
                if (this.op_.toUpperCase().endsWith("BETWEEN")) {
                    stringBuffer.append(String.valueOf(this.getOperand(0).toString()) + " " + this.op_ + " " + this.getOperand(1).toString() + " AND " + this.getOperand(2).toString());
                    break;
                }
            }
            default: {
                boolean bl = this.op_.equals("IN") || this.op_.equals("NOT IN");
                int n = this.nbOperands();
                int n2 = 0;
                while (n2 < n) {
                    ZExp zExp;
                    if (bl && n2 == 1) {
                        stringBuffer.append(" " + this.op_ + " (");
                    }
                    if ((zExp = this.getOperand(n2)) instanceof ZQuery && !bl) {
                        stringBuffer.append("(" + zExp.toString() + ")");
                    } else {
                        stringBuffer.append(zExp.toString());
                    }
                    if (n2 < n - 1) {
                        if (this.op_.equals(",") || bl && n2 > 0) {
                            stringBuffer.append(", ");
                        } else if (!bl) {
                            stringBuffer.append(" " + this.op_ + " ");
                        }
                    }
                    ++n2;
                }
                if (!bl) break;
                stringBuffer.append(")");
            }
        }
        if (this.needPar(this.op_)) {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private boolean isAggregate(String string) {
        return (string = string.toUpperCase()).equals("SUM") || string.equals("AVG") || string.equals("MAX") || string.equals("MIN");
    }

    private boolean needPar(String string) {
        return !(string = string.toUpperCase()).equals("ANY") && !string.equals("ALL") && !string.equals("UNION") && !this.isAggregate(string);
    }
}

