/*
 * Decompiled with CFR 0.152.
 */
package Zql;

import Zql.ZConstant;
import Zql.ZExp;
import Zql.ZExpression;
import Zql.ZTuple;
import Zql.ZqlParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.sql.SQLException;
import java.util.Vector;

public class ZEval {
    public boolean eval(ZTuple zTuple, ZExp zExp) throws SQLException {
        if (zTuple == null || zExp == null) {
            throw new SQLException("ZEval.eval(): null argument or operator");
        }
        if (!(zExp instanceof ZExpression)) {
            throw new SQLException("ZEval.eval(): only expressions are supported");
        }
        ZExpression zExpression = (ZExpression)zExp;
        String string = zExpression.getOperator();
        if (string.equals("AND")) {
            boolean bl = true;
            int n = 0;
            while (n < zExpression.nbOperands()) {
                bl &= this.eval(zTuple, zExpression.getOperand(n));
                ++n;
            }
            return bl;
        }
        if (string.equals("OR")) {
            boolean bl = false;
            int n = 0;
            while (n < zExpression.nbOperands()) {
                bl |= this.eval(zTuple, zExpression.getOperand(n));
                ++n;
            }
            return bl;
        }
        if (string.equals("NOT")) {
            return !this.eval(zTuple, zExpression.getOperand(0));
        }
        if (string.equals("=")) {
            return this.evalCmp(zTuple, zExpression.getOperands()) == 0.0;
        }
        if (string.equals("!=")) {
            return this.evalCmp(zTuple, zExpression.getOperands()) != 0.0;
        }
        if (string.equals("<>")) {
            return this.evalCmp(zTuple, zExpression.getOperands()) != 0.0;
        }
        if (string.equals("#")) {
            throw new SQLException("ZEval.eval(): Operator # not supported");
        }
        if (string.equals(">")) {
            return this.evalCmp(zTuple, zExpression.getOperands()) > 0.0;
        }
        if (string.equals(">=")) {
            return this.evalCmp(zTuple, zExpression.getOperands()) >= 0.0;
        }
        if (string.equals("<")) {
            return this.evalCmp(zTuple, zExpression.getOperands()) < 0.0;
        }
        if (string.equals("<=")) {
            return this.evalCmp(zTuple, zExpression.getOperands()) <= 0.0;
        }
        if (string.equals("BETWEEN") || string.equals("NOT BETWEEN")) {
            ZExpression zExpression2 = new ZExpression("AND", new ZExpression(">=", zExpression.getOperand(0), zExpression.getOperand(1)), new ZExpression("<=", zExpression.getOperand(0), zExpression.getOperand(2)));
            if (string.equals("NOT BETWEEN")) {
                return !this.eval(zTuple, zExpression2);
            }
            return this.eval(zTuple, zExpression2);
        }
        if (string.equals("LIKE") || string.equals("NOT LIKE")) {
            throw new SQLException("ZEval.eval(): Operator (NOT) LIKE not supported");
        }
        if (string.equals("IN") || string.equals("NOT IN")) {
            ZExpression zExpression3 = new ZExpression("OR");
            int n = 1;
            while (n < zExpression.nbOperands()) {
                zExpression3.addOperand(new ZExpression("=", zExpression.getOperand(0), zExpression.getOperand(n)));
                ++n;
            }
            if (string.equals("NOT IN")) {
                return !this.eval(zTuple, zExpression3);
            }
            return this.eval(zTuple, zExpression3);
        }
        if (string.equals("IS NULL")) {
            if (zExpression.nbOperands() <= 0 || zExpression.getOperand(0) == null) {
                return true;
            }
            ZExp zExp2 = zExpression.getOperand(0);
            if (zExp2 instanceof ZConstant) {
                return ((ZConstant)zExp2).getType() == 1;
            }
            throw new SQLException("ZEval.eval(): can't eval IS (NOT) NULL");
        }
        if (string.equals("IS NOT NULL")) {
            ZExpression zExpression4 = new ZExpression("IS NULL");
            zExpression4.setOperands(zExpression.getOperands());
            return !this.eval(zTuple, zExpression4);
        }
        throw new SQLException("ZEval.eval(): Unknown operator " + string);
    }

    double evalCmp(ZTuple zTuple, Vector vector) throws SQLException {
        if (vector.size() < 2) {
            throw new SQLException("ZEval.evalCmp(): Trying to compare less than two values");
        }
        if (vector.size() > 2) {
            throw new SQLException("ZEval.evalCmp(): Trying to compare more than two values");
        }
        Object object = null;
        Object object2 = null;
        object = this.evalExpValue(zTuple, (ZExp)vector.elementAt(0));
        object2 = this.evalExpValue(zTuple, (ZExp)vector.elementAt(1));
        if (object instanceof String || object2 instanceof String) {
            return object.equals(object2) ? 0 : -1;
        }
        if (object instanceof Number && object2 instanceof Number) {
            return ((Number)object).doubleValue() - ((Number)object2).doubleValue();
        }
        throw new SQLException("ZEval.evalCmp(): can't compare (" + object.toString() + ") with (" + object2.toString() + ")");
    }

    double evalNumericExp(ZTuple zTuple, ZExpression zExpression) throws SQLException {
        if (zTuple == null || zExpression == null || zExpression.getOperator() == null) {
            throw new SQLException("ZEval.eval(): null argument or operator");
        }
        String string = zExpression.getOperator();
        Object object = this.evalExpValue(zTuple, zExpression.getOperand(0));
        if (!(object instanceof Double)) {
            throw new SQLException("ZEval.evalNumericExp(): expression not numeric");
        }
        Double d = (Double)object;
        if (string.equals("+")) {
            double d2 = d;
            int n = 1;
            while (n < zExpression.nbOperands()) {
                Object object2 = this.evalExpValue(zTuple, zExpression.getOperand(n));
                d2 += ((Number)object2).doubleValue();
                ++n;
            }
            return d2;
        }
        if (string.equals("-")) {
            double d3 = d;
            if (zExpression.nbOperands() == 1) {
                return -d3;
            }
            int n = 1;
            while (n < zExpression.nbOperands()) {
                Object object3 = this.evalExpValue(zTuple, zExpression.getOperand(n));
                d3 -= ((Number)object3).doubleValue();
                ++n;
            }
            return d3;
        }
        if (string.equals("*")) {
            double d4 = d;
            int n = 1;
            while (n < zExpression.nbOperands()) {
                Object object4 = this.evalExpValue(zTuple, zExpression.getOperand(n));
                d4 *= ((Number)object4).doubleValue();
                ++n;
            }
            return d4;
        }
        if (string.equals("/")) {
            double d5 = d;
            int n = 1;
            while (n < zExpression.nbOperands()) {
                Object object5 = this.evalExpValue(zTuple, zExpression.getOperand(n));
                d5 /= ((Number)object5).doubleValue();
                ++n;
            }
            return d5;
        }
        if (string.equals("**")) {
            double d6 = d;
            int n = 1;
            while (n < zExpression.nbOperands()) {
                Object object6 = this.evalExpValue(zTuple, zExpression.getOperand(n));
                d6 = Math.pow(d6, ((Number)object6).doubleValue());
                ++n;
            }
            return d6;
        }
        throw new SQLException("ZEval.evalNumericExp(): Unknown operator " + string);
    }

    public Object evalExpValue(ZTuple zTuple, ZExp zExp) throws SQLException {
        Object object = null;
        if (zExp instanceof ZConstant) {
            ZConstant zConstant = (ZConstant)zExp;
            switch (zConstant.getType()) {
                case 0: {
                    Object object2 = zTuple.getAttValue(zConstant.getValue());
                    if (object2 == null) {
                        throw new SQLException("ZEval.evalExpValue(): unknown column " + zConstant.getValue());
                    }
                    try {
                        object = new Double(object2.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        object = object2;
                    }
                    break;
                }
                case 2: {
                    object = new Double(zConstant.getValue());
                    break;
                }
                default: {
                    object = zConstant.getValue();
                    break;
                }
            }
        } else if (zExp instanceof ZExpression) {
            object = new Double(this.evalNumericExp(zTuple, (ZExpression)zExp));
        }
        return object;
    }

    public static void main(String[] stringArray) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("test.db"));
            String string = bufferedReader.readLine();
            ZTuple zTuple = new ZTuple(string);
            ZqlParser zqlParser = new ZqlParser();
            ZEval zEval = new ZEval();
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                zTuple.setRow(string);
                BufferedReader bufferedReader2 = new BufferedReader(new FileReader("test.sql"));
                while ((string2 = bufferedReader2.readLine()) != null) {
                    zqlParser.initParser(new ByteArrayInputStream(string2.getBytes()));
                    ZExp zExp = zqlParser.readExpression();
                    System.out.print(String.valueOf(string) + ", " + string2 + ", ");
                    System.out.println(zEval.eval(zTuple, zExp));
                }
                bufferedReader2.close();
            }
            bufferedReader.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

