/*
 * @(#)hprof_object.h	1.2 98/08/18
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef _HPROF_OBJECT_H
#define _HPROF_OBJECT_H

/* Live objects */
typedef struct hprof_objmap_t {
    struct hprof_objmap_t *next;
    jobjectID obj_id;                  /* object id */
    jint arena_id;                     /* arena_id */
    struct hprof_site_t *site;         /* alloc site */
    unsigned int size;                 /* object size */
} hprof_objmap_t;

void hprof_objmap_init(void);
hprof_objmap_t * hprof_objmap_lookup(jobjectID obj_id);
void hprof_objmap_print(hprof_objmap_t *objmap);

void hprof_obj_alloc_event(JNIEnv *env_id,
			   jobjectID class_id,
			   int is_array,
			   int size,
			   jobjectID obj_id,
			   jint arena_id,
			   int requested);
void hprof_obj_free_event(JNIEnv *env_id,
			  jobjectID obj_id);
void hprof_delete_arena_event(JNIEnv *env_id, 
			      jint arena_id);
void hprof_obj_move_event(JNIEnv *env_id,
			  jobjectID obj_id,
			  jint arena_id,
			  jobjectID new_obj_id,
			  jint new_arena_id);
hprof_objmap_t * hprof_fetch_object_info(jobjectID obj);
void hprof_print_object_info(jobjectID obj);

#endif /* _HPROF_OBJECT_H */
